/*
 * Decompiled with CFR 0.152.
 */
package com.mware.web.auth.usernamepassword.routes;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.mware.core.exception.BcAccessDeniedException;
import com.mware.core.model.role.AuthorizationRepository;
import com.mware.core.model.user.AuthorizationContext;
import com.mware.core.model.user.UserNameAuthorizationContext;
import com.mware.core.model.user.UserPropertyPrivilegeRepository;
import com.mware.core.model.user.UserRepository;
import com.mware.core.security.AuditService;
import com.mware.core.user.SystemUser;
import com.mware.core.user.User;
import com.mware.security.ldap.LDAPAuthenticator;
import com.mware.web.CurrentUser;
import com.mware.web.framework.ParameterizedHandler;
import com.mware.web.framework.annotations.Handle;
import com.mware.web.framework.annotations.Required;
import com.mware.web.util.RemoteAddressUtil;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONObject;

public class Login
implements ParameterizedHandler {
    private final UserRepository userRepository;
    private final AuditService auditService;
    private LDAPAuthenticator ldapAuthenticator;
    private AuthorizationRepository authorizationRepository;
    private final UserPropertyPrivilegeRepository privilegeRepository;

    @Inject
    public Login(UserRepository userRepository, AuditService auditService, LDAPAuthenticator ldapAuthenticator, AuthorizationRepository authorizationRepository, UserPropertyPrivilegeRepository privilegeRepository) {
        this.userRepository = userRepository;
        this.auditService = auditService;
        this.ldapAuthenticator = ldapAuthenticator;
        this.authorizationRepository = authorizationRepository;
        this.privilegeRepository = privilegeRepository;
    }

    @Handle
    public JSONObject handle(HttpServletRequest request, @Required(name="username") String username, @Required(name="password") String password) {
        username = username.trim();
        password = password.trim();
        User user = this.userRepository.findByUsername(username);
        if (this.ldapAuthenticator.isLdapEnabled()) {
            if (this.ldapAuthenticator.isPasswordValid(username, password)) {
                if (user == null) {
                    user = this.userRepository.findOrAddUser(username, username, null, password);
                }
                this.addRolesFromLdapGroups(user, this.ldapAuthenticator.getGroupMemberships(username));
                if (this.ldapAuthenticator.hasAdminFlag(username)) {
                    Object[] adminPrivileges = new String[]{"READ", "COMMENT", "EDIT", "PUBLISH", "SEARCH_SAVE_GLOBAL", "HISTORY_READ", "ADMIN", "ONTOLOGY_ADD", "ONTOLOGY_PUBLISH"};
                    this.privilegeRepository.setPrivileges(user, (Set)ImmutableSet.copyOf((Object[])adminPrivileges), (User)new SystemUser());
                }
                return this.loginUser(user, username, request);
            }
            throw new BcAccessDeniedException("", user, null);
        }
        if (user != null && this.userRepository.isPasswordValid(user, password)) {
            return this.loginUser(user, username, request);
        }
        throw new BcAccessDeniedException("", user, null);
    }

    private void addRolesFromLdapGroups(User user, Set<String> groupMemberships) {
        Set existingRoles = this.authorizationRepository.getRoleNames(user);
        for (String group : groupMemberships) {
            if (existingRoles.contains(group)) continue;
            this.authorizationRepository.addRoleToUser(user, group, (User)new SystemUser());
        }
    }

    private JSONObject loginUser(User user, String username, HttpServletRequest request) {
        UserNameAuthorizationContext authorizationContext = new UserNameAuthorizationContext(username, RemoteAddressUtil.getClientIpAddr((HttpServletRequest)request));
        this.userRepository.updateUser(user, (AuthorizationContext)authorizationContext);
        CurrentUser.set((HttpServletRequest)request, (User)user);
        this.auditService.auditLogin(user);
        JSONObject json = new JSONObject();
        json.put("status", (Object)"OK");
        return json;
    }
}

