/*
 * Decompiled with CFR 0.152.
 */
package com.mware.web.auth.usernamepassword.routes;

import com.google.inject.Inject;
import com.mware.core.model.user.UserRepository;
import com.mware.core.user.User;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.web.BadRequestException;
import com.mware.web.BcResponse;
import com.mware.web.framework.ParameterizedHandler;
import com.mware.web.framework.annotations.Handle;
import com.mware.web.framework.annotations.Required;
import com.mware.web.model.ClientApiSuccess;
import java.time.ZonedDateTime;

public class ChangePassword
implements ParameterizedHandler {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(ChangePassword.class);
    public static final String TOKEN_PARAMETER_NAME = "token";
    public static final String NEW_PASSWORD_PARAMETER_NAME = "newPassword";
    public static final String NEW_PASSWORD_CONFIRMATION_PARAMETER_NAME = "newPasswordConfirmation";
    private final UserRepository userRepository;

    @Inject
    public ChangePassword(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    @Handle
    public ClientApiSuccess handle(@Required(name="token") String token, @Required(name="newPassword") String newPassword, @Required(name="newPasswordConfirmation") String newPasswordConfirmation) throws Exception {
        User user = this.userRepository.findByPasswordResetToken(token);
        if (user == null) {
            throw new BadRequestException("invalid token");
        }
        if (!user.getPasswordResetTokenExpirationDate().isAfter(ZonedDateTime.now())) {
            throw new BadRequestException("expired token");
        }
        if (newPassword.length() <= 0) {
            throw new BadRequestException(NEW_PASSWORD_PARAMETER_NAME, "new password may not be blank");
        }
        if (!newPassword.equals(newPasswordConfirmation)) {
            throw new BadRequestException(NEW_PASSWORD_CONFIRMATION_PARAMETER_NAME, "new password and new password confirmation do not match");
        }
        this.userRepository.setPassword(user, newPassword);
        this.userRepository.clearPasswordResetTokenAndExpirationDate(user);
        LOGGER.info("changed password for user: %s", new Object[]{user.getUsername()});
        return BcResponse.SUCCESS;
    }
}

