/*
 * Decompiled with CFR 0.152.
 */
package com.mware.web.auth.usernamepassword;

import com.google.inject.Inject;
import com.mware.core.bootstrap.InjectHelper;
import com.mware.core.config.Configuration;
import com.mware.core.model.Description;
import com.mware.core.model.Name;
import com.mware.web.WebApp;
import com.mware.web.WebAppPlugin;
import com.mware.web.auth.usernamepassword.ForgotPasswordConfiguration;
import com.mware.web.auth.usernamepassword.routes.ChangePassword;
import com.mware.web.auth.usernamepassword.routes.Login;
import com.mware.web.auth.usernamepassword.routes.LookupToken;
import com.mware.web.auth.usernamepassword.routes.RequestToken;
import com.mware.web.framework.Handler;
import javax.servlet.ServletContext;

@Name(value="Username/Password Authentication")
@Description(value="Allows authenticating using a username and password")
public class UsernamePasswordWebAppPlugin
implements WebAppPlugin {
    public static final String LOOKUP_TOKEN_ROUTE = "/forgotPassword";
    public static final String CHANGE_PASSWORD_ROUTE = "/forgotPassword/changePassword";
    private Configuration configuration;

    public void init(WebApp app, ServletContext servletContext, Handler authenticationHandler) {
        app.registerBeforeAuthenticationJavaScript("/com/mware/web/auth/usernamepassword/plugin.js");
        app.registerJavaScriptTemplate("/com/mware/web/auth/usernamepassword/templates/login.hbs");
        app.registerJavaScript("/com/mware/web/auth/usernamepassword/authentication.js", Boolean.valueOf(false));
        app.registerLess("/com/mware/web/auth/usernamepassword/less/login.less");
        app.post("/login", new Handler[]{(Handler)InjectHelper.getInstance(Login.class)});
        ForgotPasswordConfiguration forgotPasswordConfiguration = new ForgotPasswordConfiguration();
        this.configuration.setConfigurables((Object)forgotPasswordConfiguration, "forgotPassword");
        this.configuration.set("web.ui.forgotPassword.enabled", (Object)forgotPasswordConfiguration.isEnabled());
        if (forgotPasswordConfiguration.isEnabled()) {
            app.post("/forgotPassword/requestToken", new Class[]{RequestToken.class});
            app.get(LOOKUP_TOKEN_ROUTE, new Class[]{LookupToken.class});
            app.post(CHANGE_PASSWORD_ROUTE, new Class[]{ChangePassword.class});
        }
    }

    @Inject
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }
}

