/*
 * Decompiled with CFR 0.152.
 */
package com.mware.web.auth.usernamepassword;

import com.mware.core.config.Configurable;
import com.mware.core.config.PostConfigurationValidator;

public class ForgotPasswordConfiguration {
    public static final String CONFIGURATION_PREFIX = "forgotPassword";
    private boolean enabled;
    private int tokenLifetimeMinutes;
    private String emailFrom;
    private String emailReplyTo;
    private String emailSubject;
    private String newPasswordLabel;
    private String newPasswordConfirmationLabel;

    @Configurable(name="enabled", defaultValue="false")
    public void setEnabled(String enabled) {
        this.enabled = Boolean.valueOf(enabled);
    }

    @Configurable(name="tokenLifetimeMinutes", defaultValue="60")
    public void setTokenLifetimeMinutes(int tokenLifetimeMinutes) {
        this.tokenLifetimeMinutes = tokenLifetimeMinutes;
    }

    @Configurable(name="emailFrom", required=false)
    public void setEmailFrom(String emailFrom) {
        this.emailFrom = emailFrom;
    }

    @Configurable(name="emailReplyTo", required=false)
    public void setEmailReplyTo(String emailReplyTo) {
        this.emailReplyTo = emailReplyTo;
    }

    @Configurable(name="emailSubject", defaultValue="Forgotten BigConnect Password")
    public void setEmailSubject(String emailSubject) {
        this.emailSubject = emailSubject;
    }

    @Configurable(name="newPasswordLabel", defaultValue="New Password")
    public void setNewPasswordLabel(String newPasswordLabel) {
        this.newPasswordLabel = newPasswordLabel;
    }

    @Configurable(name="newPasswordConfirmationLabel", defaultValue="New Password (again)")
    public void setNewPasswordConfirmationLabel(String newPasswordConfirmationLabel) {
        this.newPasswordConfirmationLabel = newPasswordConfirmationLabel;
    }

    @PostConfigurationValidator(description="mail from address settings are required if the forgot password feature is enabled")
    public boolean validateMailServerSettings() {
        return !this.enabled || this.isNotNullOrBlank(this.emailFrom);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getTokenLifetimeMinutes() {
        return this.tokenLifetimeMinutes;
    }

    public String getEmailFrom() {
        return this.emailFrom;
    }

    public String getEmailReplyTo() {
        return this.emailReplyTo;
    }

    public String getEmailSubject() {
        return this.emailSubject;
    }

    public String getNewPasswordLabel() {
        return this.newPasswordLabel;
    }

    public String getNewPasswordConfirmationLabel() {
        return this.newPasswordConfirmationLabel;
    }

    private boolean isNotNullOrBlank(String s) {
        return s != null && s.trim().length() > 0;
    }

    public static enum MailServerAuthentication {
        NONE,
        TLS,
        SSL;

    }
}

