/*
 * Decompiled with CFR 0.152.
 */
package com.mware.web.auth.usernameonly.routes;

import com.google.inject.Inject;
import com.mware.core.model.user.AuthorizationContext;
import com.mware.core.model.user.UserNameAuthorizationContext;
import com.mware.core.model.user.UserRepository;
import com.mware.core.security.AuditService;
import com.mware.core.user.User;
import com.mware.web.CurrentUser;
import com.mware.web.framework.ParameterizedHandler;
import com.mware.web.framework.annotations.Handle;
import com.mware.web.framework.utils.UrlUtils;
import com.mware.web.util.RemoteAddressUtil;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONObject;

public class Login
implements ParameterizedHandler {
    private final UserRepository userRepository;
    private final AuditService auditService;

    @Inject
    public Login(UserRepository userRepository, AuditService auditService) {
        this.userRepository = userRepository;
        this.auditService = auditService;
    }

    @Handle
    public JSONObject handle(HttpServletRequest request) {
        String username = UrlUtils.urlDecode((String)request.getParameter("username")).trim().toLowerCase();
        User user = this.userRepository.findByUsername(username);
        if (user == null) {
            String randomPassword = UserRepository.createRandomPassword();
            user = this.userRepository.findOrAddUser(username, username, null, randomPassword);
        }
        UserNameAuthorizationContext authorizationContext = new UserNameAuthorizationContext(username, RemoteAddressUtil.getClientIpAddr((HttpServletRequest)request));
        this.userRepository.updateUser(user, (AuthorizationContext)authorizationContext);
        CurrentUser.set((HttpServletRequest)request, (User)user);
        this.auditService.auditLogin(user);
        JSONObject json = new JSONObject();
        json.put("status", (Object)"OK");
        return json;
    }
}

