/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.accumulo.util;

import com.google.common.base.Preconditions;
import com.mware.ge.accumulo.util.ConnectorUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.ScannerOptions;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.TabletServerBatchReaderIterator;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.NamingThreadFactory;

public class GeTabletServerBatchReader
extends ScannerOptions
implements BatchScanner {
    private final String tableId;
    private final int numThreads;
    private final ClientContext context;
    private final Authorizations authorizations;
    private ArrayList<Range> ranges;
    private static final ExecutorService queryThreadPool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 30L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new NamingThreadFactory("Accumulo batch scanner read ahead thread"));

    public GeTabletServerBatchReader(Connector connector, String tableName, Authorizations authorizations, int numQueryThreads) throws TableNotFoundException {
        ClientContext context = ConnectorUtils.getContext(connector);
        String tableId = Tables.getTableId((Instance)connector.getInstance(), (String)tableName);
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"context is null");
        Preconditions.checkArgument((tableId != null ? 1 : 0) != 0, (Object)"tableId is null");
        Preconditions.checkArgument((authorizations != null ? 1 : 0) != 0, (Object)"authorizations is null");
        this.context = context;
        this.authorizations = authorizations;
        this.tableId = tableId;
        this.numThreads = numQueryThreads;
        this.ranges = null;
    }

    public Authorizations getAuthorizations() {
        return this.authorizations;
    }

    public void setRanges(Collection<Range> ranges) {
        if (ranges == null || ranges.size() == 0) {
            throw new IllegalArgumentException("ranges must be non null and contain at least 1 range");
        }
        this.ranges = new ArrayList<Range>(ranges);
    }

    public Iterator<Map.Entry<Key, Value>> iterator() {
        if (this.ranges == null) {
            throw new IllegalStateException("ranges not set");
        }
        return new TabletServerBatchReaderIterator(this.context, this.tableId, this.authorizations, this.ranges, this.numThreads, queryThreadPool, (ScannerOptions)this, this.timeOut);
    }
}

