/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.accumulo.util;

import com.google.common.primitives.Longs;
import com.mware.ge.GeException;
import com.mware.ge.Graph;
import com.mware.ge.GraphConfiguration;
import com.mware.ge.Property;
import com.mware.ge.accumulo.AccumuloGraphConfiguration;
import com.mware.ge.accumulo.StreamingPropertyValueTableDataRef;
import com.mware.ge.accumulo.keys.DataTableRowKey;
import com.mware.ge.store.mutations.ElementMutationBuilder;
import com.mware.ge.store.mutations.StoreMutation;
import com.mware.ge.store.util.StreamingPropertyValueStorageStrategy;
import com.mware.ge.values.storable.StreamingPropertyValue;
import com.mware.ge.values.storable.StreamingPropertyValueRef;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.accumulo.core.data.Value;

public class DataInDataTableStreamingPropertyValueStorageStrategy
implements StreamingPropertyValueStorageStrategy {
    public static final int DEFAULT_PART_SIZE = 10240;
    private final int dataInDataTablePartSize;

    public DataInDataTableStreamingPropertyValueStorageStrategy(Graph graph, GraphConfiguration configuration) {
        if (!(configuration instanceof AccumuloGraphConfiguration)) {
            throw new GeException("Expected " + AccumuloGraphConfiguration.class.getName() + " found " + configuration.getClass().getName());
        }
        AccumuloGraphConfiguration config = (AccumuloGraphConfiguration)configuration;
        this.dataInDataTablePartSize = config.getInt("streamingPropertyValueStorageStrategy.partSize", 10240);
    }

    public StreamingPropertyValueRef saveStreamingPropertyValue(ElementMutationBuilder elementMutationBuilder, String rowKey, Property property, StreamingPropertyValue streamingPropertyValue) {
        try {
            int read;
            String dataTableRowKey = new DataTableRowKey(rowKey, property).getRowKey();
            InputStream in = streamingPropertyValue.getInputStream();
            if (in.markSupported()) {
                in.reset();
            }
            byte[] buffer = new byte[this.dataInDataTablePartSize];
            long offset = 0L;
            while ((read = in.read(buffer)) > 0) {
                StoreMutation dataMutation = new StoreMutation(dataTableRowKey);
                String columnQualifier = String.format("%08x", offset);
                if (property.getTimestamp() != null) {
                    byte[] buf = new byte[read];
                    System.arraycopy(buffer, 0, buf, 0, read);
                    dataMutation.put((CharSequence)"d", (CharSequence)columnQualifier, property.getTimestamp().longValue(), buf);
                } else {
                    dataMutation.put((CharSequence)"d", (CharSequence)columnQualifier, new Value(buffer, 0, read).get());
                }
                elementMutationBuilder.saveDataMutation(dataMutation);
                offset += (long)read;
            }
            StoreMutation dataMutation = new StoreMutation(dataTableRowKey);
            if (property.getTimestamp() != null) {
                dataMutation.put((CharSequence)"a", (CharSequence)"length", property.getTimestamp().longValue(), Longs.toByteArray((long)offset));
            } else {
                dataMutation.put((CharSequence)"a", (CharSequence)"length", Longs.toByteArray((long)offset));
            }
            elementMutationBuilder.saveDataMutation(dataMutation);
            return new StreamingPropertyValueTableDataRef(dataTableRowKey, streamingPropertyValue, offset);
        }
        catch (Exception ex) {
            throw new GeException("Could not store streaming property value", (Throwable)ex);
        }
    }

    public void close() {
    }

    public List<InputStream> getInputStreams(List<StreamingPropertyValue> streamingPropertyValues) {
        return streamingPropertyValues.stream().map(StreamingPropertyValue::getInputStream).collect(Collectors.toList());
    }
}

