/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.accumulo.tools;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;

public class HDFSGraphUtil {
    static FileSystem getHdfsFileSystem(String fs, boolean useDatanodeHostname, String hadoopUsername) throws IOException, URISyntaxException, InterruptedException {
        Configuration conf = new Configuration();
        if (useDatanodeHostname) {
            conf.set("dfs.client.use.datanode.hostname", "true");
        }
        if (hadoopUsername != null) {
            return FileSystem.get((URI)new URI(fs), (Configuration)conf, (String)hadoopUsername);
        }
        return FileSystem.get((URI)new URI(fs), (Configuration)conf);
    }

    static Path getPath(FileSystem fileSystem, String hdfsDirectory, String fileName) {
        if (!hdfsDirectory.startsWith("hdfs")) {
            hdfsDirectory = fileSystem.getUri() + hdfsDirectory;
        }
        return new Path(hdfsDirectory, fileName);
    }

    static Path getPath(FileSystem fileSystem, String hdfsDirectory) {
        if (!hdfsDirectory.startsWith("hdfs")) {
            hdfsDirectory = fileSystem.getUri() + hdfsDirectory;
        }
        return new Path(hdfsDirectory);
    }

    static Path createFile(FileSystem fileSystem, String dir, String filename) throws IOException {
        Path backupFilePath;
        Path rootDirPath = HDFSGraphUtil.getPath(fileSystem, dir);
        if (!fileSystem.exists(rootDirPath)) {
            fileSystem.mkdirs(rootDirPath);
        }
        if (!fileSystem.exists(backupFilePath = HDFSGraphUtil.getPath(fileSystem, dir, filename))) {
            fileSystem.createNewFile(backupFilePath);
        }
        return backupFilePath;
    }

    static List<String> listFiles(FileSystem fileSystem, String dir, Optional<String> filenamePrefix) throws IOException {
        Path backupFolderPath = HDFSGraphUtil.getPath(fileSystem, dir);
        RemoteIterator fileIterator = fileSystem.listFiles(backupFolderPath, false);
        ArrayList<String> filesThatMatch = new ArrayList<String>();
        while (fileIterator.hasNext()) {
            LocatedFileStatus fileStatus = (LocatedFileStatus)fileIterator.next();
            if (filenamePrefix.isPresent()) {
                if (!fileStatus.getPath().getName().startsWith(filenamePrefix.get())) continue;
                filesThatMatch.add(fileStatus.getPath().getName());
                continue;
            }
            filesThatMatch.add(fileStatus.getPath().getName());
        }
        return filesThatMatch;
    }
}

