/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.accumulo.mapreduce;

import java.io.IOException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.mapreduce.AccumuloOutputFormat;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.data.Mutation;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class AccumuloElementOutputFormat
extends OutputFormat<Text, Mutation> {
    private AccumuloOutputFormat accumuloOutputFormat = new AccumuloOutputFormat();

    public static void setOutputInfo(Job job, String instanceName, String zooKeepers, String principal, AuthenticationToken token) throws AccumuloSecurityException {
        AccumuloOutputFormat.setConnectorInfo((Job)job, (String)principal, (AuthenticationToken)token);
        ClientConfiguration clientConfig = new ClientConfiguration(new Configuration[0]).withInstance(instanceName).withZkHosts(zooKeepers);
        AccumuloOutputFormat.setZooKeeperInstance((Job)job, (ClientConfiguration)clientConfig);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(Mutation.class);
    }

    public RecordWriter<Text, Mutation> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        return this.accumuloOutputFormat.getRecordWriter(context);
    }

    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
        this.accumuloOutputFormat.checkOutputSpecs(context);
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return this.accumuloOutputFormat.getOutputCommitter(context);
    }
}

