/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.accumulo.mapreduce;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.mware.ge.Authorizations;
import com.mware.ge.Edge;
import com.mware.ge.FetchHints;
import com.mware.ge.GeException;
import com.mware.ge.Property;
import com.mware.ge.Visibility;
import com.mware.ge.accumulo.AccumuloGraph;
import com.mware.ge.accumulo.iterator.EdgeIterator;
import com.mware.ge.accumulo.iterator.model.EdgeElementData;
import com.mware.ge.accumulo.iterator.model.ElementData;
import com.mware.ge.accumulo.mapreduce.AccumuloElementInputFormatBase;
import com.mware.ge.store.StorableEdge;
import com.mware.ge.store.StorableGraph;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.PeekingIterator;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;

public class AccumuloEdgeInputFormat
extends AccumuloElementInputFormatBase<Edge> {
    private static EdgeIterator edgeIterator;

    public static void setInputInfo(Job job, AccumuloGraph graph, String instanceName, String zooKeepers, String principal, AuthenticationToken token, String[] authorizations) throws AccumuloSecurityException {
        String tableName = graph.getEdgesTableName();
        AccumuloEdgeInputFormat.setInputInfo(job, instanceName, zooKeepers, principal, token, authorizations, tableName);
    }

    @Override
    protected Edge createElementFromRow(AccumuloGraph graph, PeekingIterator<Map.Entry<Key, Value>> row, Authorizations authorizations) {
        try {
            FetchHints fetchHints = graph.getDefaultFetchHints();
            EdgeElementData edgeElementData = (EdgeElementData)this.getEdgeIterator(graph).createElementDataFromRows(row);
            if (edgeElementData == null) {
                return null;
            }
            Visibility visibility = AccumuloGraph.accumuloVisibilityToVisibility(AccumuloGraph.visibilityToAccumuloVisibility(edgeElementData.visibility.toString()));
            Iterable<Property> properties = AccumuloEdgeInputFormat.makePropertiesFromElementData(graph, (ElementData)edgeElementData, graph.toIteratorFetchHints(fetchHints));
            Iterable propertyDeleteMutations = null;
            Iterable propertySoftDeleteMutations = null;
            Iterable hiddenVisibilities = Iterables.transform((Iterable)edgeElementData.hiddenVisibilities, (Function)new Function<Text, Visibility>(){

                @Nullable
                public Visibility apply(Text visibilityText) {
                    return AccumuloGraph.accumuloVisibilityToVisibility(AccumuloGraph.visibilityToAccumuloVisibility(visibilityText.toString()));
                }
            });
            ImmutableSet extendedDataTableNames = edgeElementData.extendedTableNames.size() > 0 ? ImmutableSet.copyOf((Collection)edgeElementData.extendedTableNames) : null;
            return new StorableEdge((StorableGraph)graph, edgeElementData.id.toString(), edgeElementData.outVertexId.toString(), edgeElementData.inVertexId.toString(), edgeElementData.label.toString(), null, visibility, properties, propertyDeleteMutations, propertySoftDeleteMutations, hiddenVisibilities, extendedDataTableNames, edgeElementData.timestamp, fetchHints, authorizations);
        }
        catch (Throwable ex) {
            throw new GeException("Failed to create vertex", ex);
        }
    }

    private EdgeIterator getEdgeIterator(AccumuloGraph graph) {
        if (edgeIterator == null) {
            edgeIterator = new EdgeIterator(graph.toIteratorFetchHints(graph.getDefaultFetchHints()), true);
        }
        return edgeIterator;
    }
}

