/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.accumulo;

import com.mware.ge.accumulo.iterator.util.ByteSequenceUtils;
import com.mware.ge.id.IdentityNameSubstitutionStrategy;
import com.mware.ge.id.NameSubstitutionStrategy;
import java.util.Map;
import org.apache.accumulo.core.data.ByteSequence;
import org.cache2k.Cache;
import org.cache2k.Cache2kBuilder;

public class AccumuloNameSubstitutionStrategy
implements NameSubstitutionStrategy {
    private final NameSubstitutionStrategy nameSubstitutionStrategy;
    private final Cache<ByteSequence, String> inflateTextCache;

    protected AccumuloNameSubstitutionStrategy(NameSubstitutionStrategy nameSubstitutionStrategy) {
        this.nameSubstitutionStrategy = nameSubstitutionStrategy;
        this.inflateTextCache = Cache2kBuilder.of(ByteSequence.class, String.class).name(AccumuloNameSubstitutionStrategy.class, "inflateTextCache-" + System.identityHashCode(this)).entryCapacity(10000L).eternal(true).loader(byteSequence -> this.inflate(ByteSequenceUtils.toString((ByteSequence)byteSequence))).build();
    }

    public void setup(Map config) {
    }

    public String deflate(String value) {
        return this.nameSubstitutionStrategy.deflate(value);
    }

    public String inflate(String value) {
        return this.nameSubstitutionStrategy.inflate(value);
    }

    public String inflate(ByteSequence text) {
        if (text == null) {
            return null;
        }
        if (this.nameSubstitutionStrategy instanceof IdentityNameSubstitutionStrategy) {
            return text.toString();
        }
        return (String)this.inflateTextCache.get((Object)text);
    }

    public static AccumuloNameSubstitutionStrategy create(NameSubstitutionStrategy nameSubstitutionStrategy) {
        if (nameSubstitutionStrategy instanceof AccumuloNameSubstitutionStrategy) {
            return (AccumuloNameSubstitutionStrategy)nameSubstitutionStrategy;
        }
        return new AccumuloNameSubstitutionStrategy(nameSubstitutionStrategy);
    }
}

