/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.accumulo;

import com.mware.ge.Authorizations;
import com.mware.ge.Direction;
import com.mware.ge.EdgeInfo;
import com.mware.ge.ElementType;
import com.mware.ge.FetchHints;
import com.mware.ge.FetchHintsBuilder;
import com.mware.ge.FindPathOptions;
import com.mware.ge.Path;
import com.mware.ge.ProgressCallback;
import com.mware.ge.Vertex;
import com.mware.ge.accumulo.AccumuloGraph;
import com.mware.ge.accumulo.util.RangeUtils;
import com.mware.ge.id.NameSubstitutionStrategy;
import com.mware.ge.store.StorableGraph;
import com.mware.ge.util.GeLogger;
import com.mware.ge.util.GeLoggerFactory;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.util.StreamUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.trace.Span;
import org.apache.accumulo.core.trace.Trace;

public class AccumuloFindPathStrategy {
    private static final GeLogger LOGGER = GeLoggerFactory.getLogger(AccumuloFindPathStrategy.class);
    private final AccumuloGraph graph;
    private final FindPathOptions options;
    private final ProgressCallback progressCallback;
    private final Authorizations authorizations;
    private final Set<String> includeLabels;
    private final Set<String> excludeLabels;

    public AccumuloFindPathStrategy(AccumuloGraph graph, FindPathOptions options, ProgressCallback progressCallback, Authorizations authorizations) {
        this.graph = graph;
        this.options = options;
        this.progressCallback = progressCallback;
        this.authorizations = authorizations;
        this.includeLabels = AccumuloFindPathStrategy.labelsToSet(graph.getNameSubstitutionStrategy(), options.getLabels());
        this.excludeLabels = AccumuloFindPathStrategy.labelsToSet(graph.getNameSubstitutionStrategy(), options.getExcludedLabels());
    }

    private static Set<String> labelsToSet(NameSubstitutionStrategy nameSubstitutionStrategy, String[] labels) {
        if (labels == null) {
            return null;
        }
        HashSet<String> results = new HashSet<String>();
        for (int i = 0; i < labels.length; ++i) {
            results.add(labels[i]);
        }
        return results;
    }

    public Iterable<Path> findPaths() {
        this.progressCallback.progress(0.0, ProgressCallback.Step.FINDING_PATH);
        ArrayList<Path> foundPaths = new ArrayList<Path>();
        if (this.options.getMaxHops() < 1) {
            throw new IllegalArgumentException("maxHops cannot be less than 1");
        }
        if (this.options.getMaxHops() == 1) {
            Set<String> sourceConnectedVertexIds = this.getConnectedVertexIds(this.options.getSourceVertexId());
            if (sourceConnectedVertexIds.contains(this.options.getDestVertexId())) {
                foundPaths.add(new Path(new String[]{this.options.getSourceVertexId(), this.options.getDestVertexId()}));
            }
        } else if (this.options.getMaxHops() == 2) {
            this.findPathsSetIntersection(foundPaths);
        } else {
            this.findPathsBreadthFirst(foundPaths, this.options.getSourceVertexId(), this.options.getDestVertexId(), this.options.getMaxHops());
        }
        this.progressCallback.progress(1.0, ProgressCallback.Step.COMPLETE);
        return foundPaths;
    }

    private void findPathsSetIntersection(List<Path> foundPaths) {
        String sourceVertexId = this.options.getSourceVertexId();
        String destVertexId = this.options.getDestVertexId();
        HashSet<String> vertexIds = new HashSet<String>();
        vertexIds.add(sourceVertexId);
        vertexIds.add(destVertexId);
        Map<String, Set<String>> connectedVertexIds = this.getConnectedVertexIds(vertexIds);
        this.progressCallback.progress(0.1, ProgressCallback.Step.SEARCHING_SOURCE_VERTEX_EDGES);
        Set<String> sourceVertexConnectedVertexIds = connectedVertexIds.get(sourceVertexId);
        if (sourceVertexConnectedVertexIds == null) {
            return;
        }
        this.progressCallback.progress(0.3, ProgressCallback.Step.SEARCHING_DESTINATION_VERTEX_EDGES);
        Set<String> destVertexConnectedVertexIds = connectedVertexIds.get(destVertexId);
        if (destVertexConnectedVertexIds == null) {
            return;
        }
        if (sourceVertexConnectedVertexIds.contains(destVertexId)) {
            foundPaths.add(new Path(new String[]{sourceVertexId, destVertexId}));
            if (this.options.isGetAnyPath()) {
                return;
            }
        }
        this.progressCallback.progress(0.6, ProgressCallback.Step.MERGING_EDGES);
        sourceVertexConnectedVertexIds.retainAll(destVertexConnectedVertexIds);
        this.progressCallback.progress(0.9, ProgressCallback.Step.ADDING_PATHS);
        foundPaths.addAll(sourceVertexConnectedVertexIds.stream().map(connectedVertexId -> new Path(new String[]{sourceVertexId, connectedVertexId, destVertexId})).collect(Collectors.toList()));
    }

    private void findPathsBreadthFirst(List<Path> foundPaths, String sourceVertexId, String destVertexId, int hops) {
        Map<String, Set<String>> connectedVertexIds = this.getConnectedVertexIds(sourceVertexId, destVertexId);
        for (int i = 2; i < hops; ++i) {
            this.progressCallback.progress((double)i / (double)hops, ProgressCallback.Step.FINDING_PATH);
            HashSet<String> vertexIdsToSearch = new HashSet<String>();
            for (Map.Entry<String, Set<String>> entry : connectedVertexIds.entrySet()) {
                vertexIdsToSearch.addAll((Collection<String>)entry.getValue());
            }
            vertexIdsToSearch.removeAll(connectedVertexIds.keySet());
            Map<String, Set<String>> r = this.getConnectedVertexIds(vertexIdsToSearch);
            connectedVertexIds.putAll(r);
        }
        this.progressCallback.progress(0.9, ProgressCallback.Step.ADDING_PATHS);
        HashSet<String> seenVertices = new HashSet<String>();
        Path currentPath = new Path(new String[]{sourceVertexId});
        this.findPathsRecursive(connectedVertexIds, foundPaths, sourceVertexId, destVertexId, hops, seenVertices, currentPath, this.progressCallback);
    }

    private void findPathsRecursive(Map<String, Set<String>> connectedVertexIds, List<Path> foundPaths, String sourceVertexId, String destVertexId, int hops, Set<String> seenVertices, Path currentPath, ProgressCallback progressCallback) {
        Set<String> vertexIds;
        if (this.options.isGetAnyPath() && foundPaths.size() == 1) {
            return;
        }
        seenVertices.add(sourceVertexId);
        if (sourceVertexId.equals(destVertexId)) {
            foundPaths.add(currentPath);
        } else if (hops > 0 && (vertexIds = connectedVertexIds.get(sourceVertexId)) != null) {
            for (String childId : vertexIds) {
                if (seenVertices.contains(childId)) continue;
                this.findPathsRecursive(connectedVertexIds, foundPaths, childId, destVertexId, hops - 1, seenVertices, new Path(currentPath, childId), progressCallback);
            }
        }
        seenVertices.remove(sourceVertexId);
    }

    private Set<String> getConnectedVertexIds(String vertexId) {
        HashSet<String> vertexIds = new HashSet<String>();
        vertexIds.add(vertexId);
        Map<String, Set<String>> results = this.getConnectedVertexIds(vertexIds);
        Set<String> vertexIdResults = results.get(vertexId);
        if (vertexIdResults == null) {
            return new HashSet<String>();
        }
        return vertexIdResults;
    }

    private Map<String, Set<String>> getConnectedVertexIds(String vertexId1, String vertexId2) {
        HashSet<String> vertexIds = new HashSet<String>();
        vertexIds.add(vertexId1);
        vertexIds.add(vertexId2);
        return this.getConnectedVertexIds(vertexIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Set<String>> getConnectedVertexIds(Set<String> vertexIds) {
        Span trace = Trace.start((String)"getConnectedVertexIds");
        try {
            HashMap hashMap;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("getConnectedVertexIds:\n  %s", new Object[]{IterableUtils.join(vertexIds, (String)"\n  ")});
            }
            if (vertexIds.size() == 0) {
                HashMap<String, Set<String>> hashMap2 = new HashMap<String, Set<String>>();
                return hashMap2;
            }
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (String vertexId : vertexIds) {
                ranges.add(RangeUtils.createRangeFromString(vertexId));
            }
            FetchHints fetchHints = new FetchHintsBuilder(FetchHints.EDGE_REFS).setIncludeEdgeIds(false).build();
            ScannerBase scanner = this.graph.createElementScanner(fetchHints, ElementType.VERTEX, 1, null, null, ranges, true, this.authorizations);
            long timerStartTime = System.currentTimeMillis();
            try {
                HashMap results = new HashMap();
                for (Map.Entry row : scanner) {
                    this.graph.logLargeRow((Key)row.getKey(), (Value)row.getValue());
                    Vertex vertex = AccumuloGraph.createVertexFromIteratorValue((StorableGraph)this.graph, (Key)row.getKey(), (Value)row.getValue(), fetchHints, this.authorizations);
                    Iterable otherVertexIds = StreamUtils.stream((Iterable[])new Iterable[]{vertex.getEdgeInfos(Direction.BOTH, this.authorizations)}).filter(edgeInfo -> {
                        if (this.excludeLabels != null && this.excludeLabels.contains(edgeInfo.getLabel())) {
                            return false;
                        }
                        return this.includeLabels == null || this.includeLabels.contains(edgeInfo.getLabel());
                    }).map(EdgeInfo::getVertexId).collect(Collectors.toSet());
                    Map verticesExist = this.graph.doVerticesExist(otherVertexIds, this.authorizations);
                    Set rowVertexIds = StreamUtils.stream((Iterable[])new Iterable[]{verticesExist.keySet()}).filter(key -> verticesExist.getOrDefault(key, false)).collect(Collectors.toSet());
                    results.put(((Key)row.getKey()).getRow().toString(), rowVertexIds);
                }
                hashMap = results;
            }
            catch (Throwable throwable) {
                scanner.close();
                AccumuloGraph.GRAPH_LOGGER.logEndIterator(System.currentTimeMillis() - timerStartTime);
                throw throwable;
            }
            scanner.close();
            AccumuloGraph.GRAPH_LOGGER.logEndIterator(System.currentTimeMillis() - timerStartTime);
            return hashMap;
        }
        finally {
            trace.stop();
        }
    }
}

