/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.orm.accumulo;

import com.google.common.base.Preconditions;
import com.mware.core.orm.ModelMetadata;
import com.mware.core.orm.OrmCloseableIterable;
import com.mware.core.orm.OrmCloseableIterator;
import com.mware.core.orm.SimpleOrmContext;
import com.mware.core.orm.SimpleOrmException;
import com.mware.core.orm.SimpleOrmSession;
import com.mware.core.orm.accumulo.AccumuloSimpleOrmContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.RowIterator;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.user.RowDeletingIterator;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccumuloSimpleOrmSession
extends SimpleOrmSession {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccumuloSimpleOrmSession.class);
    public static final String ACCUMULO_INSTANCE_NAME = "simpleOrm.accumulo.instanceName";
    public static final String ACCUMULO_USER = "simpleOrm.accumulo.username";
    public static final String ACCUMULO_PASSWORD = "simpleOrm.accumulo.password";
    public static final String ZK_SERVER_NAMES = "simpleOrm.accumulo.zookeeperServerNames";
    private static final String ROW_DELETING_ITERATOR_NAME = RowDeletingIterator.class.getSimpleName();
    private static final int ROW_DELETING_ITERATOR_PRIORITY = 7;
    private Connector connector;
    private BatchWriterConfig batchWriterConfig = new BatchWriterConfig();
    private final Set<String> initializedTables = new HashSet<String>();
    private final Map<String, BatchWriter> batchWriters = new HashMap<String, BatchWriter>();
    private String tablePrefix;

    public AccumuloSimpleOrmSession() {
    }

    public AccumuloSimpleOrmSession(Map<String, Object> properties) {
        this.setTablePrefix(properties);
    }

    public void init(Map<String, Object> properties) {
        try {
            String zkServerNames = properties.get(ZK_SERVER_NAMES) instanceof Collection ? StringUtils.join((Collection)((Collection)properties.get(ZK_SERVER_NAMES)), (String)",") : (String)properties.get(ZK_SERVER_NAMES);
            Preconditions.checkNotNull((Object)zkServerNames, (Object)"Could not find config: simpleOrm.accumulo.zookeeperServerNames");
            String accumuloInstanceName = (String)properties.get(ACCUMULO_INSTANCE_NAME);
            Preconditions.checkNotNull((Object)accumuloInstanceName, (Object)"Could not find config: simpleOrm.accumulo.instanceName");
            ClientConfiguration config = new ClientConfiguration(new ArrayList()).withInstance(accumuloInstanceName).withZkHosts(zkServerNames);
            ZooKeeperInstance zk = new ZooKeeperInstance((Configuration)config);
            String username = (String)properties.get(ACCUMULO_USER);
            String password = (String)properties.get(ACCUMULO_PASSWORD);
            this.connector = zk.getConnector(username, (AuthenticationToken)new PasswordToken((CharSequence)password));
            this.setTablePrefix(properties);
        }
        catch (Exception e) {
            throw new SimpleOrmException("Failed to init", (Throwable)e);
        }
    }

    public SimpleOrmContext createContext(String ... authorizations) {
        return new AccumuloSimpleOrmContext(authorizations);
    }

    public void close() {
        for (BatchWriter writer : this.batchWriters.values()) {
            try {
                writer.close();
            }
            catch (MutationsRejectedException e) {
                throw new SimpleOrmException("Could not close batch writer", (Throwable)e);
            }
        }
    }

    private void setTablePrefix(Map<String, Object> properties) {
        this.tablePrefix = (String)properties.get("simpleOrm.tablePrefix");
        if (this.tablePrefix == null) {
            this.tablePrefix = "";
        }
    }

    public <T> Iterable<T> findAll(Class<T> rowClass, SimpleOrmContext context) {
        try {
            ModelMetadata modelMetadata = ModelMetadata.getModelMetadata(rowClass);
            Scanner scanner = this.createScanner(this.getTableName(modelMetadata), (AccumuloSimpleOrmContext)context);
            return this.scannerToRows(scanner, modelMetadata);
        }
        catch (TableNotFoundException e) {
            throw new SimpleOrmException("Could not find all", (Throwable)e);
        }
    }

    public <T> Iterable<T> findAllInRange(String startKey, String endKey, Class<T> rowClass, SimpleOrmContext context) {
        try {
            ModelMetadata modelMetadata = ModelMetadata.getModelMetadata(rowClass);
            Scanner scanner = this.createScanner(this.getTableName(modelMetadata), (AccumuloSimpleOrmContext)context);
            scanner.setRange(new Range((CharSequence)startKey, true, (CharSequence)endKey, true));
            return this.scannerToRows(scanner, modelMetadata);
        }
        catch (TableNotFoundException e) {
            throw new SimpleOrmException("Could not find all in range", (Throwable)e);
        }
    }

    public <T> void delete(Class<T> rowClass, String id, SimpleOrmContext context) {
        ModelMetadata modelMetadata = ModelMetadata.getModelMetadata(rowClass);
        LOGGER.trace("deleteRow called with parameters: tableName=?, id=?", (Object)this.getTableName(modelMetadata), (Object)id);
        try (BatchWriter writer = this.connector.createBatchWriter(this.getTableName(modelMetadata), this.batchWriterConfig);){
            Mutation mutation = new Mutation((CharSequence)id);
            mutation.put(new byte[0], new byte[0], RowDeletingIterator.DELETE_ROW_VALUE.get());
            writer.addMutation(mutation);
            writer.flush();
        }
        catch (Exception mre) {
            throw new SimpleOrmException("Could not delete: " + rowClass.getName() + " id " + id, (Throwable)mre);
        }
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public Iterable<String> getTableList(SimpleOrmContext simpleOrmContext) {
        return this.connector.tableOperations().list();
    }

    public void deleteTable(String table, SimpleOrmContext simpleOrmContext) {
        try {
            this.connector.tableOperations().delete(table);
            this.initializedTables.remove(table);
        }
        catch (Exception e) {
            throw new SimpleOrmException("Could not delete table: " + table, (Throwable)e);
        }
    }

    public void clearTable(String table, SimpleOrmContext simpleOrmContext) {
        try {
            this.connector.tableOperations().deleteRows(table, null, null);
        }
        catch (Exception e) {
            throw new SimpleOrmException("Could not clear table: " + table, (Throwable)e);
        }
    }

    private <T> OrmCloseableIterable<T> scannerToRows(final Scanner scanner, final ModelMetadata<T> modelMetadata) {
        return new OrmCloseableIterable<T>(){

            public void close() throws IOException {
                scanner.close();
            }

            public OrmCloseableIterator<T> iterator() {
                final RowIterator rowIterator = new RowIterator((Iterable)scanner);
                return new OrmCloseableIterator<T>(){

                    public void close() throws IOException {
                        scanner.close();
                    }

                    public boolean hasNext() {
                        return rowIterator.hasNext();
                    }

                    public T next() {
                        Iterator row = rowIterator.next();
                        return AccumuloSimpleOrmSession.this.createObjectFromRow(modelMetadata, row);
                    }

                    public void remove() {
                        rowIterator.remove();
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T findByIdInRange(Class<T> rowClass, String id, SimpleOrmContext context, Range r) {
        try {
            ModelMetadata modelMetadata = ModelMetadata.getModelMetadata(rowClass);
            try (Scanner scanner = this.createScanner(this.getTableName(modelMetadata), (AccumuloSimpleOrmContext)context);){
                scanner.setRange(new Range((CharSequence)id));
                OrmCloseableIterator rows = this.scannerToRows(scanner, modelMetadata).iterator();
                if (!rows.hasNext()) {
                    T t = null;
                    return t;
                }
                Object result = rows.next();
                if (rows.hasNext()) {
                    throw new SimpleOrmException("Too many rows returned for a single row query (rowKey: " + id + ")");
                }
                Object e = result;
                return (T)e;
            }
        }
        catch (TableNotFoundException e) {
            throw new SimpleOrmException("Could not find by id", (Throwable)e);
        }
    }

    public <T> T findById(Class<T> rowClass, String id, SimpleOrmContext context) {
        return this.findByIdInRange(rowClass, id, context, new Range((CharSequence)id));
    }

    public <T> T findByExactId(Class<T> rowClass, String id, SimpleOrmContext context) {
        return this.findByIdInRange(rowClass, id, context, Range.exact((CharSequence)id));
    }

    public <T> Iterable<T> findByIdStartsWith(Class<T> rowClass, String idPrefix, SimpleOrmContext context) {
        try {
            ModelMetadata modelMetadata = ModelMetadata.getModelMetadata(rowClass);
            Scanner scanner = this.createScanner(this.getTableName(modelMetadata), (AccumuloSimpleOrmContext)context);
            scanner.setRange(Range.prefix((CharSequence)idPrefix));
            return this.scannerToRows(scanner, modelMetadata);
        }
        catch (TableNotFoundException e) {
            throw new SimpleOrmException("Could not find by id starts with", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void alterVisibility(T obj, String currentVisibility, String newVisibility, SimpleOrmContext context) {
        try {
            ModelMetadata modelMetadata = ModelMetadata.getModelMetadata(obj);
            try (Scanner scanner = this.createScanner(this.getTableName(modelMetadata), (AccumuloSimpleOrmContext)context);){
                scanner.setRange(new Range((CharSequence)modelMetadata.getId(obj)));
                RowIterator rowIterator = new RowIterator((Iterable)scanner);
                BatchWriter writer = this.getBatchWriter(this.getTableName(modelMetadata));
                ColumnVisibility newColumnVisibility = new ColumnVisibility(newVisibility);
                while (rowIterator.hasNext()) {
                    Iterator row = rowIterator.next();
                    this.alterVisibilityRow(writer, row, currentVisibility, newColumnVisibility);
                }
                writer.flush();
            }
        }
        catch (Throwable ex) {
            throw new SimpleOrmException("Could not alterVisibility", ex);
        }
    }

    private void alterVisibilityRow(BatchWriter writer, Iterator<Map.Entry<Key, Value>> row, String currentVisibility, ColumnVisibility newVisibility) throws MutationsRejectedException {
        Mutation mAdd = null;
        Mutation mDelete = null;
        boolean hasItems = false;
        while (row.hasNext()) {
            Map.Entry<Key, Value> column = row.next();
            if (mAdd == null) {
                mAdd = new Mutation(column.getKey().getRow());
                mDelete = new Mutation(column.getKey().getRow());
            }
            if (!column.getKey().getColumnVisibility().toString().equals(currentVisibility)) continue;
            hasItems = true;
            mAdd.put(column.getKey().getColumnFamily(), column.getKey().getColumnQualifier(), newVisibility, column.getKey().getTimestamp(), column.getValue());
            mDelete.putDelete(column.getKey().getColumnFamily(), column.getKey().getColumnQualifier());
        }
        if (hasItems) {
            writer.addMutation(mAdd);
            writer.addMutation(mDelete);
        }
    }

    public <T> void save(T obj, String visibility, SimpleOrmContext context) {
        try {
            ModelMetadata modelMetadata = ModelMetadata.getModelMetadata(obj);
            ModelMetadata.Type modelMetadataType = modelMetadata.getTypeFromObject(obj);
            this.ensureTableIsInitialized(this.getTableName(modelMetadata));
            BatchWriter writer = this.getBatchWriter(this.getTableName(modelMetadata));
            ColumnVisibility columnVisibility = new ColumnVisibility(visibility);
            writer.addMutation(this.getMutationForObject(modelMetadata, modelMetadataType, obj, columnVisibility));
            writer.flush();
        }
        catch (MutationsRejectedException e) {
            throw new SimpleOrmException("Error occurred when writing mutation", (Throwable)e);
        }
    }

    public <T> void saveMany(Collection<T> objs, String visibility, SimpleOrmContext context) {
        try {
            if (objs.size() == 0) {
                return;
            }
            BatchWriter writer = null;
            ModelMetadata modelMetadata = null;
            ColumnVisibility columnVisibility = new ColumnVisibility(visibility);
            for (T obj : objs) {
                if (modelMetadata == null) {
                    modelMetadata = ModelMetadata.getModelMetadata(obj);
                    this.ensureTableIsInitialized(this.getTableName(modelMetadata));
                }
                if (writer == null) {
                    writer = this.getBatchWriter(this.getTableName(modelMetadata));
                }
                writer.addMutation(this.getMutationForObject(modelMetadata, modelMetadata.getTypeFromObject(obj), obj, columnVisibility));
            }
            if (writer != null) {
                writer.flush();
            }
        }
        catch (MutationsRejectedException e) {
            throw new SimpleOrmException("Error occurred when writing mutation", (Throwable)e);
        }
    }

    public <T> String getTableName(Class<T> rowClass) {
        ModelMetadata modelMetadata = ModelMetadata.getModelMetadata(rowClass);
        return this.getTableName(modelMetadata);
    }

    private <T> String getTableName(ModelMetadata<T> modelMetadata) {
        return this.tablePrefix + modelMetadata.getTableName();
    }

    public <T> Mutation getMutationForObject(T obj, String visibility) {
        ModelMetadata modelMetadata = ModelMetadata.getModelMetadata(obj);
        ModelMetadata.Type type = modelMetadata.getTypeFromObject(obj);
        return this.getMutationForObject(modelMetadata, type, obj, new ColumnVisibility(visibility));
    }

    private <T> Mutation getMutationForObject(ModelMetadata modelMetadata, ModelMetadata.Type type, T obj, ColumnVisibility columnVisibility) {
        String rowKey = modelMetadata.getId(obj);
        Mutation mutation = new Mutation((CharSequence)rowKey);
        for (Map.Entry columnFamilyFields : type.getFields().entrySet()) {
            Text columnFamilyName = new Text((String)columnFamilyFields.getKey());
            for (Map.Entry columnField : ((Map)columnFamilyFields.getValue()).entrySet()) {
                Text columnName = new Text((String)columnField.getKey());
                byte[] value = ((ModelMetadata.Field)columnField.getValue()).get(obj);
                if (value == null) continue;
                mutation.put(columnFamilyName, columnName, columnVisibility, new Value(value));
            }
        }
        return mutation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BatchWriter getBatchWriter(String tableName) {
        try {
            Map<String, BatchWriter> map = this.batchWriters;
            synchronized (map) {
                BatchWriter writer = this.batchWriters.get(tableName);
                if (writer == null) {
                    writer = this.connector.createBatchWriter(tableName, this.batchWriterConfig);
                    this.batchWriters.put(tableName, writer);
                }
                return writer;
            }
        }
        catch (TableNotFoundException e) {
            throw new SimpleOrmException("Could not find table: " + tableName, (Throwable)e);
        }
    }

    private <T> T createObjectFromRow(ModelMetadata<T> modelMetadata, Iterator<Map.Entry<Key, Value>> row) {
        try {
            Iterator<ColumnData> columns;
            String discriminatorValue;
            boolean first = true;
            if (modelMetadata.getDiscriminatorColumnName() == null) {
                discriminatorValue = "";
                columns = ColumnData.createIterator(row);
            } else {
                RowData rowData = new RowData(row);
                byte[] discriminatorValueBytes = rowData.getColumnValue(modelMetadata.getDiscriminatorColumnFamily(), modelMetadata.getDiscriminatorColumnName());
                Preconditions.checkNotNull((Object)discriminatorValueBytes, (Object)("Could not find discriminatorValue " + modelMetadata.getDiscriminatorColumnFamily() + "." + modelMetadata.getDiscriminatorColumnName()));
                discriminatorValue = new String(discriminatorValueBytes);
                columns = rowData.createIterator();
            }
            ModelMetadata.Type type = modelMetadata.getType(discriminatorValue);
            Object result = type.newInstance();
            while (columns.hasNext()) {
                String columnName;
                String columnFamily;
                ModelMetadata.Field field;
                ColumnData column = columns.next();
                if (first) {
                    modelMetadata.setIdField(result, column.getRowKey());
                }
                if ((field = type.getFieldForColumn(columnFamily = column.getColumnFamily(), columnName = column.getColumnName())) != null) {
                    field.set(result, column.getValue());
                }
                first = false;
            }
            return (T)result;
        }
        catch (Exception e) {
            throw new SimpleOrmException("Could not create class: " + modelMetadata.toString(), (Throwable)e);
        }
    }

    private Scanner createScanner(String tableName, AccumuloSimpleOrmContext context) throws TableNotFoundException {
        this.ensureTableIsInitialized(tableName);
        Scanner scanner = this.connector.createScanner(tableName, context.getAccumuloAuthorizations());
        IteratorSetting iteratorSetting = new IteratorSetting(100, RowDeletingIterator.class.getSimpleName(), RowDeletingIterator.class);
        scanner.addScanIterator(iteratorSetting);
        return scanner;
    }

    private void ensureTableIsInitialized(String tableName) {
        try {
            if (this.initializedTables.contains(tableName)) {
                return;
            }
            if (!this.connector.tableOperations().list().contains(tableName)) {
                LOGGER.info("creating table: " + tableName);
                try {
                    this.connector.tableOperations().create(tableName);
                }
                catch (TableExistsException tableExistsException) {
                    // empty catch block
                }
            }
            IteratorSetting is = new IteratorSetting(7, ROW_DELETING_ITERATOR_NAME, RowDeletingIterator.class);
            if (!this.connector.tableOperations().listIterators(tableName).containsKey(ROW_DELETING_ITERATOR_NAME)) {
                try {
                    this.connector.tableOperations().attachIterator(tableName, is);
                }
                catch (AccumuloException e) {
                    this.absorbIteratorNameConflictException(e);
                }
            }
            this.initializedTables.add(tableName);
        }
        catch (Exception e) {
            throw new SimpleOrmException("Could not initialize table", (Throwable)e);
        }
    }

    private void absorbIteratorNameConflictException(AccumuloException ex) throws AccumuloException {
        boolean isErrorOk = false;
        Throwable cause = ex.getCause();
        if (cause instanceof IllegalArgumentException && cause.getMessage().contains("iterator name conflict")) {
            isErrorOk = true;
        }
        if (!isErrorOk) {
            throw ex;
        }
    }

    private static class ColumnData {
        private final String rowKey;
        private final String columnFamily;
        private final String columnName;
        private final byte[] value;

        private ColumnData(String rowKey, String columnFamily, String columnName, byte[] value) {
            this.rowKey = rowKey;
            this.columnFamily = columnFamily;
            this.columnName = columnName;
            this.value = value;
        }

        public String getRowKey() {
            return this.rowKey;
        }

        public String getColumnFamily() {
            return this.columnFamily;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public byte[] getValue() {
            return this.value;
        }

        public static Iterator<ColumnData> createIterator(final Iterator<Map.Entry<Key, Value>> row) {
            return new Iterator<ColumnData>(){

                @Override
                public boolean hasNext() {
                    return row.hasNext();
                }

                @Override
                public ColumnData next() {
                    Map.Entry column = (Map.Entry)row.next();
                    String rowKey = ((Key)column.getKey()).getRow().toString();
                    String columnFamily = ((Key)column.getKey()).getColumnFamily().toString();
                    String columnName = ((Key)column.getKey()).getColumnQualifier().toString();
                    byte[] value = ((Value)column.getValue()).get();
                    return new ColumnData(rowKey, columnFamily, columnName, value);
                }

                @Override
                public void remove() {
                    throw new SimpleOrmException("Not supported");
                }
            };
        }
    }

    private static class RowData {
        private String rowKey;
        private final Map<String, Map<String, byte[]>> data = new HashMap<String, Map<String, byte[]>>();

        public RowData(Iterator<Map.Entry<Key, Value>> row) {
            while (row.hasNext()) {
                Map.Entry<Key, Value> column = row.next();
                if (this.rowKey == null) {
                    this.rowKey = column.getKey().getRow().toString();
                }
                this.addColumn(column);
            }
        }

        private void addColumn(Map.Entry<Key, Value> column) {
            Map<String, byte[]> columnFamilyData = this.getColumnFamilyData(column.getKey().getColumnFamily().toString());
            columnFamilyData.put(column.getKey().getColumnQualifier().toString(), column.getValue().get());
        }

        private Map<String, byte[]> getColumnFamilyData(String columnFamilyName) {
            Map<String, byte[]> columnFamilyData = this.data.get(columnFamilyName);
            if (columnFamilyData == null) {
                columnFamilyData = new HashMap<String, byte[]>();
                this.data.put(columnFamilyName, columnFamilyData);
            }
            return columnFamilyData;
        }

        public byte[] getColumnValue(String columnFamily, String columnName) {
            return this.getColumnFamilyData(columnFamily).get(columnName);
        }

        public Iterator<ColumnData> createIterator() {
            ArrayList<ColumnData> results = new ArrayList<ColumnData>();
            for (Map.Entry<String, Map<String, byte[]>> columnFamily : this.data.entrySet()) {
                String columnFamilyName = columnFamily.getKey();
                for (Map.Entry<String, byte[]> column : columnFamily.getValue().entrySet()) {
                    String columnName = column.getKey();
                    byte[] value = column.getValue();
                    results.add(new ColumnData(this.rowKey, columnFamilyName, columnName, value));
                }
            }
            return results.iterator();
        }
    }
}

