/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.graph;

import com.google.common.base.Joiner;
import com.google.inject.Inject;
import com.mware.core.exception.BcException;
import com.mware.core.model.lock.LockRepository;
import com.mware.core.model.user.GraphAuthorizationRepository;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.ge.Graph;
import com.mware.ge.accumulo.AccumuloGraph;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.accumulo.core.security.Authorizations;

public class AccumuloGraphAuthorizationRepository
implements GraphAuthorizationRepository {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(AccumuloGraphAuthorizationRepository.class);
    public static final String LOCK_NAME = AccumuloGraphAuthorizationRepository.class.getName();
    private Graph graph;
    private LockRepository lockRepository;

    public void addAuthorizationToGraph(String ... auths) {
        LOGGER.debug("adding authorizations [%s]", new Object[]{Joiner.on((String)", ").join((Object[])auths)});
        this.lockRepository.lock(LOCK_NAME, () -> {
            LOGGER.debug("got lock to add authorizations [%s]", new Object[]{Joiner.on((String)", ").join((Object[])auths)});
            if (this.graph instanceof AccumuloGraph) {
                Charset charset = StandardCharsets.UTF_8;
                for (String auth : auths) {
                    LOGGER.debug("adding authorization [%s]", new Object[]{auth});
                    try {
                        AccumuloGraph accumuloGraph = (AccumuloGraph)this.graph;
                        String principal = accumuloGraph.getConnector().whoami();
                        Authorizations currentAuthorizations = accumuloGraph.getConnector().securityOperations().getUserAuthorizations(principal);
                        if (currentAuthorizations.contains(auth)) continue;
                        ArrayList<byte[]> newAuthorizationsArray = new ArrayList<byte[]>();
                        for (byte[] currentAuth : currentAuthorizations) {
                            newAuthorizationsArray.add(currentAuth);
                        }
                        newAuthorizationsArray.add(auth.getBytes(charset));
                        Authorizations newAuthorizations = new Authorizations(newAuthorizationsArray);
                        accumuloGraph.getConnector().securityOperations().changeUserAuthorizations(principal, newAuthorizations);
                    }
                    catch (Exception ex) {
                        throw new BcException("Could not update authorizations in accumulo", (Throwable)ex);
                    }
                }
            } else {
                throw new BcException("graph type not supported to add authorizations.");
            }
        });
    }

    public void removeAuthorizationFromGraph(String auth) {
        LOGGER.info("removing authorization %s", new Object[]{auth});
        this.lockRepository.lock(LOCK_NAME, () -> {
            LOGGER.debug("got lock removing authorization to graph user %s", new Object[]{auth});
            if (this.graph instanceof AccumuloGraph) {
                try {
                    AccumuloGraph accumuloGraph = (AccumuloGraph)this.graph;
                    String principal = accumuloGraph.getConnector().whoami();
                    Authorizations currentAuthorizations = accumuloGraph.getConnector().securityOperations().getUserAuthorizations(principal);
                    if (!currentAuthorizations.toString().contains(auth)) {
                        return;
                    }
                    byte[] authBytes = auth.getBytes("UTF8");
                    ArrayList<byte[]> newAuthorizationsArray = new ArrayList<byte[]>();
                    for (byte[] currentAuth : currentAuthorizations) {
                        if (Arrays.equals(currentAuth, authBytes)) continue;
                        newAuthorizationsArray.add(currentAuth);
                    }
                    Authorizations newAuthorizations = new Authorizations(newAuthorizationsArray);
                    accumuloGraph.getConnector().securityOperations().changeUserAuthorizations(principal, newAuthorizations);
                }
                catch (Exception ex) {
                    throw new RuntimeException("Could not update authorizations in accumulo", ex);
                }
            } else {
                throw new RuntimeException("graph type not supported to add authorizations.");
            }
        });
    }

    public List<String> getGraphAuthorizations() {
        if (this.graph instanceof AccumuloGraph) {
            try {
                AccumuloGraph accumuloGraph = (AccumuloGraph)this.graph;
                String principal = accumuloGraph.getConnector().whoami();
                Authorizations currentAuthorizations = accumuloGraph.getConnector().securityOperations().getUserAuthorizations(principal);
                ArrayList<String> auths = new ArrayList<String>();
                for (byte[] currentAuth : currentAuthorizations) {
                    auths.add(new String(currentAuth));
                }
                return auths;
            }
            catch (Exception ex) {
                throw new RuntimeException("Could not get authorizations from accumulo", ex);
            }
        }
        throw new RuntimeException("graph type not supported to add authorizations.");
    }

    @Inject
    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    @Inject
    public void setLockRepository(LockRepository lockRepository) {
        this.lockRepository = lockRepository;
    }
}

