/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.accumulo;

import com.mware.ge.Authorizations;
import com.mware.ge.Property;
import com.mware.ge.Vertex;
import com.mware.ge.VertexBuilder;
import com.mware.ge.accumulo.AccumuloGraph;
import com.mware.ge.accumulo.AccumuloGraphFactory;
import com.mware.ge.accumulo.AccumuloResource;
import com.mware.ge.accumulo.StreamingPropertyValueTableData;
import com.mware.ge.accumulo.StreamingPropertyValueTableDataRef;
import com.mware.ge.accumulo.util.DataInDataTableStreamingPropertyValueStorageStrategy;
import com.mware.ge.base.GraphSpvTests;
import com.mware.ge.base.GraphTestSetup;
import com.mware.ge.base.TestGraphFactory;
import com.mware.ge.id.NameSubstitutionStrategy;
import com.mware.ge.store.util.StorableKeyHelper;
import com.mware.ge.util.GeLogger;
import com.mware.ge.util.GeLoggerFactory;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.values.storable.StreamingPropertyValue;
import com.mware.ge.values.storable.TextValue;
import com.mware.ge.values.storable.Value;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class AccumuloSpvTests
extends GraphSpvTests
implements GraphTestSetup {
    private static final GeLogger LOGGER = GeLoggerFactory.getLogger(AccumuloSpvTests.class);
    @ClassRule
    public static AccumuloResource accumuloResource = new AccumuloResource();

    @Before
    public void before() throws Exception {
        accumuloResource.resetAutorizations();
        super.before();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDataTableStreamingPropertyValuesStoreRefInElementTable() throws Exception {
        Assume.assumeTrue((boolean)(this.getGraph().getStreamingPropertyValueStorageStrategy() instanceof DataInDataTableStreamingPropertyValueStorageStrategy));
        VertexBuilder m = this.graph.prepareVertex("v1", Long.valueOf(100L), VISIBILITY_A, "thing");
        StreamingPropertyValue stringSpv = StreamingPropertyValue.create((String)"This is a string SPV");
        m.addPropertyValue("key1", "author", (Value)stringSpv, null, Long.valueOf(200L), VISIBILITY_A);
        StreamingPropertyValue inputStreamSpv = StreamingPropertyValue.create((InputStream)new ByteArrayInputStream("This is an input stream SPV".getBytes()), TextValue.class);
        m.addPropertyValue("key2", "author", (Value)inputStreamSpv, null, Long.valueOf(300L), VISIBILITY_A);
        m.save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        try (Scanner scanner = null;){
            Connector connector = this.getGraph().getConnector();
            String string = this.getGraph().getVerticesTableName();
            this.getGraph();
            scanner = connector.createScanner(string, AccumuloGraph.toAccumuloAuthorizations((Authorizations)AUTHORIZATIONS_ALL));
            List entries = IterableUtils.toList((Iterator)scanner.iterator());
            Assert.assertEquals((long)3L, (long)entries.size());
            Map.Entry stringSpvEntry = (Map.Entry)entries.get(0);
            Assert.assertEquals((Object)"v1", (Object)((Key)stringSpvEntry.getKey()).getRow().toString());
            Assert.assertEquals((Object)"PROP", (Object)((Key)stringSpvEntry.getKey()).getColumnFamily().toString());
            Assert.assertEquals((Object)StorableKeyHelper.getColumnQualifierFromPropertyColumnQualifier((String)"key1", (String)"author", (NameSubstitutionStrategy)this.getGraph().getNameSubstitutionStrategy()), (Object)((Key)stringSpvEntry.getKey()).getColumnQualifier().toString());
            Object stringSpvValueEntry = this.getGraph().getGeSerializer().bytesToObject(((org.apache.accumulo.core.data.Value)stringSpvEntry.getValue()).get());
            Assert.assertEquals(StreamingPropertyValueTableDataRef.class, stringSpvValueEntry.getClass());
            Map.Entry inputStreamSpvEntry = (Map.Entry)entries.get(1);
            Assert.assertEquals((Object)"v1", (Object)((Key)inputStreamSpvEntry.getKey()).getRow().toString());
            Assert.assertEquals((Object)"PROP", (Object)((Key)inputStreamSpvEntry.getKey()).getColumnFamily().toString());
            Assert.assertEquals((Object)StorableKeyHelper.getColumnQualifierFromPropertyColumnQualifier((String)"key2", (String)"author", (NameSubstitutionStrategy)this.getGraph().getNameSubstitutionStrategy()), (Object)((Key)inputStreamSpvEntry.getKey()).getColumnQualifier().toString());
            Object inputStreamSpvValueEntry = this.getGraph().getGeSerializer().bytesToObject(((org.apache.accumulo.core.data.Value)inputStreamSpvEntry.getValue()).get());
            Assert.assertEquals(StreamingPropertyValueTableDataRef.class, inputStreamSpvValueEntry.getClass());
        }
        Vertex v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        Property stringProperty = v1.getProperty("key1", "author");
        Assert.assertEquals(StreamingPropertyValueTableData.class, stringProperty.getValue().getClass());
        Assert.assertEquals((Object)"This is a string SPV", (Object)((StreamingPropertyValue)stringProperty.getValue()).readToString());
        Property inputStreamProperty = v1.getProperty("key2", "author");
        Assert.assertEquals(StreamingPropertyValueTableData.class, inputStreamProperty.getValue().getClass());
        Assert.assertEquals((Object)"This is an input stream SPV", (Object)((StreamingPropertyValue)inputStreamProperty.getValue()).readToString());
    }

    public AccumuloGraph getGraph() {
        return (AccumuloGraph)super.getGraph();
    }

    public void addAuthorizations(String ... authorizations) {
        accumuloResource.addAuthorizations(this.getGraph(), authorizations);
    }

    public TestGraphFactory graphFactory() {
        return new AccumuloGraphFactory().withAccumuloResource(accumuloResource);
    }

    public boolean isInputStreamMarkResetSupported() {
        return false;
    }
}

