/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.accumulo.util;

import com.mware.ge.GeException;
import com.mware.ge.util.GeLogger;
import com.mware.ge.util.GeLoggerFactory;
import com.mware.ge.util.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.xerial.snappy.SnappyInputStream;
import org.xerial.snappy.SnappyOutputStream;

public class SnappyUtils {
    private static final GeLogger LOGGER = GeLoggerFactory.getLogger(SnappyUtils.class);

    public static boolean testSnappySupport() {
        try {
            String testString = "Hello World";
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            SnappyOutputStream out = new SnappyOutputStream((OutputStream)baos);
            out.write(testString.getBytes());
            out.close();
            byte[] bytes = baos.toByteArray();
            ByteArrayInputStream bain = new ByteArrayInputStream(bytes);
            SnappyInputStream in = new SnappyInputStream((InputStream)bain);
            String result = new String(IOUtils.toBytes((InputStream)in));
            if (!result.equals(testString)) {
                throw new GeException("uncompressed string did not match compressed string");
            }
            return true;
        }
        catch (Throwable ex) {
            LOGGER.error("Could not verify support for snappy compression", ex);
            return false;
        }
    }
}

