/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.accumulo.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LimitOutputStream
extends OutputStream {
    private final int maxSizeToStore;
    private final ByteArrayOutputStream smallOutputStream;
    private final LargeDataStore largeDataStore;
    private OutputStream largeOutputStream;
    private long length;

    public LimitOutputStream(LargeDataStore largeDataStore, long maxSizeToStore) {
        this.largeDataStore = largeDataStore;
        this.maxSizeToStore = (int)maxSizeToStore;
        this.smallOutputStream = new ByteArrayOutputStream((int)maxSizeToStore);
        this.length = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OutputStream getLargeOutputStream() throws IOException {
        if (this.largeOutputStream != null) {
            return this.largeOutputStream;
        }
        LimitOutputStream limitOutputStream = this;
        synchronized (limitOutputStream) {
            if (this.largeOutputStream != null) {
                return this.largeOutputStream;
            }
            this.largeOutputStream = this.largeDataStore.createOutputStream();
            if (this.smallOutputStream.size() > 0) {
                this.largeOutputStream.write(this.smallOutputStream.toByteArray());
            }
            return this.largeOutputStream;
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.smallOutputStream.size() <= this.maxSizeToStore - 1) {
            this.smallOutputStream.write(b);
        } else {
            this.getLargeOutputStream().write(b);
        }
        ++this.length;
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.smallOutputStream.size() <= this.maxSizeToStore - b.length) {
            this.smallOutputStream.write(b);
        } else {
            this.getLargeOutputStream().write(b);
        }
        this.length += (long)b.length;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.smallOutputStream.size() <= this.maxSizeToStore - len) {
            this.smallOutputStream.write(b, off, len);
        } else {
            this.getLargeOutputStream().write(b, off, len);
        }
        this.length += (long)len;
    }

    public boolean hasExceededSizeLimit() {
        return this.largeOutputStream != null;
    }

    public byte[] getSmall() {
        if (this.hasExceededSizeLimit()) {
            return null;
        }
        return this.smallOutputStream.toByteArray();
    }

    @Override
    public void flush() throws IOException {
        if (this.largeOutputStream != null) {
            this.largeOutputStream.flush();
        }
        super.close();
    }

    @Override
    public void close() throws IOException {
        if (this.largeOutputStream != null) {
            this.largeOutputStream.close();
        }
        this.smallOutputStream.close();
        super.close();
    }

    public long getLength() {
        return this.length;
    }

    public static abstract class LargeDataStore {
        public abstract OutputStream createOutputStream() throws IOException;
    }
}

