/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.accumulo.util;

import com.google.common.collect.ImmutableSet;
import com.mware.ge.FetchHints;
import com.mware.ge.Graph;
import com.mware.ge.Property;
import com.mware.ge.Visibility;
import com.mware.ge.accumulo.iterator.model.ElementData;
import com.mware.ge.id.NameSubstitutionStrategy;
import com.mware.ge.store.Edges;
import com.mware.ge.store.EdgesWithCount;
import com.mware.ge.store.EdgesWithEdgeInfo;
import com.mware.ge.store.StorableEdgeInfo;
import com.mware.ge.store.StorableGraph;
import com.mware.ge.store.util.LazyMutableProperty;
import com.mware.ge.store.util.MetadataEntry;
import com.mware.ge.store.util.MetadataRef;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.io.Text;
import org.xerial.snappy.SnappyInputStream;

public class DataInputStreamUtils {
    public static Text decodeText(DataInputStream in) throws IOException {
        return com.mware.ge.accumulo.iterator.util.DataInputStreamUtils.decodeText((DataInputStream)in);
    }

    public static String decodeString(DataInputStream in) throws IOException {
        return com.mware.ge.accumulo.iterator.util.DataInputStreamUtils.decodeString((DataInputStream)in);
    }

    public static ImmutableSet<String> decodeStringSet(DataInputStream in) throws IOException {
        int count = in.readInt();
        if (count == -1) {
            return null;
        }
        ImmutableSet.Builder results = ImmutableSet.builder();
        for (int i = 0; i < count; ++i) {
            results.add((Object)DataInputStreamUtils.decodeString(in));
        }
        return results.build();
    }

    public static List<MetadataEntry> decodeMetadataEntries(DataInputStream in) throws IOException {
        int i = in.read();
        if (i != 3) {
            throw new IOException(String.format("Unexpected metadata start: 0x%02x (expected: 0x%02x)", i, 3));
        }
        int length = in.readInt();
        ArrayList<MetadataEntry> results = new ArrayList<MetadataEntry>(length);
        for (i = 0; i < length; ++i) {
            results.add(DataInputStreamUtils.decodeMetadataEntry(in));
        }
        i = in.read();
        if (i != 4) {
            throw new IOException(String.format("Unexpected metadata end: 0x%02x (expected: 0x%02x)", i, 4));
        }
        return results;
    }

    private static MetadataEntry decodeMetadataEntry(DataInputStream in) throws IOException {
        String metadataKey = DataInputStreamUtils.decodeString(in);
        String metadataVisibility = DataInputStreamUtils.decodeString(in);
        int valueLength = in.readInt();
        byte[] value = new byte[valueLength];
        in.read(value);
        return new MetadataEntry(metadataKey, metadataVisibility, value);
    }

    public static Iterable<Property> decodeProperties(StorableGraph graph, DataInputStream in, List<MetadataEntry> metadataEntries, FetchHints fetchHints) throws IOException {
        int propId;
        ArrayList<Property> results = new ArrayList<Property>();
        while ((propId = in.read()) != 2) {
            if (propId != 1) {
                throw new IOException("Unexpected prop id: " + propId);
            }
            String propertyKey = graph.getNameSubstitutionStrategy().inflate(DataInputStreamUtils.decodeString(in));
            String propertyName = graph.getNameSubstitutionStrategy().inflate(DataInputStreamUtils.decodeString(in));
            Visibility propertyVisibility = new Visibility(DataInputStreamUtils.decodeString(in));
            long propertyTimestamp = in.readLong();
            int propertyValueLength = in.readInt();
            byte[] propertyValue = new byte[propertyValueLength];
            int read = in.read(propertyValue);
            if (read != propertyValueLength) {
                throw new IOException("Unexpected data length expected " + propertyValueLength + " found " + read);
            }
            ImmutableSet<String> propertyHiddenVisibilitiesStringSet = DataInputStreamUtils.decodeStringSet(in);
            Set propertyHiddenVisibilities = null;
            if (propertyHiddenVisibilitiesStringSet != null) {
                propertyHiddenVisibilities = propertyHiddenVisibilitiesStringSet.stream().map(Visibility::new).collect(Collectors.toSet());
            }
            MetadataRef metadataRef = DataInputStreamUtils.decodePropertyMetadata(in, metadataEntries);
            results.add((Property)new LazyMutableProperty((Graph)graph, graph.getGeSerializer(), propertyKey, propertyName, propertyValue, metadataRef, propertyHiddenVisibilities, propertyVisibility, propertyTimestamp, fetchHints));
        }
        return results;
    }

    private static MetadataRef decodePropertyMetadata(DataInputStream in, List<MetadataEntry> metadataEntries) throws IOException {
        int[] metadataIndexes = com.mware.ge.accumulo.iterator.util.DataInputStreamUtils.decodeIntArray((DataInputStream)in);
        return new MetadataRef(metadataEntries, metadataIndexes);
    }

    public static Edges decodeEdges(DataInputStream in, NameSubstitutionStrategy nameSubstitutionStrategy, FetchHints fetchHints) throws IOException {
        byte edgeLabelMarker = in.readByte();
        if (edgeLabelMarker == 2) {
            return DataInputStreamUtils.decodeEdgesWithRefs(in, nameSubstitutionStrategy, fetchHints);
        }
        if (edgeLabelMarker == 1) {
            return DataInputStreamUtils.decodeEdgesLabelsOnly(in, nameSubstitutionStrategy);
        }
        throw new IOException("Unexpected edge label marker: " + edgeLabelMarker);
    }

    private static Edges decodeEdgesLabelsOnly(DataInputStream in, NameSubstitutionStrategy nameSubstitutionStrategy) throws IOException {
        EdgesWithCount edges = new EdgesWithCount();
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            String label = nameSubstitutionStrategy.inflate(DataInputStreamUtils.decodeString(in));
            int edgeByLabelCount = in.readInt();
            edges.add(label, edgeByLabelCount);
        }
        return edges;
    }

    private static Edges decodeEdgesWithRefs(DataInputStream in, NameSubstitutionStrategy nameSubstitutionStrategy, FetchHints fetchHints) throws IOException {
        EdgesWithEdgeInfo edges = new EdgesWithEdgeInfo();
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            String label = DataInputStreamUtils.decodeString(in);
            int edgeByLabelCount = in.readInt();
            for (int edgeByLabelIndex = 0; edgeByLabelIndex < edgeByLabelCount; ++edgeByLabelIndex) {
                Text edgeId = fetchHints.isIncludeEdgeIds() ? DataInputStreamUtils.decodeText(in) : null;
                long timestamp = in.readLong();
                String vertexId = fetchHints.isIncludeEdgeVertexIds() ? DataInputStreamUtils.decodeString(in) : null;
                StorableEdgeInfo edgeInfo = new StorableEdgeInfo(nameSubstitutionStrategy.inflate(label), vertexId, timestamp, fetchHints.isIncludeEdgeVertexIds());
                edges.add(edgeId == null ? null : edgeId.toString(), edgeInfo);
            }
        }
        return edges;
    }

    public static DataInputStream decodeHeader(InputStream in, byte expectedTypeId) throws IOException {
        byte[] header = new byte[ElementData.HEADER.length];
        int read = in.read(header);
        if (read != header.length) {
            throw new IOException("Unexpected header length. Expected " + ElementData.HEADER.length + " found " + read);
        }
        if (Arrays.equals(header, ElementData.SNAPPY_HEADER)) {
            return DataInputStreamUtils.decodeHeader((InputStream)new SnappyInputStream(in), expectedTypeId);
        }
        if (!Arrays.equals(header, ElementData.HEADER)) {
            throw new IOException("Unexpected header");
        }
        int typeId = in.read();
        if (typeId != expectedTypeId) {
            throw new IOException("Unexpected type id. Expected " + expectedTypeId + " found " + typeId);
        }
        return new DataInputStream(in);
    }
}

