/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.accumulo.tools;

import com.mware.ge.accumulo.tools.HDFSGraphUtil;
import com.mware.ge.tools.GraphRestore;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;

public class HDFSGraphRestore
extends GraphRestore {
    private final String hadoopFs;
    private final boolean useDatanodeName;
    private final String hadoopUsername;

    public HDFSGraphRestore(String hadoopFs, String rootDir, boolean useDatanodeName, String hadoopUsername) {
        super(rootDir);
        this.hadoopFs = hadoopFs;
        this.useDatanodeName = useDatanodeName;
        this.hadoopUsername = hadoopUsername;
    }

    public Optional<String> getLastBackupFile(String backupFilePrefix) {
        try {
            FileSystem fileSystem = HDFSGraphUtil.getHdfsFileSystem(this.hadoopFs, this.useDatanodeName, this.hadoopUsername);
            List<String> filesThatMatch = HDFSGraphUtil.listFiles(fileSystem, this.rootDir, Optional.of(backupFilePrefix));
            return filesThatMatch.stream().sorted((f1Name, f2Name) -> {
                String date1Value = f1Name.replace(backupFilePrefix, "").replace(".ge", "");
                LocalDateTime date1 = LocalDateTime.parse(date1Value, BACKUP_DATETIME_FORMATTER);
                String date2Value = f2Name.replace(backupFilePrefix, "").replace(".ge", "");
                LocalDateTime date2 = LocalDateTime.parse(date2Value, BACKUP_DATETIME_FORMATTER);
                return date2.compareTo(date1);
            }).findFirst();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    public InputStream createInputStream(String fileName) throws FileNotFoundException {
        try {
            FileSystem fileSystem = HDFSGraphUtil.getHdfsFileSystem(this.hadoopFs, this.useDatanodeName, this.hadoopUsername);
            FSDataInputStream in = fileSystem.open(HDFSGraphUtil.getPath(fileSystem, this.rootDir, fileName));
            return in;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FileNotFoundException(e.getMessage());
        }
    }

    public String getAbsoluteFilePath(String filename) {
        return this.hadoopFs + this.rootDir + "/" + filename;
    }
}

