/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.accumulo.tools;

import com.mware.ge.accumulo.tools.HDFSGraphUtil;
import com.mware.ge.tools.GraphBackup;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HDFSGraphBackup
extends GraphBackup {
    private final String hadoopFs;
    private final boolean useDatanodeName;
    private final String hadoopUsername;

    public HDFSGraphBackup(String hadoopFs, String rootDir, boolean useDatanodeName, String hadoopUsername, String outputFileName) {
        super(rootDir, outputFileName);
        this.hadoopFs = hadoopFs;
        this.useDatanodeName = useDatanodeName;
        this.hadoopUsername = hadoopUsername;
    }

    private Path createBackupFile(FileSystem fileSystem) throws IOException {
        return HDFSGraphUtil.createFile(fileSystem, this.rootDir, this.outputFileNamePrefix);
    }

    public OutputStream createOutputStream() throws IOException {
        try {
            FileSystem fileSystem = HDFSGraphUtil.getHdfsFileSystem(this.hadoopFs, this.useDatanodeName, this.hadoopUsername);
            Path file = this.createBackupFile(fileSystem);
            return fileSystem.create(file);
        }
        catch (InterruptedException | URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public String getAbsoluteFilePath(String filename) {
        return this.hadoopFs + this.rootDir + "/" + filename;
    }
}

