/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.accumulo.mapreduce;

import com.mware.ge.Authorizations;
import com.mware.ge.Direction;
import com.mware.ge.Edge;
import com.mware.ge.EdgeBuilder;
import com.mware.ge.EdgeBuilderBase;
import com.mware.ge.EdgeBuilderByVertexId;
import com.mware.ge.ElementType;
import com.mware.ge.FetchHints;
import com.mware.ge.GeException;
import com.mware.ge.Graph;
import com.mware.ge.Vertex;
import com.mware.ge.VertexBuilder;
import com.mware.ge.Visibility;
import com.mware.ge.accumulo.AccumuloGraph;
import com.mware.ge.accumulo.AccumuloGraphConfiguration;
import com.mware.ge.accumulo.mapreduce.ElementMapperGraph;
import com.mware.ge.id.IdGenerator;
import com.mware.ge.id.NameSubstitutionStrategy;
import com.mware.ge.serializer.GeSerializer;
import com.mware.ge.store.StorableEdge;
import com.mware.ge.store.StorableGraph;
import com.mware.ge.store.StorableVertex;
import com.mware.ge.store.mutations.ElementMutationBuilder;
import com.mware.ge.store.mutations.StoreMutation;
import com.mware.ge.store.util.StreamingPropertyValueStorageStrategy;
import com.mware.ge.util.IncreasingTime;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public abstract class ElementMapper<KEYIN, VALUEIN, KEYOUT, VALUEOUT>
extends Mapper<KEYIN, VALUEIN, KEYOUT, VALUEOUT>
implements StorableGraph {
    public static final String GRAPH_CONFIG_PREFIX = "graphConfigPrefix";
    private ElementMutationBuilder elementMutationBuilder;
    private ElementMapperGraph graph;
    private NameSubstitutionStrategy nameSubstitutionStrategy;

    protected void setup(final Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        String configPrefix = context.getConfiguration().get(GRAPH_CONFIG_PREFIX, "");
        AccumuloGraphConfiguration accumuloGraphConfiguration = new AccumuloGraphConfiguration(context.getConfiguration(), configPrefix);
        String tableNamePrefix = accumuloGraphConfiguration.getTableNamePrefix();
        final Text edgesTableName = new Text(AccumuloGraph.getEdgesTableName((String)tableNamePrefix));
        final Text dataTableName = new Text(AccumuloGraph.getDataTableName((String)tableNamePrefix));
        final Text verticesTableName = new Text(AccumuloGraph.getVerticesTableName((String)tableNamePrefix));
        final Text extendedDataTableName = new Text(AccumuloGraph.getExtendedDataTableName((String)tableNamePrefix));
        this.graph = new ElementMapperGraph(this, accumuloGraphConfiguration);
        GeSerializer geSerializer = accumuloGraphConfiguration.createSerializer((Graph)this.graph);
        this.nameSubstitutionStrategy = accumuloGraphConfiguration.createSubstitutionStrategy((Graph)this.graph);
        StreamingPropertyValueStorageStrategy streamingPropertyValueStorageStrategy = accumuloGraphConfiguration.createStreamingPropertyValueStorageStrategy((Graph)this.graph);
        this.elementMutationBuilder = new ElementMutationBuilder(streamingPropertyValueStorageStrategy, this, geSerializer){

            protected void saveVertexMutation(StoreMutation m) {
                try {
                    ElementMapper.this.saveVertexMutation(context, verticesTableName, m);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not save vertex", e);
                }
            }

            protected void saveEdgeMutation(StoreMutation m) {
                try {
                    ElementMapper.this.saveEdgeMutation(context, edgesTableName, m);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not save edge", e);
                }
            }

            protected void saveExtendedDataMutation(ElementType elementType, StoreMutation m) {
                try {
                    ElementMapper.this.saveExtendedDataMutation(context, extendedDataTableName, m);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not save edge", e);
                }
            }

            protected NameSubstitutionStrategy getNameSubstitutionStrategy() {
                return ElementMapper.this.nameSubstitutionStrategy;
            }

            public void saveDataMutation(StoreMutation m) {
                try {
                    ElementMapper.this.saveDataMutation(context, dataTableName, m);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not save data", e);
                }
            }
        };
    }

    protected abstract void saveDataMutation(Mapper.Context var1, Text var2, StoreMutation var3) throws IOException, InterruptedException;

    protected abstract void saveEdgeMutation(Mapper.Context var1, Text var2, StoreMutation var3) throws IOException, InterruptedException;

    protected abstract void saveVertexMutation(Mapper.Context var1, Text var2, StoreMutation var3) throws IOException, InterruptedException;

    protected abstract void saveExtendedDataMutation(Mapper.Context var1, Text var2, StoreMutation var3) throws IOException, InterruptedException;

    public VertexBuilder prepareVertex(Vertex vertex) {
        return this.prepareVertex(vertex.getId(), null, vertex.getVisibility(), vertex.getConceptType());
    }

    public VertexBuilder prepareVertex(String vertexId, Visibility visibility, String conceptType) {
        return this.prepareVertex(vertexId, null, visibility, conceptType);
    }

    public VertexBuilder prepareVertex(String vertexId, Long timestamp, Visibility visibility, String conceptType) {
        if (vertexId == null) {
            vertexId = this.getIdGenerator().nextId();
        }
        if (timestamp == null) {
            timestamp = IncreasingTime.currentTimeMillis();
        }
        final long timestampLong = timestamp;
        return new VertexBuilder(vertexId, conceptType, visibility){

            public Vertex save(Authorizations authorizations) {
                StorableGraph graph = null;
                Iterable hiddenVisibilities = null;
                ElementMapper.this.elementMutationBuilder.saveVertexBuilder(graph, (VertexBuilder)this, timestampLong);
                return new StorableVertex(graph, this.getId(), this.getConceptType(), this.getNewConceptType(), this.getVisibility(), this.getProperties(), this.getPropertyDeletes(), this.getPropertySoftDeletes(), hiddenVisibilities, this.getExtendedDataTableNames(), timestampLong, FetchHints.ALL_INCLUDING_HIDDEN, authorizations);
            }
        };
    }

    public Edge addEdge(String edgeId, Vertex outVertex, Vertex inVertex, String label, Visibility visibility, Authorizations authorizations) {
        return this.prepareEdge(edgeId, outVertex, inVertex, label, null, visibility).save(authorizations);
    }

    public EdgeBuilderByVertexId prepareEdge(Edge edge) {
        return this.prepareEdge(edge.getId(), edge.getVertexId(Direction.OUT), edge.getVertexId(Direction.IN), edge.getLabel(), (Long)edge.getTimestamp(), edge.getVisibility());
    }

    public EdgeBuilderByVertexId prepareEdge(String edgeId, String outVertexId, String inVertexId, String label, Visibility visibility) {
        return this.prepareEdge(edgeId, outVertexId, inVertexId, label, null, visibility);
    }

    public EdgeBuilderByVertexId prepareEdge(String edgeId, String outVertexId, String inVertexId, String label, Long timestamp, Visibility visibility) {
        if (edgeId == null) {
            edgeId = this.getIdGenerator().nextId();
        }
        if (timestamp == null) {
            timestamp = IncreasingTime.currentTimeMillis();
        }
        final long timestampLong = timestamp;
        return new EdgeBuilderByVertexId(edgeId, outVertexId, inVertexId, label, visibility){

            public Edge save(Authorizations authorizations) {
                ElementMapper.this.elementMutationBuilder.saveEdgeBuilder(null, (EdgeBuilderBase)this, timestampLong);
                StorableEdge edge = new StorableEdge(null, this.getId(), this.getVertexId(Direction.OUT), this.getVertexId(Direction.IN), this.getEdgeLabel(), this.getNewEdgeLabel(), this.getVisibility(), this.getProperties(), this.getPropertyDeletes(), this.getPropertySoftDeletes(), null, this.getExtendedDataTableNames(), timestampLong, FetchHints.ALL_INCLUDING_HIDDEN, authorizations);
                return edge;
            }
        };
    }

    public EdgeBuilder prepareEdge(String edgeId, Vertex outVertex, Vertex inVertex, String label, Visibility visibility) {
        return this.prepareEdge(edgeId, outVertex, inVertex, label, null, visibility);
    }

    public EdgeBuilder prepareEdge(String edgeId, Vertex outVertex, Vertex inVertex, String label, Long timestamp, Visibility visibility) {
        if (edgeId == null) {
            edgeId = this.getIdGenerator().nextId();
        }
        if (timestamp == null) {
            timestamp = IncreasingTime.currentTimeMillis();
        }
        final long timestampLong = timestamp;
        return new EdgeBuilder(edgeId, outVertex, inVertex, label, visibility){

            public Edge save(Authorizations authorizations) {
                ElementMapper.this.elementMutationBuilder.saveEdgeBuilder(null, (EdgeBuilderBase)this, timestampLong);
                StorableEdge edge = new StorableEdge(null, this.getId(), this.getOutVertex().getId(), this.getInVertex().getId(), this.getEdgeLabel(), this.getNewEdgeLabel(), this.getVisibility(), this.getProperties(), this.getPropertyDeletes(), this.getPropertySoftDeletes(), null, this.getExtendedDataTableNames(), timestampLong, FetchHints.ALL_INCLUDING_HIDDEN, authorizations);
                return edge;
            }
        };
    }

    public IdGenerator getIdGenerator() {
        throw new GeException("not implemented");
    }

    public Graph getGraph() {
        return this.graph;
    }
}

