/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.accumulo.mapreduce;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.mware.ge.Authorizations;
import com.mware.ge.FetchHints;
import com.mware.ge.GeException;
import com.mware.ge.Property;
import com.mware.ge.Vertex;
import com.mware.ge.Visibility;
import com.mware.ge.accumulo.AccumuloGraph;
import com.mware.ge.accumulo.iterator.VertexIterator;
import com.mware.ge.accumulo.iterator.model.ElementData;
import com.mware.ge.accumulo.iterator.model.VertexElementData;
import com.mware.ge.accumulo.mapreduce.AccumuloElementInputFormatBase;
import com.mware.ge.store.Edges;
import com.mware.ge.store.StorableGraph;
import com.mware.ge.store.StorableVertex;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.PeekingIterator;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;

public class AccumuloVertexInputFormat
extends AccumuloElementInputFormatBase<Vertex> {
    private static VertexIterator vertexIterator;

    public static void setInputInfo(Job job, AccumuloGraph graph, String instanceName, String zooKeepers, String principal, AuthenticationToken token, String[] authorizations) throws AccumuloSecurityException {
        String tableName = graph.getVerticesTableName();
        AccumuloVertexInputFormat.setInputInfo(job, instanceName, zooKeepers, principal, token, authorizations, tableName);
    }

    @Override
    protected Vertex createElementFromRow(AccumuloGraph graph, PeekingIterator<Map.Entry<Key, Value>> row, Authorizations authorizations) {
        return AccumuloVertexInputFormat.createVertex(graph, row, authorizations);
    }

    public static Vertex createVertex(AccumuloGraph graph, Iterator<Map.Entry<Key, Value>> row, Authorizations authorizations) {
        try {
            FetchHints fetchHints = graph.getDefaultFetchHints();
            VertexElementData vertexElementData = (VertexElementData)AccumuloVertexInputFormat.getVertexIterator(graph).createElementDataFromRows(row);
            if (vertexElementData == null) {
                return null;
            }
            Visibility visibility = AccumuloGraph.accumuloVisibilityToVisibility(AccumuloGraph.visibilityToAccumuloVisibility(vertexElementData.visibility.toString()));
            Iterable<Property> properties = AccumuloVertexInputFormat.makePropertiesFromElementData(graph, (ElementData)vertexElementData, graph.toIteratorFetchHints(fetchHints));
            Iterable propertyDeleteMutations = null;
            Iterable propertySoftDeleteMutations = null;
            Iterable hiddenVisibilities = Iterables.transform((Iterable)vertexElementData.hiddenVisibilities, (Function)new Function<Text, Visibility>(){

                @Nullable
                public Visibility apply(Text visibilityText) {
                    return AccumuloGraph.accumuloVisibilityToVisibility(AccumuloGraph.visibilityToAccumuloVisibility(visibilityText.toString()));
                }
            });
            ImmutableSet extendedDataTableNames = vertexElementData.extendedTableNames.size() > 0 ? ImmutableSet.copyOf((Collection)vertexElementData.extendedTableNames) : null;
            return new StorableVertex((StorableGraph)graph, vertexElementData.id.toString(), vertexElementData.conceptType.toString(), null, visibility, properties, propertyDeleteMutations, propertySoftDeleteMutations, hiddenVisibilities, extendedDataTableNames, (Edges)vertexElementData.inEdges, (Edges)vertexElementData.outEdges, vertexElementData.timestamp, fetchHints, authorizations);
        }
        catch (Throwable ex) {
            throw new GeException("Failed to create vertex", ex);
        }
    }

    private static VertexIterator getVertexIterator(AccumuloGraph graph) {
        if (vertexIterator == null) {
            vertexIterator = new VertexIterator(graph.toIteratorFetchHints(graph.getDefaultFetchHints()), true);
        }
        return vertexIterator;
    }
}

