/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.accumulo.mapreduce;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.mware.ge.Authorizations;
import com.mware.ge.Element;
import com.mware.ge.ElementType;
import com.mware.ge.FetchHints;
import com.mware.ge.Graph;
import com.mware.ge.GraphFactory;
import com.mware.ge.Property;
import com.mware.ge.Visibility;
import com.mware.ge.accumulo.AccumuloGraph;
import com.mware.ge.accumulo.iterator.model.ElementData;
import com.mware.ge.accumulo.iterator.model.IteratorFetchHints;
import com.mware.ge.accumulo.iterator.util.ByteSequenceUtils;
import com.mware.ge.accumulo.mapreduce.GeMRUtils;
import com.mware.ge.store.util.LazyMutableProperty;
import com.mware.ge.util.MapUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.mapreduce.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapreduce.AccumuloRowInputFormat;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.PeekingIterator;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public abstract class AccumuloElementInputFormatBase<TValue extends Element>
extends InputFormat<Text, TValue> {
    private final AccumuloRowInputFormat accumuloInputFormat = new AccumuloRowInputFormat();

    public static void setInputInfo(Job job, String instanceName, String zooKeepers, String principal, AuthenticationToken token, String[] authorizations, String tableName) throws AccumuloSecurityException {
        AccumuloRowInputFormat.setInputTableName((Job)job, (String)tableName);
        AccumuloRowInputFormat.setConnectorInfo((Job)job, (String)principal, (AuthenticationToken)token);
        ClientConfiguration clientConfig = new ClientConfiguration(new Configuration[0]).withInstance(instanceName).withZkHosts(zooKeepers);
        AccumuloRowInputFormat.setZooKeeperInstance((Job)job, (ClientConfiguration)clientConfig);
        AccumuloRowInputFormat.setScanAuthorizations((Job)job, (org.apache.accumulo.core.security.Authorizations)new org.apache.accumulo.core.security.Authorizations(authorizations));
        job.getConfiguration().setStrings("authorizations", authorizations);
    }

    public static void setFetchHints(Job job, ElementType elementType, FetchHints fetchHints) {
        Iterable<Text> columnFamiliesToFetch = AccumuloGraph.getColumnFamiliesToFetch(elementType, fetchHints);
        ArrayList<Pair> columnFamilyColumnQualifierPairs = new ArrayList<Pair>();
        for (Text columnFamilyToFetch : columnFamiliesToFetch) {
            columnFamilyColumnQualifierPairs.add(new Pair((Object)columnFamilyToFetch, null));
        }
        AccumuloInputFormat.fetchColumns((Job)job, columnFamilyColumnQualifierPairs);
    }

    public List<InputSplit> getSplits(JobContext jobContext) throws IOException {
        return this.accumuloInputFormat.getSplits(jobContext);
    }

    public RecordReader<Text, TValue> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        final RecordReader reader = this.accumuloInputFormat.createRecordReader(inputSplit, taskAttemptContext);
        return new RecordReader<Text, TValue>(){
            public AccumuloGraph graph;
            public Authorizations authorizations;

            public void initialize(InputSplit inputSplit, TaskAttemptContext ctx) throws IOException, InterruptedException {
                reader.initialize(inputSplit, ctx);
                Map configurationMap = GeMRUtils.toMap(ctx.getConfiguration());
                this.graph = (AccumuloGraph)new GraphFactory().createGraph(MapUtils.getAllWithPrefix((Map)configurationMap, (String)"graph"));
                this.authorizations = new Authorizations(ctx.getConfiguration().getStrings("authorizations"));
            }

            public boolean nextKeyValue() throws IOException, InterruptedException {
                return reader.nextKeyValue();
            }

            public Text getCurrentKey() throws IOException, InterruptedException {
                return (Text)reader.getCurrentKey();
            }

            public TValue getCurrentValue() throws IOException, InterruptedException {
                PeekingIterator row = (PeekingIterator)reader.getCurrentValue();
                return AccumuloElementInputFormatBase.this.createElementFromRow(this.graph, (PeekingIterator<Map.Entry<Key, Value>>)row, this.authorizations);
            }

            public float getProgress() throws IOException, InterruptedException {
                return reader.getProgress();
            }

            public void close() throws IOException {
                reader.close();
            }
        };
    }

    protected abstract TValue createElementFromRow(AccumuloGraph var1, PeekingIterator<Map.Entry<Key, Value>> var2, Authorizations var3);

    protected static Iterable<Property> makePropertiesFromElementData(final AccumuloGraph graph, ElementData elementData, IteratorFetchHints fetchHints) {
        return Iterables.transform((Iterable)elementData.getProperties(fetchHints), (Function)new Function<com.mware.ge.accumulo.iterator.model.Property, Property>(){

            @Nullable
            public Property apply(@Nullable com.mware.ge.accumulo.iterator.model.Property property) {
                return AccumuloElementInputFormatBase.makePropertyFromIteratorProperty(graph, property);
            }
        });
    }

    private static Property makePropertyFromIteratorProperty(AccumuloGraph graph, com.mware.ge.accumulo.iterator.model.Property property) {
        HashSet hiddenVisibilities = null;
        if (property.hiddenVisibilities != null) {
            hiddenVisibilities = Sets.newHashSet((Iterable)Iterables.transform((Iterable)property.hiddenVisibilities, (Function)new Function<ByteSequence, Visibility>(){

                @Nullable
                public Visibility apply(ByteSequence visibilityText) {
                    return AccumuloGraph.accumuloVisibilityToVisibility(AccumuloGraph.visibilityToAccumuloVisibility(ByteSequenceUtils.toString((ByteSequence)visibilityText)));
                }
            }));
        }
        Visibility visibility = AccumuloGraph.accumuloVisibilityToVisibility(AccumuloGraph.visibilityToAccumuloVisibility(property.visibility));
        return new LazyMutableProperty((Graph)graph, graph.getGeSerializer(), graph.getNameSubstitutionStrategy().inflate(new String(property.key.toArray())), graph.getNameSubstitutionStrategy().inflate(new String(property.name.toArray())), property.value, null, (Set)hiddenVisibilities, visibility, property.timestamp, FetchHints.ALL_INCLUDING_HIDDEN);
    }
}

