/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.accumulo;

import com.google.common.collect.Lists;
import com.mware.ge.GeException;
import com.mware.ge.accumulo.AccumuloGraph;
import com.mware.ge.accumulo.StreamingPropertyValueTableRef;
import com.mware.ge.accumulo.keys.DataTableRowKey;
import com.mware.ge.accumulo.util.RangeUtils;
import com.mware.ge.values.storable.StreamingPropertyValue;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.user.TimestampFilter;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.trace.Span;
import org.apache.accumulo.core.trace.Trace;

public class StreamingPropertyValueTable
extends StreamingPropertyValue {
    private static final long serialVersionUID = 400244414843534240L;
    private final AccumuloGraph graph;
    private final String dataRowKey;
    private final Long timestamp;
    private transient byte[] data;

    StreamingPropertyValueTable(AccumuloGraph graph, String dataRowKey, StreamingPropertyValueTableRef valueRef, Long timestamp) {
        super(valueRef.getValueType());
        this.timestamp = timestamp;
        this.searchIndex(valueRef.isSearchIndex());
        this.graph = graph;
        this.dataRowKey = dataRowKey;
        this.data = valueRef.getData();
    }

    public Long getLength() {
        this.ensureDataLoaded();
        return this.data.length;
    }

    public String getDataRowKey() {
        return this.dataRowKey;
    }

    public boolean isDataLoaded() {
        return this.data != null;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public InputStream getInputStream() {
        this.ensureDataLoaded();
        return new ByteArrayInputStream(this.data);
    }

    private void ensureDataLoaded() {
        if (!this.isDataLoaded()) {
            this.data = this.streamingPropertyValueTableData(this.dataRowKey, this.timestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] streamingPropertyValueTableData(String dataRowKey, Long timestamp) {
        Iterator iterator;
        ArrayList ranges = Lists.newArrayList((Object[])new Range[]{RangeUtils.createRangeFromString(dataRowKey)});
        long timerStartTime = System.currentTimeMillis();
        ScannerBase scanner = this.graph.createBatchScanner(this.graph.getDataTableName(), (Collection<Range>)ranges, new Authorizations());
        if (timestamp != null && !DataTableRowKey.isLegacy(dataRowKey) && this.graph.getConfiguration().getMaxVersions() > 1) {
            IteratorSetting iteratorSetting = new IteratorSetting(80, TimestampFilter.class.getSimpleName(), TimestampFilter.class);
            TimestampFilter.setStart((IteratorSetting)iteratorSetting, (long)timestamp, (boolean)true);
            TimestampFilter.setEnd((IteratorSetting)iteratorSetting, (long)timestamp, (boolean)true);
            scanner.addScanIterator(iteratorSetting);
        }
        AccumuloGraph.GRAPH_LOGGER.logStartIterator(this.graph.getDataTableName(), scanner);
        Span trace = Trace.start((String)"streamingPropertyValueTableData");
        trace.data("dataRowKeyCount", Integer.toString(1));
        try {
            byte[] result = null;
            for (Map.Entry col : scanner) {
                String foundKey = ((Key)col.getKey()).getRow().toString();
                byte[] value = ((Value)col.getValue()).get();
                if (!foundKey.equals(dataRowKey)) continue;
                result = value;
            }
            if (result == null) {
                throw new GeException("Could not find data with key: " + dataRowKey);
            }
            iterator = result;
        }
        catch (Throwable throwable) {
            try {
                scanner.close();
                trace.stop();
                AccumuloGraph.GRAPH_LOGGER.logEndIterator(System.currentTimeMillis() - timerStartTime);
                throw throwable;
            }
            catch (Exception ex) {
                throw new GeException((Throwable)ex);
            }
        }
        scanner.close();
        trace.stop();
        AccumuloGraph.GRAPH_LOGGER.logEndIterator(System.currentTimeMillis() - timerStartTime);
        return iterator;
    }
}

