/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.accumulo;

import com.mware.ge.GeException;
import com.mware.ge.accumulo.StreamingPropertyValueHdfsRef;
import com.mware.ge.values.storable.StreamingPropertyValue;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

class StreamingPropertyValueHdfs
extends StreamingPropertyValue {
    private static final long serialVersionUID = 5936794077542255789L;
    private final FileSystem fs;
    private final Path path;

    public StreamingPropertyValueHdfs(FileSystem fs, Path path, StreamingPropertyValueHdfsRef streamingPropertyValueRef) {
        super(streamingPropertyValueRef.getValueType());
        this.searchIndex(streamingPropertyValueRef.isSearchIndex());
        this.fs = fs;
        this.path = path;
    }

    public Long getLength() {
        try {
            return this.fs.getFileStatus(this.path).getLen();
        }
        catch (IOException ex) {
            throw new GeException("Could not get length of: " + this.path, (Throwable)ex);
        }
    }

    public InputStream getInputStream() {
        try {
            return this.fs.open(this.path);
        }
        catch (IOException ex) {
            throw new GeException("Could not open: " + this.path, (Throwable)ex);
        }
    }
}

