/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.accumulo;

import com.mware.ge.Authorizations;
import com.mware.ge.GeException;
import com.mware.ge.GraphMetadataEntry;
import com.mware.ge.accumulo.AccumuloGraph;
import com.mware.ge.store.AbstractStorableGraph;
import com.mware.ge.store.DistributedMetadataStore;
import com.mware.ge.store.mutations.StoreMutation;
import com.mware.ge.util.LookAheadIterable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.user.VersioningIterator;

public class AccumuloMetadataStore
extends DistributedMetadataStore {
    private static final Authorizations METADATA_AUTHORIZATIONS = new Authorizations(new String[0]);

    public AccumuloMetadataStore(AccumuloGraph graph) {
        super((AbstractStorableGraph)graph);
    }

    protected void write(StoreMutation m) throws IOException {
        BatchWriter writer = ((AccumuloGraph)this.graph).getMetadataWriter();
        try {
            writer.addMutation(AccumuloGraph.toAccumuloMutation(m));
        }
        catch (MutationsRejectedException e) {
            throw new IOException(e);
        }
    }

    protected void delete(StoreMutation m) throws IOException {
        BatchWriter writer = ((AccumuloGraph)this.graph).getMetadataWriter();
        try {
            writer.addMutation(AccumuloGraph.toAccumuloMutation(m));
        }
        catch (MutationsRejectedException e) {
            throw new IOException(e);
        }
    }

    public Iterable<GraphMetadataEntry> getAllMetadata() {
        final AccumuloGraph accumuloGraph = (AccumuloGraph)this.graph;
        return new LookAheadIterable<Map.Entry<Key, Value>, GraphMetadataEntry>(){
            public Scanner scanner;

            protected boolean isIncluded(Map.Entry<Key, Value> src, GraphMetadataEntry graphMetadataEntry) {
                return true;
            }

            protected GraphMetadataEntry convert(Map.Entry<Key, Value> entry) {
                String key = entry.getKey().getRow().toString();
                return new GraphMetadataEntry(key, entry.getValue().get());
            }

            protected Iterator<Map.Entry<Key, Value>> createIterator() {
                try {
                    this.scanner = accumuloGraph.createScanner(AccumuloMetadataStore.this.graph.getMetadataTableName(), null, METADATA_AUTHORIZATIONS);
                    IteratorSetting versioningIteratorSettings = new IteratorSetting(90, VersioningIterator.class.getSimpleName(), VersioningIterator.class);
                    VersioningIterator.setMaxVersions((IteratorSetting)versioningIteratorSettings, (int)1);
                    this.scanner.addScanIterator(versioningIteratorSettings);
                    return this.scanner.iterator();
                }
                catch (TableNotFoundException ex) {
                    throw new GeException("Could not create metadata scanner", (Throwable)ex);
                }
            }

            public void close() {
                super.close();
                this.scanner.close();
            }
        };
    }
}

