/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.accumulo;

import com.mware.ge.GeException;
import com.mware.ge.Graph;
import com.mware.ge.GraphConfiguration;
import com.mware.ge.accumulo.util.OverflowIntoHdfsStreamingPropertyValueStorageStrategy;
import com.mware.ge.id.IdentityNameSubstitutionStrategy;
import com.mware.ge.id.NameSubstitutionStrategy;
import com.mware.ge.store.StorableGraphConfiguration;
import com.mware.ge.store.util.StreamingPropertyValueStorageStrategy;
import com.mware.ge.util.ConfigurationUtils;
import com.mware.ge.util.GeLogger;
import com.mware.ge.util.GeLoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.fs.FileSystem;

public class AccumuloGraphConfiguration
extends StorableGraphConfiguration {
    private static final GeLogger LOGGER = GeLoggerFactory.getLogger(AccumuloGraphConfiguration.class);
    public static final String HDFS_CONFIG_PREFIX = "hdfs";
    public static final String BATCHWRITER_CONFIG_PREFIX = "batchwriter";
    public static final String ACCUMULO_INSTANCE_NAME = "accumuloInstanceName";
    public static final String ACCUMULO_USERNAME = "username";
    public static final String ACCUMULO_PASSWORD = "password";
    public static final String ACCUMULO_MAX_VERSIONS = "maxVersions";
    public static final String ACCUMULO_MAX_EXTENDED_DATA_VERSIONS = "maxExtendedDataVersions";
    public static final String NAME_SUBSTITUTION_STRATEGY_PROP_PREFIX = "nameSubstitutionStrategy";
    public static final String MAX_STREAMING_PROPERTY_VALUE_TABLE_DATA_SIZE = "maxStreamingPropertyValueTableDataSize";
    public static final String HDFS_USER = "hdfs.user";
    public static final String HDFS_ROOT_DIR = "hdfs.rootDir";
    public static final String DATA_DIR = "hdfs.dataDir";
    public static final String BACKUP_DIR = "hdfs.backupDir";
    public static final String BATCHWRITER_MAX_MEMORY = "batchwriter.maxMemory";
    public static final String BATCHWRITER_MAX_LATENCY = "batchwriter.maxLatency";
    public static final String BATCHWRITER_TIMEOUT = "batchwriter.timeout";
    public static final String BATCHWRITER_MAX_WRITE_THREADS = "batchwriter.maxWriteThreads";
    public static final String NUMBER_OF_QUERY_THREADS = "numberOfQueryThreads";
    public static final String HDFS_CONTEXT_CLASSPATH = "hdfsContextClasspath";
    public static final String STREAMING_PROPERTY_VALUE_STORAGE_STRATEGY_PREFIX = "streamingPropertyValueStorageStrategy";
    public static final String CLIENT_CONFIGURATION_PROPERTY_CONFIG_PREFIX = "clientConfiguration.";
    public static final String LARGE_VALUE_ERROR_THRESHOLD = "largeValueErrorThreshold";
    public static final String LARGE_VALUE_WARNING_THRESHOLD = "largeValueWarningThreshold";
    public static final String COMPRESS_ITERATOR_TRANSFERS = "compressIteratorTransfers";
    public static final String DEFAULT_ACCUMULO_PASSWORD = "password";
    public static final String DEFAULT_ACCUMULO_USERNAME = "root";
    public static final String DEFAULT_ACCUMULO_INSTANCE_NAME = "accumulo";
    public static final int DEFAULT_MAX_STREAMING_PROPERTY_VALUE_TABLE_DATA_SIZE = 0xA00000;
    public static final String DEFAULT_HDFS_USER = "hdfs";
    public static final String DEFAULT_HDFS_ROOT_DIR = "";
    public static final String HADOOP_CONF_DIR = "hdfs.confDir";
    public static final String DEFAULT_BACKUP_DIR = "/bigconnect/backup";
    public static final String DEFAULT_DATA_DIR = "/accumuloGraph";
    private static final String DEFAULT_NAME_SUBSTITUTION_STRATEGY = IdentityNameSubstitutionStrategy.class.getName();
    public static final Long DEFAULT_BATCHWRITER_MAX_MEMORY = 0x6400000L;
    public static final Long DEFAULT_BATCHWRITER_MAX_LATENCY = 120000L;
    public static final Long DEFAULT_BATCHWRITER_TIMEOUT = Long.MAX_VALUE;
    public static final Integer DEFAULT_BATCHWRITER_MAX_WRITE_THREADS = 8;
    public static final Integer DEFAULT_ACCUMULO_MAX_VERSIONS = 1;
    public static final int DEFAULT_NUMBER_OF_QUERY_THREADS = 100;
    public static final String DEFAULT_HDFS_CONTEXT_CLASSPATH = null;
    public static final String DEFAULT_STREAMING_PROPERTY_VALUE_STORAGE_STRATEGY = OverflowIntoHdfsStreamingPropertyValueStorageStrategy.class.getName();
    public static final int DEFAULT_LARGE_VALUE_ERROR_THRESHOLD = 524288000;
    public static final int DEFAULT_LARGE_VALUE_WARNING_THRESHOLD = 0x6400000;
    public static final boolean DEFAULT_COMPRESS_ITERATOR_TRANSFERS = true;
    public static final String[] HADOOP_CONF_FILENAMES = new String[]{"core-site.xml", "hdfs-site.xml", "mapred-site.xml", "yarn-site.xml"};

    public AccumuloGraphConfiguration(Map<String, Object> config) {
        super(config);
    }

    public AccumuloGraphConfiguration(org.apache.hadoop.conf.Configuration configuration, String prefix) {
        super(AccumuloGraphConfiguration.toMap(configuration, prefix));
    }

    private static Map<String, Object> toMap(org.apache.hadoop.conf.Configuration configuration, String prefix) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry entry : configuration) {
            String key = (String)entry.getKey();
            if (key.startsWith(prefix)) {
                key = key.substring(prefix.length());
            }
            map.put(key, entry.getValue());
        }
        return map;
    }

    public Connector createConnector() {
        try {
            LOGGER.info("Connecting to accumulo instance [%s] zookeeper servers [%s]", new Object[]{this.getAccumuloInstanceName(), this.getZookeeperServers()});
            ZooKeeperInstance instance = new ZooKeeperInstance(this.getClientConfiguration());
            return instance.getConnector(this.getAccumuloUsername(), this.getAuthenticationToken());
        }
        catch (Exception ex) {
            throw new GeException(String.format("Could not connect to Accumulo instance [%s] zookeeper servers [%s]", this.getAccumuloInstanceName(), this.getZookeeperServers()), (Throwable)ex);
        }
    }

    public ClientConfiguration getClientConfiguration() {
        ClientConfiguration config = new ClientConfiguration(new Configuration[0]).withInstance(this.getAccumuloInstanceName()).withZkHosts(this.getZookeeperServers());
        for (Map.Entry<String, String> entry : this.getClientConfigurationProperties().entrySet()) {
            config.setProperty(entry.getKey(), entry.getValue());
        }
        return config;
    }

    public Map<String, String> getClientConfigurationProperties() {
        HashMap<String, String> results = new HashMap<String, String>();
        for (Map.Entry o : this.getConfig().entrySet()) {
            String key;
            Map.Entry mapEntry = o;
            if (!(mapEntry.getKey() instanceof String) || !(mapEntry.getValue() instanceof String) || !(key = (String)mapEntry.getKey()).startsWith(CLIENT_CONFIGURATION_PROPERTY_CONFIG_PREFIX)) continue;
            String configName = key.substring(CLIENT_CONFIGURATION_PROPERTY_CONFIG_PREFIX.length());
            results.put(configName, (String)mapEntry.getValue());
        }
        return results;
    }

    public FileSystem createFileSystem() throws URISyntaxException, IOException, InterruptedException {
        return FileSystem.get((URI)this.getHdfsRootDir(), (org.apache.hadoop.conf.Configuration)this.getHadoopConfiguration(), (String)this.getHdfsUser());
    }

    public String getHdfsUser() {
        return this.getString(HDFS_USER, "hdfs");
    }

    public URI getHdfsRootDir() throws URISyntaxException {
        return new URI(this.getString(HDFS_ROOT_DIR, DEFAULT_HDFS_ROOT_DIR));
    }

    public org.apache.hadoop.conf.Configuration getHadoopConfiguration() {
        org.apache.hadoop.conf.Configuration configuration = new org.apache.hadoop.conf.Configuration();
        Iterator iterator = this.getConfig().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entrySetObject;
            Map.Entry entrySet = entrySetObject = iterator.next();
            configuration.set(DEFAULT_HDFS_ROOT_DIR + entrySet.getKey(), DEFAULT_HDFS_ROOT_DIR + entrySet.getValue());
        }
        this.loadHadoopConfigs(configuration);
        return configuration;
    }

    private void loadHadoopConfigs(org.apache.hadoop.conf.Configuration configuration) {
        String hadoopConfDir = this.getString(HADOOP_CONF_DIR, null);
        if (hadoopConfDir != null) {
            LOGGER.info("hadoop conf dir", new Object[]{hadoopConfDir});
            File dir = new File(hadoopConfDir);
            if (dir.isDirectory()) {
                for (String xmlFilename : HADOOP_CONF_FILENAMES) {
                    File file = new File(dir, xmlFilename);
                    if (!file.isFile()) continue;
                    LOGGER.info("adding resource: %s to Hadoop configuration", new Object[]{file});
                    try {
                        FileInputStream in = new FileInputStream(file);
                        configuration.addResource((InputStream)in);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("error adding resource: " + xmlFilename + " to Hadoop configuration", (Throwable)ex);
                    }
                }
                StringBuilder sb = new StringBuilder();
                TreeSet keys = new TreeSet();
                for (Map.Entry entry : configuration) {
                    keys.add(entry.getKey());
                }
                LOGGER.debug("Hadoop configuration:%n%s", new Object[]{sb.toString()});
            } else {
                LOGGER.warn("configuration property %s is not a directory", new Object[]{HADOOP_CONF_DIR});
            }
        }
    }

    public AuthenticationToken getAuthenticationToken() {
        String password = this.getString("password", "password");
        return new PasswordToken((CharSequence)password);
    }

    public String getAccumuloUsername() {
        return this.getString(ACCUMULO_USERNAME, DEFAULT_ACCUMULO_USERNAME);
    }

    public String getAccumuloInstanceName() {
        return this.getString(ACCUMULO_INSTANCE_NAME, DEFAULT_ACCUMULO_INSTANCE_NAME);
    }

    public boolean isAutoFlush() {
        return this.getBoolean("autoFlush", false);
    }

    public long getMaxStreamingPropertyValueTableDataSize() {
        return this.getConfigLong(MAX_STREAMING_PROPERTY_VALUE_TABLE_DATA_SIZE, 0xA00000L);
    }

    public String getBackupDir() {
        return this.getString(BACKUP_DIR, DEFAULT_BACKUP_DIR);
    }

    public String getDataDir() {
        return this.getString(DATA_DIR, DEFAULT_DATA_DIR);
    }

    public NameSubstitutionStrategy createSubstitutionStrategy(Graph graph) {
        NameSubstitutionStrategy strategy = (NameSubstitutionStrategy)ConfigurationUtils.createProvider((Graph)graph, (GraphConfiguration)this, (String)NAME_SUBSTITUTION_STRATEGY_PROP_PREFIX, (String)DEFAULT_NAME_SUBSTITUTION_STRATEGY);
        strategy.setup(this.getConfig());
        return strategy;
    }

    public StreamingPropertyValueStorageStrategy createStreamingPropertyValueStorageStrategy(Graph graph) {
        return (StreamingPropertyValueStorageStrategy)ConfigurationUtils.createProvider((Graph)graph, (GraphConfiguration)this, (String)STREAMING_PROPERTY_VALUE_STORAGE_STRATEGY_PREFIX, (String)DEFAULT_STREAMING_PROPERTY_VALUE_STORAGE_STRATEGY);
    }

    public BatchWriterConfig createBatchWriterConfig() {
        long maxMemory = this.getConfigLong(BATCHWRITER_MAX_MEMORY, DEFAULT_BATCHWRITER_MAX_MEMORY);
        long maxLatency = this.getConfigLong(BATCHWRITER_MAX_LATENCY, DEFAULT_BATCHWRITER_MAX_LATENCY);
        int maxWriteThreads = this.getInt(BATCHWRITER_MAX_WRITE_THREADS, DEFAULT_BATCHWRITER_MAX_WRITE_THREADS);
        long timeout = this.getConfigLong(BATCHWRITER_TIMEOUT, DEFAULT_BATCHWRITER_TIMEOUT);
        BatchWriterConfig config = new BatchWriterConfig();
        config.setMaxMemory(maxMemory);
        config.setMaxLatency(maxLatency, TimeUnit.MILLISECONDS);
        config.setMaxWriteThreads(maxWriteThreads);
        config.setTimeout(timeout, TimeUnit.MILLISECONDS);
        return config;
    }

    public Integer getMaxVersions() {
        return this.getInteger(ACCUMULO_MAX_VERSIONS, DEFAULT_ACCUMULO_MAX_VERSIONS);
    }

    public Integer getExtendedDataMaxVersions() {
        return this.getInteger(ACCUMULO_MAX_EXTENDED_DATA_VERSIONS, this.getMaxVersions());
    }

    public int getNumberOfQueryThreads() {
        return this.getInt(NUMBER_OF_QUERY_THREADS, 100);
    }

    public String getHdfsContextClasspath() {
        return this.getString(HDFS_CONTEXT_CLASSPATH, DEFAULT_HDFS_CONTEXT_CLASSPATH);
    }

    public int getLargeValueErrorThreshold() {
        return this.getInt(LARGE_VALUE_ERROR_THRESHOLD, 524288000);
    }

    public int getLargeValueWarningThreshold() {
        return this.getInt(LARGE_VALUE_WARNING_THRESHOLD, 0x6400000);
    }

    public boolean isCompressIteratorTransfers() {
        return this.getBoolean(COMPRESS_ITERATOR_TRANSFERS, true);
    }
}

