/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.accumulo;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mware.ge.Authorizations;
import com.mware.ge.Edge;
import com.mware.ge.Element;
import com.mware.ge.ElementFilter;
import com.mware.ge.ElementId;
import com.mware.ge.ElementType;
import com.mware.ge.ExtendedDataRow;
import com.mware.ge.ExtendedDataRowId;
import com.mware.ge.FetchHints;
import com.mware.ge.FindPathOptions;
import com.mware.ge.GeException;
import com.mware.ge.GeObjectType;
import com.mware.ge.Graph;
import com.mware.ge.GraphMetadataStore;
import com.mware.ge.HistoricalPropertyValue;
import com.mware.ge.IdRange;
import com.mware.ge.Metadata;
import com.mware.ge.Path;
import com.mware.ge.ProgressCallback;
import com.mware.ge.Property;
import com.mware.ge.RelatedEdge;
import com.mware.ge.RelatedEdgeImpl;
import com.mware.ge.SecurityGeException;
import com.mware.ge.Traceable;
import com.mware.ge.Vertex;
import com.mware.ge.Visibility;
import com.mware.ge.accumulo.AccumuloElement;
import com.mware.ge.accumulo.AccumuloFindPathStrategy;
import com.mware.ge.accumulo.AccumuloGraphConfiguration;
import com.mware.ge.accumulo.AccumuloGraphLogger;
import com.mware.ge.accumulo.AccumuloMetadataStore;
import com.mware.ge.accumulo.AccumuloNameSubstitutionStrategy;
import com.mware.ge.accumulo.StreamingPropertyValueTableRef;
import com.mware.ge.accumulo.iterator.CountingIterator;
import com.mware.ge.accumulo.iterator.EdgeIterator;
import com.mware.ge.accumulo.iterator.EdgeRefFilter;
import com.mware.ge.accumulo.iterator.HasAuthorizationFilter;
import com.mware.ge.accumulo.iterator.VertexEdgeIdIterator;
import com.mware.ge.accumulo.iterator.VertexIterator;
import com.mware.ge.accumulo.iterator.model.IteratorFetchHints;
import com.mware.ge.accumulo.iterator.model.PropertyColumnQualifier;
import com.mware.ge.accumulo.iterator.model.PropertyMetadataColumnQualifier;
import com.mware.ge.accumulo.iterator.util.ByteArrayWrapper;
import com.mware.ge.accumulo.iterator.util.ByteSequenceUtils;
import com.mware.ge.accumulo.keys.KeyHelper;
import com.mware.ge.accumulo.tools.HDFSGraphBackup;
import com.mware.ge.accumulo.tools.HDFSGraphRestore;
import com.mware.ge.accumulo.util.DataInputStreamUtils;
import com.mware.ge.accumulo.util.GeTabletServerBatchReader;
import com.mware.ge.accumulo.util.RangeUtils;
import com.mware.ge.accumulo.util.SnappyUtils;
import com.mware.ge.event.GraphEvent;
import com.mware.ge.security.ColumnVisibility;
import com.mware.ge.serializer.GeSerializer;
import com.mware.ge.store.AbstractStorableGraph;
import com.mware.ge.store.Edges;
import com.mware.ge.store.StorableEdge;
import com.mware.ge.store.StorableEdgeInfo;
import com.mware.ge.store.StorableExtendedDataRow;
import com.mware.ge.store.StorableGraph;
import com.mware.ge.store.StorableGraphConfiguration;
import com.mware.ge.store.StorableVertex;
import com.mware.ge.store.mutations.StoreColumnUpdate;
import com.mware.ge.store.mutations.StoreMutation;
import com.mware.ge.store.util.KeyBase;
import com.mware.ge.store.util.MetadataEntry;
import com.mware.ge.store.util.StorableKeyHelper;
import com.mware.ge.tools.GraphBackup;
import com.mware.ge.tools.GraphRestore;
import com.mware.ge.util.CloseableIterable;
import com.mware.ge.util.EmptyClosableIterable;
import com.mware.ge.util.GeLogger;
import com.mware.ge.util.GeLoggerFactory;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.util.LookAheadIterable;
import com.mware.ge.values.storable.StreamingPropertyValueRef;
import com.mware.ge.values.storable.Value;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.MultiTableBatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.LongCombiner;
import org.apache.accumulo.core.iterators.WholeRowIterator;
import org.apache.accumulo.core.iterators.user.RowDeletingIterator;
import org.apache.accumulo.core.iterators.user.TimestampFilter;
import org.apache.accumulo.core.iterators.user.VersioningIterator;
import org.apache.accumulo.core.trace.DistributedTrace;
import org.apache.accumulo.core.trace.Span;
import org.apache.accumulo.core.trace.Trace;
import org.apache.hadoop.io.Text;

public class AccumuloGraph
extends AbstractStorableGraph<StorableVertex, StorableEdge>
implements Traceable {
    private static final GeLogger LOGGER = GeLoggerFactory.getLogger(AccumuloGraph.class);
    public static final AccumuloGraphLogger GRAPH_LOGGER = new AccumuloGraphLogger(QUERY_LOGGER);
    private static final String ROW_DELETING_ITERATOR_NAME = RowDeletingIterator.class.getSimpleName();
    private static final int ROW_DELETING_ITERATOR_PRIORITY = 7;
    public static final int SINGLE_VERSION = 1;
    public static final Integer ALL_VERSIONS = null;
    private static final int ACCUMULO_DEFAULT_VERSIONING_ITERATOR_PRIORITY = 20;
    private static final String ACCUMULO_DEFAULT_VERSIONING_ITERATOR_NAME = "vers";
    private static final String CLASSPATH_CONTEXT_NAME = "ge";
    private static final Object addIteratorLock = new Object();
    private static final ColumnVisibility EMPTY_COLUMN_VISIBILITY = new ColumnVisibility();
    private final Connector connector;
    private final MultiTableBatchWriter batchWriter;
    private final int numberOfQueryThreads;
    private final boolean compressIteratorTransfers;
    private boolean distributedTraceEnabled;
    private int largeValueErrorThreshold;
    private int largeValueWarningThreshold;

    protected AccumuloGraph(AccumuloGraphConfiguration config, Connector connector) {
        super((StorableGraphConfiguration)config);
        this.connector = connector;
        this.nameSubstitutionStrategy = AccumuloNameSubstitutionStrategy.create(config.createSubstitutionStrategy((Graph)this));
        this.setGraphMetadataStore((GraphMetadataStore)new AccumuloMetadataStore(this));
        this.numberOfQueryThreads = this.getConfiguration().getNumberOfQueryThreads();
        this.largeValueErrorThreshold = this.getConfiguration().getLargeValueErrorThreshold();
        this.largeValueWarningThreshold = this.getConfiguration().getLargeValueWarningThreshold();
        this.compressIteratorTransfers = this.getConfiguration().isCompressIteratorTransfers() && SnappyUtils.testSnappySupport();
        BatchWriterConfig writerConfig = this.getConfiguration().createBatchWriterConfig();
        this.batchWriter = connector.createMultiTableBatchWriter(writerConfig);
    }

    public static AccumuloGraph create(AccumuloGraphConfiguration config) {
        if (config == null) {
            throw new IllegalArgumentException("config cannot be null");
        }
        Connector connector = config.createConnector();
        if (config.isHistoryInSeparateTable()) {
            AccumuloGraph.ensureTableExists(connector, AccumuloGraph.getVerticesTableName((String)config.getTableNamePrefix()), 1, config.getHdfsContextClasspath(), config.isCreateTables(), config);
            AccumuloGraph.ensureTableExists(connector, AccumuloGraph.getEdgesTableName((String)config.getTableNamePrefix()), 1, config.getHdfsContextClasspath(), config.isCreateTables(), config);
            AccumuloGraph.ensureTableExists(connector, AccumuloGraph.getHistoryVerticesTableName((String)config.getTableNamePrefix()), config.getMaxVersions(), config.getHdfsContextClasspath(), config.isCreateTables(), config);
            AccumuloGraph.ensureTableExists(connector, AccumuloGraph.getHistoryEdgesTableName((String)config.getTableNamePrefix()), config.getMaxVersions(), config.getHdfsContextClasspath(), config.isCreateTables(), config);
            AccumuloGraph.ensureRowDeletingIteratorIsAttached(connector, AccumuloGraph.getHistoryVerticesTableName((String)config.getTableNamePrefix()));
            AccumuloGraph.ensureRowDeletingIteratorIsAttached(connector, AccumuloGraph.getHistoryEdgesTableName((String)config.getTableNamePrefix()));
        } else {
            AccumuloGraph.ensureTableExists(connector, AccumuloGraph.getVerticesTableName((String)config.getTableNamePrefix()), config.getMaxVersions(), config.getHdfsContextClasspath(), config.isCreateTables(), config);
            AccumuloGraph.ensureTableExists(connector, AccumuloGraph.getEdgesTableName((String)config.getTableNamePrefix()), config.getMaxVersions(), config.getHdfsContextClasspath(), config.isCreateTables(), config);
        }
        AccumuloGraph.ensureTableExists(connector, AccumuloGraph.getExtendedDataTableName((String)config.getTableNamePrefix()), config.getExtendedDataMaxVersions(), config.getHdfsContextClasspath(), config.isCreateTables(), config);
        AccumuloGraph.ensureTableExists(connector, AccumuloGraph.getDataTableName((String)config.getTableNamePrefix()), 1, config.getHdfsContextClasspath(), config.isCreateTables(), config);
        AccumuloGraph.ensureTableExists(connector, AccumuloGraph.getMetadataTableName((String)config.getTableNamePrefix()), 1, config.getHdfsContextClasspath(), config.isCreateTables(), config);
        AccumuloGraph.ensureRowDeletingIteratorIsAttached(connector, AccumuloGraph.getVerticesTableName((String)config.getTableNamePrefix()));
        AccumuloGraph.ensureRowDeletingIteratorIsAttached(connector, AccumuloGraph.getEdgesTableName((String)config.getTableNamePrefix()));
        AccumuloGraph.ensureRowDeletingIteratorIsAttached(connector, AccumuloGraph.getDataTableName((String)config.getTableNamePrefix()));
        AccumuloGraph.ensureRowDeletingIteratorIsAttached(connector, AccumuloGraph.getExtendedDataTableName((String)config.getTableNamePrefix()));
        AccumuloGraph graph = new AccumuloGraph(config, connector);
        graph.setup();
        return graph;
    }

    protected static void ensureTableExists(Connector connector, String tableName, Integer maxVersions, String hdfsContextClasspath, boolean createTable, AccumuloGraphConfiguration config) {
        try {
            if (!connector.tableOperations().exists(tableName)) {
                if (!createTable) {
                    throw new GeException("Table '" + tableName + "' does not exist and 'graph." + "createTables" + "' is set to false");
                }
                NewTableConfiguration ntc = new NewTableConfiguration().setTimeType(TimeType.MILLIS).withoutDefaultIterators();
                connector.tableOperations().create(tableName, ntc);
                if (maxVersions != null) {
                    IteratorSetting versioningSettings = new IteratorSetting(20, ACCUMULO_DEFAULT_VERSIONING_ITERATOR_NAME, VersioningIterator.class);
                    VersioningIterator.setMaxVersions((IteratorSetting)versioningSettings, (int)maxVersions);
                    EnumSet<IteratorUtil.IteratorScope> scope = EnumSet.allOf(IteratorUtil.IteratorScope.class);
                    connector.tableOperations().attachIterator(tableName, versioningSettings, scope);
                }
                if (tableName.equals(AccumuloGraph.getVerticesTableName((String)config.getTableNamePrefix())) || tableName.equals(AccumuloGraph.getEdgesTableName((String)config.getTableNamePrefix())) || tableName.equals(AccumuloGraph.getMetadataTableName((String)config.getTableNamePrefix())) || tableName.equals(AccumuloGraph.getDataTableName((String)config.getTableNamePrefix())) || tableName.equals(AccumuloGraph.getHistoryVerticesTableName((String)config.getTableNamePrefix())) || tableName.equals(AccumuloGraph.getHistoryEdgesTableName((String)config.getTableNamePrefix())) || tableName.equals(AccumuloGraph.getExtendedDataTableName((String)config.getTableNamePrefix()))) {
                    connector.tableOperations().setProperty(tableName, "table.cache.block.enable", "true");
                    connector.tableOperations().setProperty(tableName, "table.bloom.enabled", "true");
                }
            }
            if (hdfsContextClasspath != null) {
                connector.instanceOperations().setProperty("general.vfs.context.classpath.ge-" + tableName, hdfsContextClasspath);
                connector.tableOperations().setProperty(tableName, "table.classpath.context", "ge-" + tableName);
            }
        }
        catch (Exception e) {
            throw new GeException("Unable to create table " + tableName, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void ensureRowDeletingIteratorIsAttached(Connector connector, String tableName) {
        try {
            Object object = addIteratorLock;
            synchronized (object) {
                block8: {
                    IteratorSetting is = new IteratorSetting(7, ROW_DELETING_ITERATOR_NAME, RowDeletingIterator.class);
                    if (!connector.tableOperations().listIterators(tableName).containsKey(ROW_DELETING_ITERATOR_NAME)) {
                        try {
                            connector.tableOperations().attachIterator(tableName, is);
                        }
                        catch (Exception ex) {
                            int SLEEP_TIME = 5000;
                            LOGGER.warn("Failed to attach RowDeletingIterator. Retrying in %dms.", new Object[]{5000});
                            Thread.sleep(5000L);
                            if (connector.tableOperations().listIterators(tableName).containsKey(ROW_DELETING_ITERATOR_NAME)) break block8;
                            connector.tableOperations().attachIterator(tableName, is);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new GeException("Could not attach RowDeletingIterator", (Throwable)e);
        }
    }

    public static AccumuloGraph create(Map config) {
        return AccumuloGraph.create(new AccumuloGraphConfiguration(config));
    }

    protected void addMutations(GeObjectType objectType, StoreMutation ... mutations) {
        this._addMutations(this.getWriterFromElementType(objectType), mutations);
        if (this.isHistoryInSeparateTable() && objectType != GeObjectType.EXTENDED_DATA && objectType != GeObjectType.STREAMING_DATA) {
            this._addMutations(this.getHistoryWriterFromElementType(objectType), mutations);
        }
    }

    protected void _addMutations(BatchWriter writer, StoreMutation ... mutations) {
        try {
            for (StoreMutation mutation : mutations) {
                writer.addMutation(AccumuloGraph.toAccumuloMutation(mutation));
            }
            if (this.getConfiguration().isAutoFlush()) {
                this.flush();
            }
        }
        catch (MutationsRejectedException ex) {
            throw new GeException("Could not add mutation", (Throwable)ex);
        }
    }

    public static Mutation toAccumuloMutation(StoreMutation sm) {
        List updates = sm.getUpdates();
        Mutation m = new Mutation(sm.getRow());
        for (int i = 0; i < updates.size(); ++i) {
            StoreColumnUpdate update = (StoreColumnUpdate)updates.get(i);
            if (update.isDeleted()) {
                if (update.hasTimestamp()) {
                    m.putDelete(update.getColumnFamily(), update.getColumnQualifier(), new org.apache.accumulo.core.security.ColumnVisibility(update.getColumnVisibility()), update.getTimestamp());
                    continue;
                }
                m.putDelete(update.getColumnFamily(), update.getColumnQualifier(), new org.apache.accumulo.core.security.ColumnVisibility(update.getColumnVisibility()));
                continue;
            }
            if (update.hasTimestamp()) {
                m.put(update.getColumnFamily(), update.getColumnQualifier(), new org.apache.accumulo.core.security.ColumnVisibility(update.getColumnVisibility()), update.getTimestamp(), update.getValue());
                continue;
            }
            m.put(update.getColumnFamily(), update.getColumnQualifier(), new org.apache.accumulo.core.security.ColumnVisibility(update.getColumnVisibility()), update.getValue());
        }
        return m;
    }

    public BatchWriter getVerticesWriter() {
        return this.getWriterForTable(this.getVerticesTableName());
    }

    private BatchWriter getWriterForTable(String tableName) {
        try {
            return this.batchWriter.getBatchWriter(tableName);
        }
        catch (Exception e) {
            throw new GeException("Unable to get writer for table " + tableName, (Throwable)e);
        }
    }

    public BatchWriter getHistoryVerticesWriter() {
        return this.getWriterForTable(this.getHistoryVerticesTableName());
    }

    public BatchWriter getEdgesWriter() {
        return this.getWriterForTable(this.getEdgesTableName());
    }

    public BatchWriter getHistoryEdgesWriter() {
        return this.getWriterForTable(this.getHistoryEdgesTableName());
    }

    public BatchWriter getExtendedDataWriter() {
        return this.getWriterForTable(AccumuloGraph.getExtendedDataTableName());
    }

    public BatchWriter getDataWriter() {
        return this.getWriterForTable(this.getDataTableName());
    }

    public BatchWriter getWriterFromElementType(GeObjectType objectType) {
        switch (objectType) {
            case VERTEX: {
                return this.getVerticesWriter();
            }
            case EDGE: {
                return this.getEdgesWriter();
            }
            case EXTENDED_DATA: {
                return this.getExtendedDataWriter();
            }
            case STREAMING_DATA: {
                return this.getDataWriter();
            }
        }
        throw new GeException("Unexpected object type: " + objectType);
    }

    public BatchWriter getHistoryWriterFromElementType(GeObjectType objectType) {
        switch (objectType) {
            case VERTEX: {
                return this.getHistoryVerticesWriter();
            }
            case EDGE: {
                return this.getHistoryEdgesWriter();
            }
        }
        throw new GeException("Unexpected object type: " + objectType);
    }

    protected BatchWriter getMetadataWriter() {
        return this.getWriterForTable(this.getMetadataTableName());
    }

    public void logLargeRow(Key key, org.apache.accumulo.core.data.Value value) {
        if (value.getSize() > this.largeValueErrorThreshold || value.getSize() > this.largeValueWarningThreshold) {
            String message = String.format("large row detected (key: %s, size: %,d\n%s", key, value.getSize(), Arrays.stream(Thread.currentThread().getStackTrace()).map(StackTraceElement::toString).collect(Collectors.joining("\n  ")));
            if (value.getSize() > this.largeValueErrorThreshold) {
                LOGGER.error("%s", new Object[]{message});
            } else if (value.getSize() > this.largeValueWarningThreshold) {
                LOGGER.warn("%s", new Object[]{message});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<HistoricalPropertyValue> getHistoricalPropertyValues(Element element, String key, String name, Visibility visibility, Long startTime, Long endTime, Authorizations authorizations) {
        Span trace = Trace.start((String)"getHistoricalPropertyValues");
        if (Trace.isTracing()) {
            if (key != null) {
                trace.data("key", key);
            }
            if (name != null) {
                trace.data("name", name);
            }
            if (visibility != null) {
                trace.data("visibility", visibility.getVisibilityString());
            }
            if (startTime != null) {
                trace.data("startTime", Long.toString(startTime));
            }
            if (endTime != null) {
                trace.data("endTime", Long.toString(endTime));
            }
        }
        try {
            TreeSet treeSet;
            ElementType elementType = ElementType.getTypeFromElement((Element)element);
            FetchHints fetchHints = FetchHints.PROPERTIES_AND_METADATA;
            this.traceDataFetchHints(trace, fetchHints);
            Range range = RangeUtils.createRangeFromString(element.getId());
            ScannerBase scanner = this.createElementScanner(fetchHints, elementType, ALL_VERSIONS, startTime, endTime, Lists.newArrayList((Object[])new Range[]{range}), false, authorizations);
            try {
                String cq;
                HashMap<String, HistoricalPropertyValue> results = new HashMap<String, HistoricalPropertyValue>();
                ArrayListMultimap activeVisibilities = ArrayListMultimap.create();
                HashMap softDeleteObserved = Maps.newHashMap();
                HashMap lastPropertyEntryList = Maps.newHashMap();
                for (Map.Entry column : scanner) {
                    PropertyMetadataColumnQualifier propertyMetadataColumnQualifier;
                    HistoricalPropertyValue hpv;
                    String resultsKey;
                    PropertyColumnQualifier propertyColumnQualifier;
                    cq = ((Key)column.getKey()).getColumnQualifier().toString();
                    String columnVisibility = ((Key)column.getKey()).getColumnVisibility().toString();
                    if (((Key)column.getKey()).getColumnFamily().equals((Object)AccumuloElement.CF_PROPERTY)) {
                        if (visibility != null && !columnVisibility.equals(visibility.getVisibilityString())) continue;
                        propertyColumnQualifier = KeyHelper.createPropertyColumnQualifier(cq, this.getNameSubstitutionStrategy());
                        if (name != null && !propertyColumnQualifier.getPropertyName().equals(name) || key != null && !propertyColumnQualifier.getPropertyKey().equals(key)) continue;
                        resultsKey = propertyColumnQualifier.getDiscriminator(columnVisibility, ((Key)column.getKey()).getTimestamp());
                        long timestamp = ((Key)column.getKey()).getTimestamp();
                        Object value = this.geSerializer.bytesToObject(element, ((org.apache.accumulo.core.data.Value)column.getValue()).get());
                        Metadata metadata = Metadata.create();
                        Set hiddenVisibilities = null;
                        if (value instanceof StreamingPropertyValueRef) {
                            value = ((StreamingPropertyValueRef)value).toStreamingPropertyValue((Graph)this, Long.valueOf(timestamp));
                        }
                        String propertyKey = propertyColumnQualifier.getPropertyKey();
                        String propertyName = propertyColumnQualifier.getPropertyName();
                        Visibility propertyVisibility = AccumuloGraph.accumuloVisibilityToVisibility(columnVisibility);
                        HistoricalPropertyValue hpv2 = new HistoricalPropertyValue.HistoricalPropertyValueBuilder(propertyKey, propertyName, timestamp).propertyVisibility(propertyVisibility).value(value).metadata(metadata).hiddenVisibilities(hiddenVisibilities).build();
                        String propIdent = propertyKey + ":" + propertyName;
                        activeVisibilities.put((Object)propIdent, (Object)columnVisibility);
                        results.put(resultsKey, hpv2);
                        String lastPropKey = propertyColumnQualifier.getDiscriminator(columnVisibility);
                        if (lastPropertyEntryList.containsKey(lastPropKey)) {
                            long lastPropTimestamp = (Long)lastPropertyEntryList.get(lastPropKey);
                            if (timestamp <= lastPropTimestamp) continue;
                            lastPropertyEntryList.put(lastPropKey, timestamp);
                            continue;
                        }
                        lastPropertyEntryList.put(lastPropKey, timestamp);
                        continue;
                    }
                    if (((Key)column.getKey()).getColumnFamily().equals((Object)AccumuloElement.CF_PROPERTY_SOFT_DELETE)) {
                        propertyColumnQualifier = KeyHelper.createPropertyColumnQualifier(cq, this.getNameSubstitutionStrategy());
                        String propertyKey = propertyColumnQualifier.getPropertyKey();
                        String propertyName = propertyColumnQualifier.getPropertyName();
                        String propIdent = propertyKey + ":" + propertyName;
                        activeVisibilities.remove((Object)propIdent, (Object)columnVisibility);
                        softDeleteObserved.put(propIdent, column.getKey());
                        continue;
                    }
                    if (!((Key)column.getKey()).getColumnFamily().equals((Object)AccumuloElement.CF_PROPERTY_METADATA) || (hpv = (HistoricalPropertyValue)results.get(resultsKey = (propertyMetadataColumnQualifier = KeyHelper.createPropertyMetadataColumnQualifier(cq, this.getNameSubstitutionStrategy())).getPropertyDiscriminator(((Key)column.getKey()).getTimestamp()))) == null) continue;
                    Value value = (Value)this.geSerializer.bytesToObject(element, ((org.apache.accumulo.core.data.Value)column.getValue()).get());
                    Visibility metadataVisibility = AccumuloGraph.accumuloVisibilityToVisibility(columnVisibility);
                    hpv.getMetadata().add(propertyMetadataColumnQualifier.getMetadataKey(), value, metadataVisibility);
                }
                for (Key entry : softDeleteObserved.values()) {
                    cq = entry.getColumnQualifier().toString();
                    PropertyColumnQualifier propertyColumnQualifier = KeyHelper.createPropertyColumnQualifier(cq, this.getNameSubstitutionStrategy());
                    String propertyKey = propertyColumnQualifier.getPropertyKey();
                    String propertyName = propertyColumnQualifier.getPropertyName();
                    String propIdent = propertyKey + ":" + propertyName;
                    List active = activeVisibilities.get((Object)propIdent);
                    if (active != null && !active.isEmpty()) continue;
                    long timestamp = entry.getTimestamp() + 1L;
                    String columnVisibility = entry.getColumnVisibility().toString();
                    Visibility propertyVisibility = AccumuloGraph.accumuloVisibilityToVisibility(columnVisibility);
                    String lastPropertyEntryKey = propertyColumnQualifier.getDiscriminator(columnVisibility);
                    Long propertyTimestamp = (Long)lastPropertyEntryList.get(lastPropertyEntryKey);
                    if (propertyTimestamp == null) {
                        throw new GeException("Did not find last property entry timestamp: " + lastPropertyEntryKey);
                    }
                    String resultKey = propertyColumnQualifier.getDiscriminator(columnVisibility, propertyTimestamp.longValue());
                    HistoricalPropertyValue property = (HistoricalPropertyValue)results.get(resultKey);
                    if (property == null) {
                        throw new GeException("Did not find a matching historical property value for the last property entry timestamp: " + resultKey);
                    }
                    HistoricalPropertyValue hpv = new HistoricalPropertyValue.HistoricalPropertyValueBuilder(propertyKey, propertyName, timestamp).propertyVisibility(propertyVisibility).metadata(property.getMetadata()).value(property.getValue()).isDeleted(Boolean.valueOf(true)).build();
                    String resultsKey = propertyColumnQualifier.getDiscriminator(columnVisibility, timestamp);
                    results.put(resultsKey, hpv);
                }
                treeSet = new TreeSet(results.values());
            }
            catch (Throwable throwable) {
                scanner.close();
                throw throwable;
            }
            scanner.close();
            return treeSet;
        }
        finally {
            trace.stop();
        }
    }

    public Iterable<ExtendedDataRow> getExtendedDataForElements(Iterable<? extends ElementId> elementIdsArg, String tableName, FetchHints fetchHints, Authorizations authorizations) {
        try {
            return super.getExtendedDataForElements(elementIdsArg, tableName, fetchHints, authorizations);
        }
        catch (RuntimeException ex) {
            if (ex.getCause() instanceof AccumuloSecurityException) {
                throw new SecurityGeException("Could not get extended data " + Joiner.on((String)", ").join((Iterable)IterableUtils.toList(elementIdsArg)) + ":" + tableName + " with authorizations: " + authorizations, authorizations, ex.getCause());
            }
            throw ex;
        }
    }

    public void flushGraph() {
        AccumuloGraph.flushWriter(this.batchWriter);
    }

    public void flush() {
        this.flushTimer.time(() -> {
            if (this.hasEventListeners()) {
                Queue queue = this.graphEventQueue;
                synchronized (queue) {
                    this.flushWritersAndSuper();
                    this.flushGraphEventQueue();
                }
            } else {
                this.flushWritersAndSuper();
            }
        });
    }

    private void flushWritersAndSuper() {
        AccumuloGraph.flushWriter(this.batchWriter);
        super.flush();
    }

    private void flushGraphEventQueue() {
        GraphEvent graphEvent;
        while ((graphEvent = (GraphEvent)this.graphEventQueue.poll()) != null) {
            this.fireGraphEvent(graphEvent);
        }
    }

    private static void flushWriter(MultiTableBatchWriter writer) {
        if (writer == null) {
            return;
        }
        try {
            if (!writer.isClosed()) {
                writer.flush();
            }
        }
        catch (MutationsRejectedException e) {
            throw new GeException("Unable to flush writer", (Throwable)e);
        }
    }

    public AccumuloGraphConfiguration getConfiguration() {
        return (AccumuloGraphConfiguration)super.getConfiguration();
    }

    public Vertex getVertex(String vertexId, FetchHints fetchHints, Long endTime, Authorizations authorizations) throws GeException {
        try {
            return super.getVertex(vertexId, fetchHints, endTime, authorizations);
        }
        catch (RuntimeException ex) {
            if (ex.getCause() instanceof AccumuloSecurityException) {
                throw new SecurityGeException("Could not get vertex " + vertexId + " with authorizations: " + authorizations, authorizations, ex.getCause());
            }
            throw ex;
        }
    }

    public Iterable<String> getVertexIds(final Authorizations authorizations) {
        return new LookAheadIterable<Map.Entry<Key, org.apache.accumulo.core.data.Value>, String>(){
            public ScannerBase scanner;

            protected boolean isIncluded(Map.Entry<Key, org.apache.accumulo.core.data.Value> src, String dest) {
                return dest != null;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected String convert(Map.Entry<Key, org.apache.accumulo.core.data.Value> next) {
                try {
                    ByteArrayInputStream bain = new ByteArrayInputStream(next.getValue().get());
                    try (DataInputStream in = DataInputStreamUtils.decodeHeader(bain, (byte)1);){
                        String string = DataInputStreamUtils.decodeString(in);
                        return string;
                    }
                }
                catch (IOException ex) {
                    throw new GeException("Could not read vertex", (Throwable)ex);
                }
            }

            protected Iterator<Map.Entry<Key, org.apache.accumulo.core.data.Value>> createIterator() {
                try {
                    this.scanner = AccumuloGraph.this.createVertexScanner(FetchHints.NONE, (Integer)1, null, null, new Range(), authorizations);
                    return this.scanner.iterator();
                }
                catch (RuntimeException ex) {
                    if (ex.getCause() instanceof AccumuloSecurityException) {
                        throw new SecurityGeException("Could not get vertices with authorizations: " + authorizations, authorizations, ex.getCause());
                    }
                    throw ex;
                }
            }

            public void close() {
                super.close();
                if (this.scanner != null) {
                    this.scanner.close();
                }
            }
        };
    }

    protected ScannerBase createVertexScanner(FetchHints fetchHints, Integer maxVersions, Long startTime, Long endTime, Range range, Authorizations authorizations) throws GeException {
        return this.createElementScanner(fetchHints, ElementType.VERTEX, maxVersions, startTime, endTime, Lists.newArrayList((Object[])new Range[]{range}), authorizations);
    }

    protected ScannerBase createEdgeScanner(FetchHints fetchHints, Integer maxVersions, Long startTime, Long endTime, Range range, Authorizations authorizations) throws GeException {
        return this.createElementScanner(fetchHints, ElementType.EDGE, maxVersions, startTime, endTime, Lists.newArrayList((Object[])new Range[]{range}), authorizations);
    }

    private ScannerBase createElementScanner(FetchHints fetchHints, ElementType elementType, Integer maxVersions, Long startTime, Long endTime, Collection<Range> ranges, Authorizations authorizations) throws GeException {
        return this.createElementScanner(fetchHints, elementType, maxVersions, startTime, endTime, ranges, true, authorizations);
    }

    ScannerBase createElementScanner(FetchHints fetchHints, ElementType elementType, Integer maxVersions, Long startTime, Long endTime, Collection<Range> ranges, boolean useGeElementIterators, Authorizations authorizations) throws GeException {
        try {
            ScannerBase scanner;
            String tableName = this.isHistoryInSeparateTable() && (startTime != null || endTime != null || maxVersions == null || maxVersions > 1) ? this.getHistoryTableNameFromElementType(elementType) : this.getTableNameFromElementType(elementType);
            if (ranges == null || ranges.size() == 1) {
                Range range = ranges == null ? null : ranges.iterator().next();
                scanner = this.createScanner(tableName, range, authorizations);
            } else {
                scanner = this.createBatchScanner(tableName, ranges, authorizations);
            }
            if ((startTime != null || endTime != null) && this.getConfiguration().getMaxVersions() > 1) {
                IteratorSetting iteratorSetting = new IteratorSetting(80, TimestampFilter.class.getSimpleName(), TimestampFilter.class);
                if (startTime != null) {
                    TimestampFilter.setStart((IteratorSetting)iteratorSetting, (long)startTime, (boolean)true);
                }
                if (endTime != null) {
                    TimestampFilter.setEnd((IteratorSetting)iteratorSetting, (long)endTime, (boolean)true);
                }
                scanner.addScanIterator(iteratorSetting);
            }
            if (maxVersions != null) {
                IteratorSetting versioningIteratorSettings = new IteratorSetting(90, VersioningIterator.class.getSimpleName(), VersioningIterator.class);
                VersioningIterator.setMaxVersions((IteratorSetting)versioningIteratorSettings, (int)maxVersions);
                scanner.addScanIterator(versioningIteratorSettings);
            }
            if (useGeElementIterators) {
                if (elementType == ElementType.VERTEX) {
                    IteratorSetting vertexIteratorSettings = new IteratorSetting(1000, VertexIterator.class.getSimpleName(), VertexIterator.class);
                    VertexIterator.setFetchHints((IteratorSetting)vertexIteratorSettings, (IteratorFetchHints)this.toIteratorFetchHints(fetchHints));
                    VertexIterator.setCompressTransfer((IteratorSetting)vertexIteratorSettings, (boolean)this.compressIteratorTransfers);
                    scanner.addScanIterator(vertexIteratorSettings);
                } else if (elementType == ElementType.EDGE) {
                    IteratorSetting edgeIteratorSettings = new IteratorSetting(1000, EdgeIterator.class.getSimpleName(), EdgeIterator.class);
                    EdgeIterator.setFetchHints((IteratorSetting)edgeIteratorSettings, (IteratorFetchHints)this.toIteratorFetchHints(fetchHints));
                    EdgeIterator.setCompressTransfer((IteratorSetting)edgeIteratorSettings, (boolean)this.compressIteratorTransfers);
                    scanner.addScanIterator(edgeIteratorSettings);
                } else {
                    throw new GeException("Unexpected element type: " + elementType);
                }
            }
            this.applyFetchHints(scanner, fetchHints, elementType);
            GRAPH_LOGGER.logStartIterator(tableName, scanner);
            return scanner;
        }
        catch (TableNotFoundException e) {
            throw new GeException((Throwable)e);
        }
    }

    public IteratorFetchHints toIteratorFetchHints(FetchHints fetchHints) {
        return new IteratorFetchHints(fetchHints.isIncludeAllProperties(), this.deflateByteSequences((ImmutableSet<String>)fetchHints.getPropertyNamesToInclude()), fetchHints.isIncludeAllPropertyMetadata(), this.deflateByteSequences((ImmutableSet<String>)fetchHints.getMetadataKeysToInclude()), fetchHints.isIncludeHidden(), fetchHints.isIncludeAllEdgeRefs(), fetchHints.isIncludeOutEdgeRefs(), fetchHints.isIncludeInEdgeRefs(), fetchHints.isIncludeEdgeIds(), fetchHints.isIncludeEdgeVertexIds(), this.deflate((ImmutableSet<String>)fetchHints.getEdgeLabelsOfEdgeRefsToInclude()), fetchHints.isIncludeEdgeLabelsAndCounts(), fetchHints.isIncludeExtendedDataTableNames());
    }

    private ImmutableSet<ByteSequence> deflateByteSequences(ImmutableSet<String> strings) {
        if (strings == null) {
            return null;
        }
        return ImmutableSet.copyOf((Collection)strings.stream().map(s -> new ArrayByteSequence(this.getNameSubstitutionStrategy().deflate(s))).collect(Collectors.toSet()));
    }

    private ImmutableSet<String> deflate(ImmutableSet<String> strings) {
        if (strings == null) {
            return null;
        }
        return ImmutableSet.copyOf((Collection)strings.stream().map(s -> this.getNameSubstitutionStrategy().deflate(s)).collect(Collectors.toSet()));
    }

    protected ScannerBase createVertexScanner(FetchHints fetchHints, Integer maxVersions, Long startTime, Long endTime, Collection<Range> ranges, Authorizations authorizations) throws GeException {
        return this.createElementScanner(fetchHints, ElementType.VERTEX, maxVersions, startTime, endTime, ranges, authorizations);
    }

    protected ScannerBase createEdgeScanner(FetchHints fetchHints, Integer maxVersions, Long startTime, Long endTime, Collection<Range> ranges, Authorizations authorizations) throws GeException {
        return this.createElementScanner(fetchHints, ElementType.EDGE, maxVersions, startTime, endTime, ranges, authorizations);
    }

    public ScannerBase createBatchScanner(String tableName, Collection<Range> ranges, Authorizations authorizations) throws TableNotFoundException {
        org.apache.accumulo.core.security.Authorizations accumuloAuthorizations = AccumuloGraph.toAccumuloAuthorizations(authorizations);
        return this.createBatchScanner(tableName, ranges, accumuloAuthorizations);
    }

    public ScannerBase createBatchScanner(String tableName, Collection<Range> ranges, org.apache.accumulo.core.security.Authorizations accumuloAuthorizations) throws TableNotFoundException {
        GeTabletServerBatchReader scanner = new GeTabletServerBatchReader(this.connector, tableName, accumuloAuthorizations, this.numberOfQueryThreads);
        scanner.setRanges(ranges);
        return scanner;
    }

    public Scanner createScanner(String tableName, Range range, Authorizations authorizations) throws TableNotFoundException {
        org.apache.accumulo.core.security.Authorizations accumuloAuthorizations = AccumuloGraph.toAccumuloAuthorizations(authorizations);
        return this.createScanner(tableName, range, accumuloAuthorizations);
    }

    private Scanner createScanner(String tableName, Range range, org.apache.accumulo.core.security.Authorizations accumuloAuthorizations) throws TableNotFoundException {
        Scanner scanner = this.connector.createScanner(tableName, accumuloAuthorizations);
        if (range != null) {
            scanner.setRange(range);
        }
        return scanner;
    }

    private void applyFetchHints(ScannerBase scanner, FetchHints fetchHints, ElementType elementType) {
        scanner.clearColumns();
        Iterable<Text> columnFamiliesToFetch = AccumuloGraph.getColumnFamiliesToFetch(elementType, fetchHints);
        for (Text columnFamilyToFetch : columnFamiliesToFetch) {
            scanner.fetchColumnFamily(columnFamilyToFetch);
        }
    }

    public static Iterable<Text> getColumnFamiliesToFetch(ElementType elementType, FetchHints fetchHints) {
        ArrayList<Text> columnFamiliesToFetch = new ArrayList<Text>();
        columnFamiliesToFetch.add(AccumuloElement.CF_HIDDEN);
        columnFamiliesToFetch.add(AccumuloElement.CF_SOFT_DELETE);
        columnFamiliesToFetch.add(AccumuloElement.DELETE_ROW_COLUMN_FAMILY);
        if (elementType == ElementType.VERTEX) {
            columnFamiliesToFetch.add(new Text("V"));
        } else if (elementType == ElementType.EDGE) {
            columnFamiliesToFetch.add(new Text("E"));
            columnFamiliesToFetch.add(new Text("EIN"));
            columnFamiliesToFetch.add(new Text("EOUT"));
        } else {
            throw new GeException("Unhandled element type: " + elementType);
        }
        if (fetchHints.isIncludeAllEdgeRefs() || fetchHints.isIncludeInEdgeRefs() || fetchHints.isIncludeEdgeLabelsAndCounts() || fetchHints.hasEdgeLabelsOfEdgeRefsToInclude()) {
            columnFamiliesToFetch.add(new Text("EIN"));
            columnFamiliesToFetch.add(new Text("EINH"));
            columnFamiliesToFetch.add(new Text("EIND"));
        }
        if (fetchHints.isIncludeAllEdgeRefs() || fetchHints.isIncludeOutEdgeRefs() || fetchHints.isIncludeEdgeLabelsAndCounts() || fetchHints.hasEdgeLabelsOfEdgeRefsToInclude()) {
            columnFamiliesToFetch.add(new Text("EOUT"));
            columnFamiliesToFetch.add(new Text("EOUTH"));
            columnFamiliesToFetch.add(new Text("EOUTD"));
        }
        if (fetchHints.isIncludeProperties()) {
            columnFamiliesToFetch.add(AccumuloElement.CF_PROPERTY);
            columnFamiliesToFetch.add(AccumuloElement.CF_PROPERTY_HIDDEN);
            columnFamiliesToFetch.add(AccumuloElement.CF_PROPERTY_SOFT_DELETE);
        }
        if (fetchHints.isIncludePropertyMetadata()) {
            columnFamiliesToFetch.add(AccumuloElement.CF_PROPERTY_METADATA);
            columnFamiliesToFetch.add(AccumuloElement.CF_PROPERTY_HIDDEN);
            columnFamiliesToFetch.add(AccumuloElement.CF_PROPERTY_SOFT_DELETE);
        }
        if (fetchHints.isIncludeExtendedDataTableNames()) {
            columnFamiliesToFetch.add(AccumuloElement.CF_EXTENDED_DATA);
        }
        return columnFamiliesToFetch;
    }

    public static org.apache.accumulo.core.security.Authorizations toAccumuloAuthorizations(Authorizations authorizations) {
        if (authorizations == null) {
            throw new NullPointerException("authorizations is required");
        }
        return new org.apache.accumulo.core.security.Authorizations(authorizations.getAuthorizations());
    }

    public Edge getEdge(String edgeId, FetchHints fetchHints, Long endTime, Authorizations authorizations) {
        try {
            return super.getEdge(edgeId, fetchHints, endTime, authorizations);
        }
        catch (RuntimeException ex) {
            if (ex.getCause() instanceof AccumuloSecurityException) {
                throw new SecurityGeException("Could not get edge " + edgeId + " with authorizations: " + authorizations, authorizations, ex.getCause());
            }
            throw ex;
        }
    }

    public static ColumnVisibility visibilityToAccumuloVisibility(String visibilityString) {
        return new ColumnVisibility(visibilityString);
    }

    public static ColumnVisibility visibilityToAccumuloVisibility(ByteSequence visibilityBytes) {
        return new ColumnVisibility(ByteSequenceUtils.getBytes((ByteSequence)visibilityBytes));
    }

    public static Visibility accumuloVisibilityToVisibility(ColumnVisibility columnVisibility) {
        if (columnVisibility.equals(EMPTY_COLUMN_VISIBILITY)) {
            return Visibility.EMPTY;
        }
        String columnVisibilityString = columnVisibility.toString();
        return AccumuloGraph.accumuloVisibilityToVisibility(columnVisibilityString);
    }

    public static Visibility accumuloVisibilityToVisibility(Text columnVisibility) {
        return AccumuloGraph.accumuloVisibilityToVisibility(columnVisibility.toString());
    }

    public static Visibility accumuloVisibilityToVisibility(String columnVisibilityString) {
        if (columnVisibilityString.startsWith("[") && columnVisibilityString.endsWith("]")) {
            if (columnVisibilityString.length() == 2) {
                return Visibility.EMPTY;
            }
            columnVisibilityString = columnVisibilityString.substring(1, columnVisibilityString.length() - 1);
        }
        if (columnVisibilityString.length() == 0) {
            return Visibility.EMPTY;
        }
        return new Visibility(columnVisibilityString);
    }

    public AccumuloGraphLogger getGraphLogger() {
        return GRAPH_LOGGER;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public Iterable<IdRange> listVerticesTableSplits() {
        return this.listTableSplits(this.getVerticesTableName());
    }

    public Iterable<IdRange> listHistoryVerticesTableSplits() {
        return this.listTableSplits(this.getHistoryVerticesTableName());
    }

    public Iterable<IdRange> listEdgesTableSplits() {
        return this.listTableSplits(this.getEdgesTableName());
    }

    public Iterable<IdRange> listHistoryEdgesTableSplits() {
        return this.listTableSplits(this.getHistoryEdgesTableName());
    }

    public Iterable<IdRange> listDataTableSplits() {
        return this.listTableSplits(this.getDataTableName());
    }

    public Iterable<IdRange> listExtendedDataTableSplits() {
        return this.listTableSplits(AccumuloGraph.getExtendedDataTableName());
    }

    private Iterable<IdRange> listTableSplits(String tableName) {
        try {
            return this.splitsIterableToRangeIterable(this.getConnector().tableOperations().listSplits(tableName));
        }
        catch (Exception ex) {
            throw new GeException("Could not get splits for: " + tableName, (Throwable)ex);
        }
    }

    private Iterable<IdRange> splitsIterableToRangeIterable(Iterable<Text> splits) {
        String inclusiveStart = null;
        ArrayList<IdRange> ranges = new ArrayList<IdRange>();
        for (Text split : splits) {
            String exclusiveEnd = new Key(split).getRow().toString();
            ranges.add(new IdRange(inclusiveStart, exclusiveEnd));
            inclusiveStart = exclusiveEnd;
        }
        ranges.add(new IdRange(inclusiveStart, null));
        return ranges;
    }

    public void truncate() {
        try {
            this.connector.tableOperations().deleteRows(this.getDataTableName(), null, null);
            this.connector.tableOperations().deleteRows(this.getEdgesTableName(), null, null);
            this.connector.tableOperations().deleteRows(this.getVerticesTableName(), null, null);
            this.connector.tableOperations().deleteRows(AccumuloGraph.getExtendedDataTableName(), null, null);
            this.connector.tableOperations().deleteRows(this.getMetadataTableName(), null, null);
            if (this.isHistoryInSeparateTable()) {
                this.connector.tableOperations().deleteRows(this.getHistoryEdgesTableName(), null, null);
                this.connector.tableOperations().deleteRows(this.getHistoryVerticesTableName(), null, null);
            }
            this.getSearchIndex().truncate((Graph)this);
        }
        catch (Exception ex) {
            throw new GeException("Could not delete rows", (Throwable)ex);
        }
    }

    public void shutdown() {
        try {
            this.flush();
            super.shutdown();
            this.streamingPropertyValueStorageStrategy.close();
            this.graphMetadataStore.close();
            this.batchWriter.close();
        }
        catch (Exception ex) {
            throw new GeException((Throwable)ex);
        }
    }

    public void drop() {
        try {
            this.flush();
            this.graphMetadataStore.drop();
            this.streamingPropertyValueStorageStrategy.close();
            this.graphMetadataStore.close();
            this.batchWriter.close();
            this.dropTableIfExists(this.getDataTableName());
            this.dropTableIfExists(this.getEdgesTableName());
            this.dropTableIfExists(this.getVerticesTableName());
            this.dropTableIfExists(this.getMetadataTableName());
            this.dropTableIfExists(AccumuloGraph.getExtendedDataTableName());
            if (this.isHistoryInSeparateTable()) {
                this.dropTableIfExists(this.getHistoryEdgesTableName());
                this.dropTableIfExists(this.getHistoryVerticesTableName());
            }
            this.getSearchIndex().drop((Graph)this);
        }
        catch (Exception ex) {
            throw new GeException("Could not drop tables", (Throwable)ex);
        }
    }

    private void dropTableIfExists(String tableName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        if (this.connector.tableOperations().exists(tableName)) {
            this.connector.tableOperations().delete(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<String> findRelatedEdgeIds(Iterable<String> vertexIds, Long endTime, Authorizations authorizations) {
        Set vertexIdsSet = IterableUtils.toSet(vertexIds);
        Span trace = Trace.start((String)"findRelatedEdges");
        try {
            ArrayList<String> arrayList;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("findRelatedEdges:\n  %s", new Object[]{IterableUtils.join((Iterable)vertexIdsSet, (String)"\n  ")});
            }
            if (vertexIdsSet.size() == 0) {
                HashSet<String> hashSet = new HashSet<String>();
                return hashSet;
            }
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (String vertexId : vertexIdsSet) {
                ranges.add(RangeUtils.createRangeFromString(vertexId));
            }
            Long startTime = null;
            int maxVersions = 1;
            FetchHints fetchHints = FetchHints.builder().setIncludeOutEdgeRefs(true).build();
            ScannerBase scanner = this.createElementScanner(fetchHints, ElementType.VERTEX, maxVersions, startTime, endTime, ranges, false, authorizations);
            IteratorSetting edgeRefFilterSettings = new IteratorSetting(1000, EdgeRefFilter.class.getSimpleName(), EdgeRefFilter.class);
            EdgeRefFilter.setVertexIds((IteratorSetting)edgeRefFilterSettings, (Set)vertexIdsSet);
            scanner.addScanIterator(edgeRefFilterSettings);
            IteratorSetting vertexEdgeIdIteratorSettings = new IteratorSetting(1001, VertexEdgeIdIterator.class.getSimpleName(), VertexEdgeIdIterator.class);
            scanner.addScanIterator(vertexEdgeIdIteratorSettings);
            long timerStartTime = System.currentTimeMillis();
            try {
                Iterator it = scanner.iterator();
                ArrayList<String> edgeIds = new ArrayList<String>();
                while (it.hasNext()) {
                    Map.Entry c = (Map.Entry)it.next();
                    for (ByteArrayWrapper edgeId : VertexEdgeIdIterator.decodeValue((org.apache.accumulo.core.data.Value)((org.apache.accumulo.core.data.Value)c.getValue()))) {
                        edgeIds.add(new Text(edgeId.getData()).toString());
                    }
                }
                arrayList = edgeIds;
            }
            catch (Throwable throwable) {
                scanner.close();
                GRAPH_LOGGER.logEndIterator(System.currentTimeMillis() - timerStartTime);
                throw throwable;
            }
            scanner.close();
            GRAPH_LOGGER.logEndIterator(System.currentTimeMillis() - timerStartTime);
            return arrayList;
        }
        finally {
            trace.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<RelatedEdge> findRelatedEdgeSummary(Iterable<String> vertexIds, Long endTime, Authorizations authorizations) {
        Set vertexIdsSet = IterableUtils.toSet(vertexIds);
        Span trace = Trace.start((String)"findRelatedEdgeSummary");
        try {
            Iterable iterable;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("findRelatedEdgeSummary:\n  %s", new Object[]{IterableUtils.join((Iterable)vertexIdsSet, (String)"\n  ")});
            }
            if (vertexIdsSet.size() == 0) {
                ArrayList<RelatedEdge> arrayList = new ArrayList<RelatedEdge>();
                return arrayList;
            }
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (String vertexId : vertexIdsSet) {
                ranges.add(RangeUtils.createRangeFromString(vertexId));
            }
            Long startTime = null;
            int maxVersions = 1;
            FetchHints fetchHints = FetchHints.builder().setIncludeOutEdgeRefs(true).build();
            ScannerBase scanner = this.createElementScanner(fetchHints, ElementType.VERTEX, maxVersions, startTime, endTime, ranges, false, authorizations);
            IteratorSetting edgeRefFilterSettings = new IteratorSetting(1000, EdgeRefFilter.class.getSimpleName(), EdgeRefFilter.class);
            EdgeRefFilter.setVertexIds((IteratorSetting)edgeRefFilterSettings, (Set)vertexIdsSet);
            scanner.addScanIterator(edgeRefFilterSettings);
            long timerStartTime = System.currentTimeMillis();
            try {
                ArrayList<RelatedEdgeImpl> results = new ArrayList<RelatedEdgeImpl>();
                HashMap<String, Long> edgeAddTimestamps = new HashMap<String, Long>();
                HashMap<String, Long> edgeHideOrDeleteTimestamps = new HashMap<String, Long>();
                for (Map.Entry row : scanner) {
                    Text columnFamily = ((Key)row.getKey()).getColumnFamily();
                    Long timestamp = ((Key)row.getKey()).getTimestamp();
                    if (!columnFamily.equals((Object)new Text("EOUT"))) {
                        if (!columnFamily.equals((Object)new Text("EOUTD")) && !columnFamily.equals((Object)new Text("EOUTH"))) continue;
                        String edgeId = ((Key)row.getKey()).getColumnQualifier().toString();
                        edgeHideOrDeleteTimestamps.merge(edgeId, timestamp, Math::max);
                        continue;
                    }
                    StorableEdgeInfo edgeInfo = new StorableEdgeInfo(((org.apache.accumulo.core.data.Value)row.getValue()).get(), ((Key)row.getKey()).getTimestamp());
                    String edgeId = ((Key)row.getKey()).getColumnQualifier().toString();
                    String outVertexId = ((Key)row.getKey()).getRow().toString();
                    String inVertexId = edgeInfo.getVertexId();
                    String label = this.getNameSubstitutionStrategy().inflate(edgeInfo.getLabel());
                    edgeAddTimestamps.merge(edgeId, timestamp, Math::max);
                    results.add(new RelatedEdgeImpl(edgeId, label, outVertexId, inVertexId));
                }
                iterable = results.stream().filter(relatedEdge -> {
                    Long edgeAddedTime = (Long)edgeAddTimestamps.get(relatedEdge.getEdgeId());
                    Long edgeDeletedOrHiddenTime = (Long)edgeHideOrDeleteTimestamps.get(relatedEdge.getEdgeId());
                    return edgeDeletedOrHiddenTime == null || edgeAddedTime > edgeDeletedOrHiddenTime;
                }).collect(Collectors.toList());
            }
            catch (Throwable throwable) {
                scanner.close();
                GRAPH_LOGGER.logEndIterator(System.currentTimeMillis() - timerStartTime);
                throw throwable;
            }
            scanner.close();
            GRAPH_LOGGER.logEndIterator(System.currentTimeMillis() - timerStartTime);
            return iterable;
        }
        finally {
            trace.stop();
        }
    }

    public Iterable<Path> findPaths(FindPathOptions options, Authorizations authorizations) {
        ProgressCallback progressCallback = options.getProgressCallback();
        if (progressCallback == null) {
            progressCallback = new ProgressCallback(){

                public void progress(double progressPercent, ProgressCallback.Step step, Integer edgeIndex, Integer vertexCount) {
                    LOGGER.debug("findPaths progress %d%%: %s", new Object[]{(int)(progressPercent * 100.0), step.formatMessage(edgeIndex, vertexCount)});
                }
            };
        }
        return new AccumuloFindPathStrategy(this, options, progressCallback, authorizations).findPaths();
    }

    public Iterable<String> filterEdgeIdsByAuthorization(Iterable<String> edgeIds, String authorizationToMatch, EnumSet<ElementFilter> filters, Authorizations authorizations) {
        return this.filterElementIdsByAuthorization(ElementType.EDGE, edgeIds, authorizationToMatch, filters, authorizations);
    }

    public Iterable<String> filterVertexIdsByAuthorization(Iterable<String> vertexIds, String authorizationToMatch, EnumSet<ElementFilter> filters, Authorizations authorizations) {
        return this.filterElementIdsByAuthorization(ElementType.VERTEX, vertexIds, authorizationToMatch, filters, authorizations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<String> filterElementIdsByAuthorization(ElementType elementType, Iterable<String> elementIds, String authorizationToMatch, EnumSet<ElementFilter> filters, Authorizations authorizations) {
        Set elementIdsSet = IterableUtils.toSet(elementIds);
        Span trace = Trace.start((String)"filterElementIdsByAuthorization");
        try {
            HashSet<String> hashSet;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("filterElementIdsByAuthorization:\n  %s", new Object[]{IterableUtils.join((Iterable)elementIdsSet, (String)"\n  ")});
            }
            if (elementIdsSet.size() == 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                return arrayList;
            }
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (String elementId : elementIdsSet) {
                ranges.add(RangeUtils.createRangeFromString(elementId));
            }
            Long startTime = null;
            Long endTime = null;
            int maxVersions = 1;
            ScannerBase scanner = this.createElementScanner(FetchHints.ALL_INCLUDING_HIDDEN, elementType, maxVersions, startTime, endTime, ranges, false, authorizations);
            IteratorSetting hasAuthorizationFilterSettings = new IteratorSetting(1000, HasAuthorizationFilter.class.getSimpleName(), HasAuthorizationFilter.class);
            HasAuthorizationFilter.setAuthorizationToMatch((IteratorSetting)hasAuthorizationFilterSettings, (String)authorizationToMatch);
            HasAuthorizationFilter.setFilters((IteratorSetting)hasAuthorizationFilterSettings, filters);
            scanner.addScanIterator(hasAuthorizationFilterSettings);
            long timerStartTime = System.currentTimeMillis();
            try {
                HashSet<String> results = new HashSet<String>();
                for (Map.Entry row : scanner) {
                    results.add(((Key)row.getKey()).getRow().toString());
                }
                hashSet = results;
            }
            catch (Throwable throwable) {
                scanner.close();
                GRAPH_LOGGER.logEndIterator(System.currentTimeMillis() - timerStartTime);
                throw throwable;
            }
            scanner.close();
            GRAPH_LOGGER.logEndIterator(System.currentTimeMillis() - timerStartTime);
            return hashSet;
        }
        finally {
            trace.stop();
        }
    }

    protected CloseableIterable<ExtendedDataRow> getExtendedDataRowsInRange(final List<IdRange> ranges, final FetchHints fetchHints, final Authorizations authorizations) {
        final long timerStartTime = System.currentTimeMillis();
        return new LookAheadIterable<Map.Entry<Key, org.apache.accumulo.core.data.Value>, ExtendedDataRow>(){
            public ScannerBase scanner;

            protected boolean isIncluded(Map.Entry<Key, org.apache.accumulo.core.data.Value> src, ExtendedDataRow dest) {
                return dest != null;
            }

            protected ExtendedDataRow convert(Map.Entry<Key, org.apache.accumulo.core.data.Value> next) {
                try {
                    SortedMap row = WholeRowIterator.decodeRow((Key)next.getKey(), (org.apache.accumulo.core.data.Value)next.getValue());
                    ExtendedDataRowId extendedDataRowId = StorableKeyHelper.parseExtendedDataRowId((String)next.getKey().getRow().toString());
                    return AccumuloGraph.createExtendedDataRow(extendedDataRowId, row, fetchHints, AccumuloGraph.this.geSerializer);
                }
                catch (IOException e) {
                    throw new GeException("Could not decode row", (Throwable)e);
                }
            }

            protected Iterator<Map.Entry<Key, org.apache.accumulo.core.data.Value>> createIterator() {
                try {
                    this.scanner = AccumuloGraph.this.createExtendedDataRowScanner(ranges, authorizations);
                    return this.scanner.iterator();
                }
                catch (RuntimeException ex) {
                    if (ex.getCause() instanceof AccumuloSecurityException) {
                        throw new SecurityGeException("Could not get vertices with authorizations: " + authorizations, authorizations, ex.getCause());
                    }
                    throw ex;
                }
            }

            public void close() {
                super.close();
                this.scanner.close();
                GRAPH_LOGGER.logEndIterator(System.currentTimeMillis() - timerStartTime);
            }
        };
    }

    private ScannerBase createExtendedDataRowScanner(List<IdRange> geRanges, Authorizations authorizations) {
        try {
            ScannerBase scanner;
            String tableName = AccumuloGraph.getExtendedDataTableName();
            List<Range> ranges = geRanges.parallelStream().map(this::toAccumuloRange).collect(Collectors.toList());
            if (ranges.size() == 1) {
                Range range = (Range)ranges.iterator().next();
                scanner = this.createScanner(tableName, range, authorizations);
            } else {
                scanner = this.createBatchScanner(tableName, ranges, authorizations);
            }
            IteratorSetting versioningIteratorSettings = new IteratorSetting(90, VersioningIterator.class.getSimpleName(), VersioningIterator.class);
            VersioningIterator.setMaxVersions((IteratorSetting)versioningIteratorSettings, (int)1);
            scanner.addScanIterator(versioningIteratorSettings);
            IteratorSetting rowIteratorSettings = new IteratorSetting(100, WholeRowIterator.class.getSimpleName(), WholeRowIterator.class);
            scanner.addScanIterator(rowIteratorSettings);
            GRAPH_LOGGER.logStartIterator(tableName, scanner);
            return scanner;
        }
        catch (TableNotFoundException e) {
            throw new GeException((Throwable)e);
        }
    }

    public CloseableIterable<Vertex> getVerticesInRange(final IdRange range, final FetchHints fetchHints, final Long endTime, final Authorizations authorizations) {
        final long timerStartTime = System.currentTimeMillis();
        return new LookAheadIterable<Map.Entry<Key, org.apache.accumulo.core.data.Value>, Vertex>(){
            public ScannerBase scanner;

            protected boolean isIncluded(Map.Entry<Key, org.apache.accumulo.core.data.Value> src, Vertex dest) {
                return dest != null;
            }

            protected Vertex convert(Map.Entry<Key, org.apache.accumulo.core.data.Value> next) {
                return AccumuloGraph.createVertexFromIteratorValue((StorableGraph)AccumuloGraph.this, next.getKey(), next.getValue(), fetchHints, authorizations);
            }

            protected Iterator<Map.Entry<Key, org.apache.accumulo.core.data.Value>> createIterator() {
                try {
                    this.scanner = AccumuloGraph.this.createVertexScanner(fetchHints, (Integer)1, null, endTime, AccumuloGraph.this.toAccumuloRange(range), authorizations);
                    return this.scanner.iterator();
                }
                catch (RuntimeException ex) {
                    if (ex.getCause() instanceof AccumuloSecurityException) {
                        throw new SecurityGeException("Could not get vertices with authorizations: " + authorizations, authorizations, ex.getCause());
                    }
                    throw ex;
                }
            }

            public void close() {
                super.close();
                if (this.scanner != null) {
                    this.scanner.close();
                }
                GRAPH_LOGGER.logEndIterator(System.currentTimeMillis() - timerStartTime);
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Edge createEdgeFromEdgeIteratorValue(Key key, org.apache.accumulo.core.data.Value value, FetchHints fetchHints, Authorizations authorizations) {
        try {
            ByteArrayInputStream bain = new ByteArrayInputStream(value.get());
            try (DataInputStream in = DataInputStreamUtils.decodeHeader(bain, (byte)2);){
                String edgeId = DataInputStreamUtils.decodeString(in);
                long timestamp = in.readLong();
                Visibility vertexVisibility = new Visibility(DataInputStreamUtils.decodeString(in));
                Iterable hiddenVisibilities = Iterables.transform(DataInputStreamUtils.decodeStringSet(in), (Function)new Function<String, Visibility>(){

                    @Nullable
                    public Visibility apply(String input) {
                        return new Visibility(input);
                    }
                });
                List<MetadataEntry> metadataEntries = DataInputStreamUtils.decodeMetadataEntries(in);
                Iterable<Property> properties = DataInputStreamUtils.decodeProperties((StorableGraph)this, in, metadataEntries, fetchHints);
                ImmutableSet<String> extendedDataTableNames = DataInputStreamUtils.decodeStringSet(in);
                String inVertexId = DataInputStreamUtils.decodeString(in);
                String outVertexId = DataInputStreamUtils.decodeString(in);
                String label = this.getNameSubstitutionStrategy().inflate(DataInputStreamUtils.decodeString(in));
                StorableEdge storableEdge = new StorableEdge((StorableGraph)this, edgeId, outVertexId, inVertexId, label, null, vertexVisibility, properties, null, null, hiddenVisibilities, extendedDataTableNames, timestamp, fetchHints, authorizations);
                return storableEdge;
            }
        }
        catch (IOException ex) {
            throw new GeException("Could not read vertex", (Throwable)ex);
        }
    }

    public CloseableIterable<Vertex> getVertices(Iterable<String> ids, final FetchHints fetchHints, final Long endTime, final Authorizations authorizations) {
        final ArrayList<Range> ranges = new ArrayList<Range>();
        int idCount = 0;
        StringBuilder result = new StringBuilder();
        for (String id : ids) {
            if (idCount > 0) {
                result.append(",");
            }
            ranges.add(RangeUtils.createRangeFromString(id));
            ++idCount;
            result.append(id);
        }
        if (ranges.size() == 0) {
            return new EmptyClosableIterable();
        }
        final long timerStartTime = System.currentTimeMillis();
        return new LookAheadIterable<Map.Entry<Key, org.apache.accumulo.core.data.Value>, Vertex>(){
            public ScannerBase scanner;

            protected boolean isIncluded(Map.Entry<Key, org.apache.accumulo.core.data.Value> src, Vertex dest) {
                return dest != null;
            }

            protected Vertex convert(Map.Entry<Key, org.apache.accumulo.core.data.Value> row) {
                return AccumuloGraph.createVertexFromIteratorValue((StorableGraph)AccumuloGraph.this, row.getKey(), row.getValue(), fetchHints, authorizations);
            }

            protected Iterator<Map.Entry<Key, org.apache.accumulo.core.data.Value>> createIterator() {
                Long startTime = null;
                this.scanner = AccumuloGraph.this.createVertexScanner(fetchHints, (Integer)1, startTime, endTime, ranges, authorizations);
                return this.scanner.iterator();
            }

            public void close() {
                super.close();
                this.scanner.close();
                GRAPH_LOGGER.logEndIterator(System.currentTimeMillis() - timerStartTime);
            }
        };
    }

    public CloseableIterable<Edge> getEdges(Iterable<String> ids, final FetchHints fetchHints, final Long endTime, final Authorizations authorizations) {
        final ArrayList<Range> ranges = new ArrayList<Range>();
        int idCount = 0;
        for (String id : ids) {
            ranges.add(RangeUtils.createRangeFromString(id));
            ++idCount;
        }
        if (ranges.size() == 0) {
            return new EmptyClosableIterable();
        }
        final long timerStartTime = System.currentTimeMillis();
        return new LookAheadIterable<Map.Entry<Key, org.apache.accumulo.core.data.Value>, Edge>(){
            public ScannerBase scanner;

            protected boolean isIncluded(Map.Entry<Key, org.apache.accumulo.core.data.Value> src, Edge dest) {
                return dest != null;
            }

            protected Edge convert(Map.Entry<Key, org.apache.accumulo.core.data.Value> row) {
                return AccumuloGraph.this.createEdgeFromEdgeIteratorValue(row.getKey(), row.getValue(), fetchHints, authorizations);
            }

            protected Iterator<Map.Entry<Key, org.apache.accumulo.core.data.Value>> createIterator() {
                Long startTime = null;
                this.scanner = AccumuloGraph.this.createEdgeScanner(fetchHints, (Integer)1, startTime, endTime, ranges, authorizations);
                return this.scanner.iterator();
            }

            public void close() {
                super.close();
                this.scanner.close();
                GRAPH_LOGGER.logEndIterator(System.currentTimeMillis() - timerStartTime);
            }
        };
    }

    private Range toAccumuloRange(IdRange range) {
        if (range == null) {
            return null;
        }
        if (range.getPrefix() != null) {
            return Range.prefix((CharSequence)range.getPrefix());
        }
        return new Range((CharSequence)range.getStart(), range.isInclusiveStart(), (CharSequence)range.getEnd(), range.isInclusiveEnd());
    }

    public CloseableIterable<Edge> getEdgesInRange(final IdRange idRange, final FetchHints fetchHints, final Long endTime, final Authorizations authorizations) {
        final long timerStartTime = System.currentTimeMillis();
        return new LookAheadIterable<Map.Entry<Key, org.apache.accumulo.core.data.Value>, Edge>(){
            public ScannerBase scanner;

            protected boolean isIncluded(Map.Entry<Key, org.apache.accumulo.core.data.Value> src, Edge dest) {
                return dest != null;
            }

            protected Edge convert(Map.Entry<Key, org.apache.accumulo.core.data.Value> next) {
                return AccumuloGraph.this.createEdgeFromEdgeIteratorValue(next.getKey(), next.getValue(), fetchHints, authorizations);
            }

            protected Iterator<Map.Entry<Key, org.apache.accumulo.core.data.Value>> createIterator() {
                this.scanner = AccumuloGraph.this.createEdgeScanner(fetchHints, (Integer)1, null, endTime, AccumuloGraph.this.toAccumuloRange(idRange), authorizations);
                return this.scanner.iterator();
            }

            public void close() {
                super.close();
                this.scanner.close();
                GRAPH_LOGGER.logEndIterator(System.currentTimeMillis() - timerStartTime);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getRowCountFromTable(String tableName, String signalColumn, Authorizations authorizations) {
        long l;
        LOGGER.debug("BEGIN getRowCountFromTable(%s)", new Object[]{tableName});
        Scanner scanner = this.createScanner(tableName, null, authorizations);
        try {
            scanner.fetchColumnFamily(new Text(signalColumn));
            IteratorSetting countingIterator = new IteratorSetting(100, CountingIterator.class.getSimpleName(), CountingIterator.class);
            scanner.addScanIterator(countingIterator);
            GRAPH_LOGGER.logStartIterator(tableName, (ScannerBase)scanner);
            long count = 0L;
            for (Map.Entry entry : scanner) {
                Long countForKey = (Long)LongCombiner.FIXED_LEN_ENCODER.decode(((org.apache.accumulo.core.data.Value)entry.getValue()).get());
                LOGGER.debug("getRowCountFromTable(%s): %s: %d", new Object[]{tableName, ((Key)entry.getKey()).getRow(), countForKey});
                count += countForKey.longValue();
            }
            LOGGER.debug("getRowCountFromTable(%s): TOTAL: %d", new Object[]{tableName, count});
            l = count;
        }
        catch (Throwable throwable) {
            try {
                scanner.close();
                throw throwable;
            }
            catch (TableNotFoundException ex) {
                throw new GeException("Could not get count from table: " + tableName, (Throwable)ex);
            }
        }
        scanner.close();
        return l;
    }

    public void traceOn(String description) {
        this.traceOn(description, new HashMap<String, String>());
    }

    public void traceOn(String description, Map<String, String> data) {
        if (!this.distributedTraceEnabled) {
            try {
                ClientConfiguration conf = this.getConfiguration().getClientConfiguration();
                DistributedTrace.enable(null, (String)AccumuloGraph.class.getSimpleName(), (ClientConfiguration)conf);
                this.distributedTraceEnabled = true;
            }
            catch (Exception e) {
                throw new GeException("Could not enable DistributedTrace", (Throwable)e);
            }
        }
        if (Trace.isTracing()) {
            throw new GeException("Trace already running");
        }
        Span span = Trace.on((String)description);
        for (Map.Entry<String, String> dataEntry : data.entrySet()) {
            span.data(dataEntry.getKey(), dataEntry.getValue());
        }
        LOGGER.info("Started trace '%s'", new Object[]{description});
    }

    public void traceOff() {
        if (!Trace.isTracing()) {
            throw new GeException("No trace currently running");
        }
        Trace.off();
    }

    private void traceDataFetchHints(Span trace, FetchHints fetchHints) {
        if (Trace.isTracing()) {
            trace.data("fetchHints", fetchHints.toString());
        }
    }

    protected Class<? extends Value> getValueType(Value value) {
        if (value instanceof StreamingPropertyValueTableRef) {
            return ((StreamingPropertyValueTableRef)value).getValueType();
        }
        return super.getValueType(value);
    }

    private String getHadoopFS() {
        return this.getConfiguration().getString("hdfs.rootDir", "");
    }

    private String getHadoopUser() {
        return this.getConfiguration().getString("hdfs.user", "hdfs");
    }

    public String getBackupDir() {
        return this.getConfiguration().getString("hdfs.backupDir", "");
    }

    public GraphBackup getBackupTool(String outputFile) {
        return new HDFSGraphBackup(this.getHadoopFS(), this.getBackupDir(), true, this.getHadoopUser(), outputFile);
    }

    public GraphRestore getRestoreTool() {
        return new HDFSGraphRestore(this.getHadoopFS(), this.getBackupDir(), true, this.getHadoopUser());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Vertex createVertexFromIteratorValue(StorableGraph graph, Key key, org.apache.accumulo.core.data.Value value, FetchHints fetchHints, Authorizations authorizations) {
        try {
            ByteArrayInputStream bain = new ByteArrayInputStream(value.get());
            try (DataInputStream in = DataInputStreamUtils.decodeHeader(bain, (byte)1);){
                String vertexId = DataInputStreamUtils.decodeString(in);
                long timestamp = in.readLong();
                Visibility vertexVisibility = new Visibility(DataInputStreamUtils.decodeString(in));
                ImmutableSet<String> hiddenVisibilityStrings = DataInputStreamUtils.decodeStringSet(in);
                Set hiddenVisibilities = hiddenVisibilityStrings != null ? hiddenVisibilityStrings.stream().map(Visibility::new).collect(Collectors.toSet()) : null;
                List<MetadataEntry> metadataEntries = DataInputStreamUtils.decodeMetadataEntries(in);
                Iterable<Property> properties = DataInputStreamUtils.decodeProperties(graph, in, metadataEntries, fetchHints);
                ImmutableSet<String> extendedDataTableNames = DataInputStreamUtils.decodeStringSet(in);
                Edges outEdges = DataInputStreamUtils.decodeEdges(in, graph.getNameSubstitutionStrategy(), fetchHints);
                Edges inEdges = DataInputStreamUtils.decodeEdges(in, graph.getNameSubstitutionStrategy(), fetchHints);
                String conceptType = graph.getNameSubstitutionStrategy().inflate(DataInputStreamUtils.decodeString(in));
                StorableVertex storableVertex = new StorableVertex(graph, vertexId, conceptType, null, vertexVisibility, properties, null, null, hiddenVisibilities, extendedDataTableNames, inEdges, outEdges, timestamp, fetchHints, authorizations);
                return storableVertex;
            }
        }
        catch (IOException ex) {
            throw new GeException("Could not read vertex", (Throwable)ex);
        }
    }

    public static StorableExtendedDataRow createExtendedDataRow(ExtendedDataRowId rowId, SortedMap<Key, org.apache.accumulo.core.data.Value> row, FetchHints fetchHints, GeSerializer geSerializer) {
        HashSet<StorableExtendedDataRow.StorableExtendedDataRowProperty> properties = new HashSet<StorableExtendedDataRow.StorableExtendedDataRowProperty>();
        ArrayList<Map.Entry<Key, org.apache.accumulo.core.data.Value>> entries = new ArrayList<Map.Entry<Key, org.apache.accumulo.core.data.Value>>(row.entrySet());
        entries.sort(Comparator.comparingLong(o -> ((Key)o.getKey()).getTimestamp()));
        for (Map.Entry entry : entries) {
            Text columnFamily = ((Key)entry.getKey()).getColumnFamily();
            if (columnFamily.equals((Object)AccumuloElement.CF_EXTENDED_DATA)) {
                String[] columnQualifierParts = KeyBase.splitOnValueSeparator((String)((Key)entry.getKey()).getColumnQualifier().toString());
                if (columnQualifierParts.length != 1 && columnQualifierParts.length != 2) {
                    throw new GeException("Invalid column qualifier for extended data row: " + rowId + " (expected 1 or 2 parts, found " + columnQualifierParts.length + ")");
                }
                String propertyName = columnQualifierParts[0];
                String propertyKey = columnQualifierParts.length > 1 ? columnQualifierParts[1] : null;
                Value propertyValue = (Value)geSerializer.bytesToObject(rowId, ((org.apache.accumulo.core.data.Value)entry.getValue()).get());
                long timestamp = ((Key)entry.getKey()).getTimestamp();
                Visibility visibility = AccumuloGraph.accumuloVisibilityToVisibility(((Key)entry.getKey()).getColumnVisibility());
                StorableExtendedDataRow.StorableExtendedDataRowProperty prop = new StorableExtendedDataRow.StorableExtendedDataRowProperty(propertyName, propertyKey, propertyValue, fetchHints, timestamp, visibility);
                properties.add(prop);
                continue;
            }
            throw new GeException("unhandled column family: " + columnFamily);
        }
        return new StorableExtendedDataRow(rowId, properties, fetchHints);
    }
}

