/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.trace;

import com.google.inject.Inject;
import com.mware.core.exception.BcException;
import com.mware.core.trace.TraceRepository;
import com.mware.core.trace.TraceSpan;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.ge.GeException;
import com.mware.ge.Graph;
import com.mware.ge.accumulo.AccumuloGraph;
import java.util.Map;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.trace.DistributedTrace;
import org.apache.accumulo.core.trace.Span;
import org.apache.accumulo.core.trace.Trace;

public class AccumuloTraceRepository
extends TraceRepository {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(AccumuloTraceRepository.class);
    private static boolean distributedTraceEnabled;
    private final AccumuloGraph accumuloGraph;

    @Inject
    public AccumuloTraceRepository(Graph graph) {
        if (!(graph instanceof AccumuloGraph)) {
            throw new BcException("You cannot use the " + AccumuloTraceRepository.class.getName() + " unless you are using " + AccumuloGraph.class.getName());
        }
        this.accumuloGraph = (AccumuloGraph)graph;
    }

    public void enable() {
        if (!distributedTraceEnabled) {
            try {
                DistributedTrace.enable(null, (String)"bigCONNECT", (ClientConfiguration)this.accumuloGraph.getConfiguration().getClientConfiguration());
                this.accumuloGraph.traceOn("bigCONNECT");
                distributedTraceEnabled = true;
            }
            catch (Exception e) {
                throw new GeException("Could not enable DistributedTrace", (Throwable)e);
            }
        }
    }

    public TraceSpan on(String description, Map<String, String> data) {
        this.enable();
        if (Trace.isTracing()) {
            throw new GeException("Trace already running");
        }
        Span span = Trace.on((String)description);
        for (Map.Entry<String, String> dataEntry : data.entrySet()) {
            span.data(dataEntry.getKey(), dataEntry.getValue());
        }
        LOGGER.info("Started trace '%s'", new Object[]{description});
        return this.wrapSpan(span);
    }

    public void off() {
        Trace.off();
    }

    public TraceSpan start(String description) {
        Span span = Trace.start((String)description);
        return this.wrapSpan(span);
    }

    private TraceSpan wrapSpan(final Span span) {
        return new TraceSpan(){

            public TraceSpan data(String key, String value) {
                span.data(key, value);
                return this;
            }

            public void close() {
                span.stop();
            }
        };
    }

    public boolean isEnabled() {
        return Trace.isTracing();
    }
}

