/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.accumulo;

import com.mware.ge.GeException;
import com.mware.ge.accumulo.AccumuloGraph;
import com.mware.ge.accumulo.AccumuloGraphConfiguration;
import com.mware.ge.accumulo.util.DataInDataTableStreamingPropertyValueStorageStrategy;
import com.mware.ge.util.GeLogger;
import com.mware.ge.util.GeLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.minicluster.MemoryUnit;
import org.apache.accumulo.minicluster.MiniAccumuloCluster;
import org.apache.accumulo.minicluster.MiniAccumuloConfig;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.commons.lang3.StringUtils;
import org.junit.rules.ExternalResource;

public class AccumuloResource
extends ExternalResource {
    private static final GeLogger LOGGER = GeLoggerFactory.getLogger(AccumuloResource.class);
    private static final String ACCUMULO_USERNAME = "root";
    private static final String ACCUMULO_PASSWORD = "test";
    private File tempDir;
    private MiniAccumuloCluster accumulo;
    private Map extraConfig = null;
    private String instanceName = null;
    static Connector connector;

    public AccumuloResource() {
    }

    public AccumuloResource(Map extraConfig) {
        this.extraConfig = extraConfig;
    }

    public AccumuloResource(String instanceName, Map extraConfig) {
        this.instanceName = instanceName;
        this.extraConfig = extraConfig;
    }

    protected void before() throws Throwable {
        this.ensureAccumuloIsStarted();
        super.before();
    }

    protected void after() {
        try {
            this.stop();
        }
        catch (Exception e) {
            LOGGER.info("Unable to shut down mini accumulo cluster", (Throwable)e);
        }
        super.after();
    }

    public void resetAutorizations() throws Exception {
        Connector connector = this.getConnector();
        connector.securityOperations().changeUserAuthorizations(ACCUMULO_USERNAME, new Authorizations(new String[]{"a", "b", "c", "MIXED_CASE_a"}));
    }

    public void addAuthorizations(AccumuloGraph graph, String ... authorizations) {
        try {
            String principal = graph.getConnector().whoami();
            Authorizations currentAuthorizations = graph.getConnector().securityOperations().getUserAuthorizations(principal);
            ArrayList<byte[]> newAuthorizationsArray = new ArrayList<byte[]>();
            for (byte[] currentAuth : currentAuthorizations) {
                newAuthorizationsArray.add(currentAuth);
            }
            for (String authorization : authorizations) {
                if (currentAuthorizations.contains(authorization)) continue;
                newAuthorizationsArray.add(authorization.getBytes(StandardCharsets.UTF_8));
            }
            Authorizations newAuthorizations = new Authorizations(newAuthorizationsArray);
            graph.getConnector().securityOperations().changeUserAuthorizations(principal, newAuthorizations);
        }
        catch (Exception ex) {
            throw new GeException("could not add authorizations", (Throwable)ex);
        }
    }

    public MiniAccumuloCluster getAccumulo() {
        return this.accumulo;
    }

    public Map createConfig() {
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        if (this.shouldUseRemoteAccumulo()) {
            configMap.put("zookeeperServers", System.getProperty("REMOTE_ACC_ZOOKEEPERS"));
            configMap.put("accumuloInstanceName", System.getProperty("REMOTE_ACC_INSTANCE", "accumulo"));
            configMap.put("password", System.getProperty("REMOTE_ACC_PASSWORD", ACCUMULO_PASSWORD));
        } else {
            configMap.put("zookeeperServers", this.accumulo.getZooKeepers());
            configMap.put("accumuloInstanceName", this.accumulo.getInstanceName());
            configMap.put("password", ACCUMULO_PASSWORD);
        }
        configMap.put("username", ACCUMULO_USERNAME);
        configMap.put("autoFlush", false);
        configMap.put("maxStreamingPropertyValueTableDataSize", 0x100000);
        configMap.put("hdfs.dataDir", "/tmp/");
        configMap.put("maxVersions", 1);
        configMap.put("historyInSeparateTable", false);
        configMap.put("compressIteratorTransfers", false);
        configMap.put("streamingPropertyValueStorageStrategy", DataInDataTableStreamingPropertyValueStorageStrategy.class.getName());
        if (this.extraConfig != null) {
            configMap.putAll(this.extraConfig);
        }
        return configMap;
    }

    public Connector createConnector() throws AccumuloSecurityException, AccumuloException {
        return new AccumuloGraphConfiguration(this.createConfig()).createConnector();
    }

    public void ensureAccumuloIsStarted() {
        if (this.shouldUseRemoteAccumulo()) {
            return;
        }
        try {
            this.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start Accumulo mini cluster", e);
        }
    }

    public void stop() throws IOException, InterruptedException {
        if (this.shouldUseRemoteAccumulo()) {
            return;
        }
        if (this.accumulo != null) {
            LOGGER.info("Stopping accumulo", new Object[0]);
            this.accumulo.stop();
            this.accumulo = null;
        }
        this.tempDir.delete();
    }

    public void start() throws IOException, InterruptedException {
        if (this.shouldUseRemoteAccumulo()) {
            return;
        }
        if (this.accumulo != null) {
            return;
        }
        LOGGER.info("Starting accumulo", new Object[0]);
        this.tempDir = File.createTempFile("accumulo-temp", Long.toString(System.nanoTime()));
        this.tempDir.delete();
        this.tempDir.mkdir();
        LOGGER.info("writing to: %s", new Object[]{this.tempDir});
        MiniAccumuloConfig miniAccumuloConfig = new MiniAccumuloConfig(this.tempDir, ACCUMULO_PASSWORD);
        miniAccumuloConfig.setMemory(ServerType.TABLET_SERVER, 2L, MemoryUnit.GIGABYTE);
        miniAccumuloConfig.setNumTservers(1);
        miniAccumuloConfig.setJDWPEnabled(true);
        miniAccumuloConfig.setZooKeeperStartupTime(60000L);
        if (this.instanceName != null) {
            miniAccumuloConfig.setInstanceName(this.instanceName);
        }
        this.accumulo = new MiniAccumuloCluster(miniAccumuloConfig);
        this.accumulo.start();
        this.accumulo.getDebugPorts().forEach(serverTypeIntegerPair -> LOGGER.info("##### Debug port: " + ((ServerType)serverTypeIntegerPair.getFirst()).prettyPrint() + "=" + serverTypeIntegerPair.getSecond(), new Object[0]));
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    AccumuloResource.this.stop();
                }
                catch (Exception e) {
                    System.out.println("Failed to stop Accumulo test cluster");
                }
            }
        });
    }

    private boolean shouldUseRemoteAccumulo() {
        return StringUtils.isNotEmpty((CharSequence)this.getRemoteZookeepers());
    }

    private String getRemoteZookeepers() {
        return System.getProperty("REMOTE_ACC_ZOOKEEPERS");
    }

    Connector getConnector() throws Exception {
        if (connector == null) {
            connector = this.createConnector();
        }
        return connector;
    }
}

