/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.accumulo;

import com.mware.ge.FetchHints;
import com.mware.ge.Metadata;
import com.mware.ge.Vertex;
import com.mware.ge.accumulo.AccumuloElement;
import com.mware.ge.accumulo.AccumuloGraph;
import com.mware.ge.accumulo.AccumuloGraphFactory;
import com.mware.ge.accumulo.AccumuloResource;
import com.mware.ge.base.GraphMetadataTests;
import com.mware.ge.base.GraphTestSetup;
import com.mware.ge.base.TestGraphFactory;
import com.mware.ge.util.GeLogger;
import com.mware.ge.util.GeLoggerFactory;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.Values;
import java.util.Iterator;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.accumulo.core.client.RowIterator;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class AccumuloMetadataTests
extends GraphMetadataTests
implements GraphTestSetup {
    private static final GeLogger LOGGER = GeLoggerFactory.getLogger(AccumuloMetadataTests.class);
    @ClassRule
    public static AccumuloResource accumuloResource = new AccumuloResource();

    @Before
    public void before() throws Exception {
        accumuloResource.resetAutorizations();
        super.before();
    }

    @Test
    public void testStoringEmptyMetadata() {
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_EMPTY, AUTHORIZATIONS_EMPTY, "thing");
        Metadata metadata = Metadata.create();
        v1.addPropertyValue("prop1", "prop1", (Value)Values.stringValue((String)"val1"), metadata, VISIBILITY_EMPTY, AUTHORIZATIONS_A_AND_B);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_EMPTY, AUTHORIZATIONS_EMPTY, "thing");
        metadata = Metadata.create();
        metadata.add("meta1", (Value)Values.stringValue((String)"metavalue1"), VISIBILITY_EMPTY);
        v2.addPropertyValue("prop1", "prop1", (Value)Values.stringValue((String)"val1"), metadata, VISIBILITY_EMPTY, AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        v1 = this.graph.getVertex("v1", FetchHints.ALL, AUTHORIZATIONS_EMPTY);
        Assert.assertEquals((long)0L, (long)v1.getProperty("prop1", "prop1").getMetadata().entrySet().size());
        v2 = this.graph.getVertex("v2", FetchHints.ALL, AUTHORIZATIONS_EMPTY);
        metadata = v2.getProperty("prop1", "prop1").getMetadata();
        Assert.assertEquals((long)1L, (long)metadata.entrySet().size());
        Assert.assertEquals((Object)Values.stringValue((String)"metavalue1"), (Object)metadata.getEntry("meta1", VISIBILITY_EMPTY).getValue());
        AccumuloGraph accumuloGraph = (AccumuloGraph)this.graph;
        ScannerBase vertexScanner = accumuloGraph.createVertexScanner(this.graph.getDefaultFetchHints(), Integer.valueOf(1), null, null, new Range((CharSequence)"V", (CharSequence)"W"), AUTHORIZATIONS_EMPTY);
        RowIterator rows = new RowIterator(vertexScanner.iterator());
        while (rows.hasNext()) {
            Iterator row = rows.next();
            while (row.hasNext()) {
                Map.Entry col = (Map.Entry)row.next();
                if (!((Key)col.getKey()).getColumnFamily().equals((Object)AccumuloElement.CF_PROPERTY_METADATA)) continue;
                if (((Key)col.getKey()).getRow().toString().equals("Vv1")) {
                    Assert.assertEquals((Object)"", (Object)((org.apache.accumulo.core.data.Value)col.getValue()).toString());
                    continue;
                }
                if (((Key)col.getKey()).getRow().toString().equals("Vv2")) {
                    Assert.assertNotEquals((Object)"", (Object)((org.apache.accumulo.core.data.Value)col.getValue()).toString());
                    continue;
                }
                TestCase.fail((String)"invalid vertex");
            }
        }
    }

    public void addAuthorizations(String ... authorizations) {
        accumuloResource.addAuthorizations((AccumuloGraph)this.getGraph(), authorizations);
    }

    public TestGraphFactory graphFactory() {
        return new AccumuloGraphFactory().withAccumuloResource(accumuloResource);
    }
}

