/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.accumulo;

import com.google.common.collect.Maps;
import com.mware.ge.accumulo.AccumuloGraphConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.commons.collections.MapUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class AccumuloGraphConfigurationTest {
    @Test
    public void testBatchWriterConfigUsesDefaultWithNoParameters() {
        HashMap configMap = Maps.newHashMap();
        AccumuloGraphConfiguration accumuloGraphConfiguration = new AccumuloGraphConfiguration((Map)configMap);
        BatchWriterConfig batchWriterConfig = accumuloGraphConfiguration.createBatchWriterConfig();
        MatcherAssert.assertThat((Object)batchWriterConfig.getMaxLatency(TimeUnit.MILLISECONDS), (Matcher)CoreMatchers.is((Object)AccumuloGraphConfiguration.DEFAULT_BATCHWRITER_MAX_LATENCY));
        MatcherAssert.assertThat((Object)batchWriterConfig.getTimeout(TimeUnit.MILLISECONDS), (Matcher)CoreMatchers.is((Object)AccumuloGraphConfiguration.DEFAULT_BATCHWRITER_TIMEOUT));
        MatcherAssert.assertThat((Object)batchWriterConfig.getMaxMemory(), (Matcher)CoreMatchers.is((Object)AccumuloGraphConfiguration.DEFAULT_BATCHWRITER_MAX_MEMORY));
        MatcherAssert.assertThat((Object)batchWriterConfig.getMaxWriteThreads(), (Matcher)CoreMatchers.is((Object)AccumuloGraphConfiguration.DEFAULT_BATCHWRITER_MAX_WRITE_THREADS));
    }

    @Test
    public void testBatchWriterConfigIsSetToValuesWithParameters() {
        int numThreads = 2;
        long timeout = 3L;
        long maxMemory = 5L;
        long maxLatency = 7L;
        HashMap configMap = Maps.newHashMap();
        MapUtils.putAll((Map)configMap, (Object[])new String[]{"batchwriter.maxLatency", "" + maxLatency, "batchwriter.maxMemory", "" + maxMemory, "batchwriter.maxWriteThreads", "" + numThreads, "batchwriter.timeout", "" + timeout});
        AccumuloGraphConfiguration accumuloGraphConfiguration = new AccumuloGraphConfiguration((Map)configMap);
        BatchWriterConfig batchWriterConfig = accumuloGraphConfiguration.createBatchWriterConfig();
        MatcherAssert.assertThat((Object)batchWriterConfig.getMaxLatency(TimeUnit.MILLISECONDS), (Matcher)CoreMatchers.is((Object)maxLatency));
        MatcherAssert.assertThat((Object)batchWriterConfig.getTimeout(TimeUnit.MILLISECONDS), (Matcher)CoreMatchers.is((Object)timeout));
        MatcherAssert.assertThat((Object)batchWriterConfig.getMaxMemory(), (Matcher)CoreMatchers.is((Object)maxMemory));
        MatcherAssert.assertThat((Object)batchWriterConfig.getMaxWriteThreads(), (Matcher)CoreMatchers.is((Object)numThreads));
    }
}

