/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.accumulo;

import com.mware.ge.Authorizations;
import com.mware.ge.GeException;
import com.mware.ge.Graph;
import com.mware.ge.IdRange;
import com.mware.ge.PropertyDefinition;
import com.mware.ge.TextIndexHint;
import com.mware.ge.accumulo.AccumuloGraph;
import com.mware.ge.accumulo.AccumuloGraphConfiguration;
import com.mware.ge.accumulo.AccumuloGraphFactory;
import com.mware.ge.accumulo.AccumuloResource;
import com.mware.ge.base.GraphBaseTests;
import com.mware.ge.base.GraphTestSetup;
import com.mware.ge.base.TestGraphFactory;
import com.mware.ge.util.GeLogger;
import com.mware.ge.util.GeLoggerFactory;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.values.storable.TextValue;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.Values;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.commons.lang.time.StopWatch;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class AccumuloBaseTests
extends GraphBaseTests
implements GraphTestSetup {
    private static final GeLogger LOGGER = GeLoggerFactory.getLogger(AccumuloBaseTests.class);
    @ClassRule
    public static AccumuloResource accumuloResource = new AccumuloResource();

    @Before
    public void before() throws Exception {
        accumuloResource.resetAutorizations();
        super.before();
    }

    @Test
    public void testDefinePropertiesMultipleGraphs() {
        PropertyDefinition def;
        Graph graph1 = this.graph;
        AccumuloGraph graph2 = AccumuloGraph.create((AccumuloGraphConfiguration)new AccumuloGraphConfiguration(accumuloResource.createConfig()));
        graph1.defineProperty("p1").dataType(TextValue.class).sortable(true).textIndexHint((Collection)TextIndexHint.ALL).define();
        StopWatch timeout = new StopWatch();
        timeout.start();
        while (timeout.getTime() < 5000L) {
            Assert.assertNotNull((String)"Property definition cache shouldn't clear", (Object)graph1.getPropertyDefinition("p1"));
            def = graph2.getPropertyDefinition("p1");
            if (def == null) continue;
            LOGGER.debug("Propagation to graph #2 took %d ms", new Object[]{timeout.getTime()});
            break;
        }
        Assert.assertNotNull((String)"Property definition didn't propagate to graph #2", (Object)graph2.getPropertyDefinition("p1"));
        Assert.assertTrue((boolean)graph1.getPropertyDefinition("p1").isSortable());
        Assert.assertTrue((boolean)graph2.getPropertyDefinition("p1").isSortable());
        graph2.defineProperty("p1").dataType(TextValue.class).sortable(false).textIndexHint((Collection)TextIndexHint.ALL).define();
        Assert.assertFalse((boolean)graph2.getPropertyDefinition("p1").isSortable());
        timeout.reset();
        timeout.start();
        while (timeout.getTime() < 5000L) {
            def = graph1.getPropertyDefinition("p1");
            if (def == null || def.isSortable()) continue;
            LOGGER.debug("Propagation to graph #1 took %d ms", new Object[]{timeout.getTime()});
            return;
        }
        throw new RuntimeException("Timeout waiting for sortable update to propagate");
    }

    @Test
    public void testPropertyWithValueSeparator() {
        try {
            this.graph.prepareVertex("v1", VISIBILITY_EMPTY, "thing").addPropertyValue("prop1\u001f", "name1", (Value)Values.stringValue((String)"test"), VISIBILITY_EMPTY).save(AUTHORIZATIONS_EMPTY);
            throw new RuntimeException("Should have thrown a bad character exception");
        }
        catch (GeException geException) {
            return;
        }
    }

    @Test
    public void testListSplits() throws AccumuloSecurityException, TableNotFoundException, AccumuloException {
        TreeSet<Text> keys = new TreeSet<Text>();
        keys.add(new Text("j"));
        this.getGraph().getConnector().tableOperations().addSplits(this.getGraph().getVerticesTableName(), keys);
        keys = new TreeSet();
        keys.add(new Text("k"));
        this.getGraph().getConnector().tableOperations().addSplits(this.getGraph().getEdgesTableName(), keys);
        keys = new TreeSet();
        keys.add(new Text("l"));
        this.getGraph().getConnector().tableOperations().addSplits(this.getGraph().getDataTableName(), keys);
        List verticesTableSplits = IterableUtils.toList((Iterable)this.getGraph().listVerticesTableSplits());
        Assert.assertEquals((long)2L, (long)verticesTableSplits.size());
        Assert.assertEquals(null, (Object)((IdRange)verticesTableSplits.get(0)).getStart());
        Assert.assertEquals((Object)"j", (Object)((IdRange)verticesTableSplits.get(0)).getEnd());
        Assert.assertEquals((Object)"j", (Object)((IdRange)verticesTableSplits.get(1)).getStart());
        Assert.assertEquals(null, (Object)((IdRange)verticesTableSplits.get(1)).getEnd());
        List edgesTableSplits = IterableUtils.toList((Iterable)this.getGraph().listEdgesTableSplits());
        Assert.assertEquals((long)2L, (long)edgesTableSplits.size());
        Assert.assertEquals(null, (Object)((IdRange)edgesTableSplits.get(0)).getStart());
        Assert.assertEquals((Object)"k", (Object)((IdRange)edgesTableSplits.get(0)).getEnd());
        Assert.assertEquals((Object)"k", (Object)((IdRange)edgesTableSplits.get(1)).getStart());
        Assert.assertEquals(null, (Object)((IdRange)edgesTableSplits.get(1)).getEnd());
        List dataTableSplits = IterableUtils.toList((Iterable)this.getGraph().listDataTableSplits());
        Assert.assertEquals((long)2L, (long)dataTableSplits.size());
        Assert.assertEquals(null, (Object)((IdRange)dataTableSplits.get(0)).getStart());
        Assert.assertEquals((Object)"l", (Object)((IdRange)dataTableSplits.get(0)).getEnd());
        Assert.assertEquals((Object)"l", (Object)((IdRange)dataTableSplits.get(1)).getStart());
        Assert.assertEquals(null, (Object)((IdRange)dataTableSplits.get(1)).getEnd());
    }

    @Test
    public void testTracing() {
        this.getGraph().traceOn("test");
        try {
            this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        }
        finally {
            this.getGraph().traceOff();
        }
    }

    public void printVerticesTable(Authorizations authorizations) {
        String tableName = this.getGraph().getVerticesTableName();
        this.printTable(tableName, authorizations);
    }

    public void printTable(String tableName, Authorizations authorizations) {
        System.out.println(tableName);
        try {
            Connector connector = this.getGraph().getConnector();
            this.getGraph();
            Scanner scanner = connector.createScanner(tableName, AccumuloGraph.toAccumuloAuthorizations((Authorizations)authorizations));
            Text currentRow = null;
            ArrayList<Map.Entry<Key, org.apache.accumulo.core.data.Value>> rowEntries = new ArrayList<Map.Entry<Key, org.apache.accumulo.core.data.Value>>();
            for (Map.Entry entry : scanner) {
                if (!((Key)entry.getKey()).getRow().equals(currentRow)) {
                    this.printRowEntries(rowEntries);
                    rowEntries.clear();
                    currentRow = ((Key)entry.getKey()).getRow();
                }
                rowEntries.add(entry);
            }
            this.printRowEntries(rowEntries);
        }
        catch (TableNotFoundException ex) {
            throw new GeException("Could not print table", (Throwable)ex);
        }
    }

    private void printRowEntries(List<Map.Entry<Key, org.apache.accumulo.core.data.Value>> rowEntries) {
        if (rowEntries.size() == 0) {
            return;
        }
        rowEntries.sort(Comparator.comparingLong(o -> ((Key)o.getKey()).getTimestamp()));
        for (Map.Entry<Key, org.apache.accumulo.core.data.Value> rowEntry : rowEntries) {
            this.printRow(rowEntry);
        }
    }

    private void printRow(Map.Entry<Key, org.apache.accumulo.core.data.Value> rowEntry) {
        System.out.println(String.format("%s:%d:%s:%s[%s] => %s", rowEntry.getKey().getRow(), rowEntry.getKey().getTimestamp(), rowEntry.getKey().getColumnFamily(), rowEntry.getKey().getColumnQualifier(), rowEntry.getKey().getColumnVisibility(), rowEntry.getValue()));
    }

    public AccumuloGraph getGraph() {
        return (AccumuloGraph)super.getGraph();
    }

    public void addAuthorizations(String ... authorizations) {
        accumuloResource.addAuthorizations(this.getGraph(), authorizations);
    }

    public TestGraphFactory graphFactory() {
        return new AccumuloGraphFactory().withAccumuloResource(accumuloResource);
    }

    protected String substitutionDeflate(String str) {
        return str;
    }
}

