/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.store;

import com.mware.ge.store.Edges;
import com.mware.ge.store.EdgesWithCount;
import com.mware.ge.store.StorableEdgeInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class EdgesWithEdgeInfo
extends Edges {
    private final List<Map.Entry<String, StorableEdgeInfo>> pairs = new ArrayList<Map.Entry<String, StorableEdgeInfo>>();

    public void add(String edgeId, StorableEdgeInfo edgeInfo) {
        this.pairs.add(new Pair(edgeId, edgeInfo));
    }

    public void remove(String edgeId) {
        int i = this.indexOf(edgeId);
        if (i >= 0) {
            this.pairs.remove(i);
        }
    }

    private int indexOf(String edgeId) {
        for (int i = 0; i < this.pairs.size(); ++i) {
            if (!this.pairs.get(i).getKey().equals(edgeId)) continue;
            return i;
        }
        return -1;
    }

    public void clear() {
        this.pairs.clear();
    }

    public StorableEdgeInfo get(String edgeId) {
        int i = this.indexOf(edgeId);
        if (i >= 0) {
            return this.pairs.get(i).getValue();
        }
        return null;
    }

    public Iterable<StorableEdgeInfo> getEdgeInfos() {
        return () -> {
            final Iterator<Map.Entry<String, StorableEdgeInfo>> it = this.pairs.iterator();
            return new Iterator<StorableEdgeInfo>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public StorableEdgeInfo next() {
                    return (StorableEdgeInfo)((Map.Entry)it.next()).getValue();
                }

                @Override
                public void remove() {
                    throw new RuntimeException("not supported");
                }
            };
        };
    }

    public Iterable<Map.Entry<String, StorableEdgeInfo>> getEntries() {
        return this.pairs;
    }

    public EdgesWithCount getEdgesWithCount() {
        EdgesWithCount edgesWithCount = new EdgesWithCount();
        HashMap<String, AtomicInteger> edgesByLabels = new HashMap<String, AtomicInteger>();
        for (Map.Entry<String, StorableEdgeInfo> edgeEntry : this.getEntries()) {
            String label = edgeEntry.getValue().getLabel();
            edgesByLabels.computeIfAbsent(label, k -> new AtomicInteger(0)).incrementAndGet();
        }
        edgesByLabels.forEach((k, v) -> edgesWithCount.add((String)k, v.get()));
        return edgesWithCount;
    }

    private static class Pair
    implements Map.Entry<String, StorableEdgeInfo> {
        private final String edgeId;
        private final StorableEdgeInfo edgeInfo;

        public Pair(String edgeId, StorableEdgeInfo edgeInfo) {
            this.edgeId = edgeId;
            this.edgeInfo = edgeInfo;
        }

        @Override
        public String getKey() {
            return this.edgeId;
        }

        @Override
        public StorableEdgeInfo getValue() {
            return this.edgeInfo;
        }

        @Override
        public StorableEdgeInfo setValue(StorableEdgeInfo value) {
            throw new RuntimeException("not supported");
        }
    }
}

