/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.security;

import com.mware.ge.security.ArrayByteSequence;
import com.mware.ge.security.AuthorizationContainer;
import com.mware.ge.security.ByteBufferUtil;
import com.mware.ge.security.ByteSequence;
import com.mware.ge.security.Constants;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class SecurityAuthorizations
implements Iterable<byte[]>,
Serializable,
AuthorizationContainer {
    private static final long serialVersionUID = 1L;
    private Set<ByteSequence> auths = new HashSet<ByteSequence>();
    private List<byte[]> authsList = new ArrayList<byte[]>();
    public static final SecurityAuthorizations EMPTY;
    private static final boolean[] validAuthChars;

    static final boolean isValidAuthChar(byte b) {
        return validAuthChars[0xFF & b];
    }

    private void checkAuths() {
        TreeSet<ByteSequence> sortedAuths = new TreeSet<ByteSequence>(this.auths);
        for (ByteSequence bs : sortedAuths) {
            if (bs.length() == 0) {
                throw new IllegalArgumentException("Empty authorization");
            }
            this.authsList.add(bs.toArray());
        }
    }

    public SecurityAuthorizations(Collection<byte[]> authorizations) {
        for (byte[] auth : authorizations) {
            this.auths.add(new ArrayByteSequence(auth));
        }
        this.checkAuths();
    }

    public SecurityAuthorizations(List<ByteBuffer> authorizations) {
        for (ByteBuffer buffer : authorizations) {
            this.auths.add(new ArrayByteSequence(ByteBufferUtil.toBytes(buffer)));
        }
        this.checkAuths();
    }

    public SecurityAuthorizations() {
    }

    public SecurityAuthorizations(String ... authorizations) {
        this.setAuthorizations(authorizations);
    }

    private void setAuthorizations(String ... authorizations) {
        this.auths.clear();
        for (String str : authorizations) {
            str = str.trim();
            this.auths.add(new ArrayByteSequence(str.getBytes(Constants.UTF8)));
        }
        this.checkAuths();
    }

    public List<byte[]> getAuthorizations() {
        ArrayList<byte[]> copy = new ArrayList<byte[]>(this.authsList.size());
        for (byte[] auth : this.authsList) {
            byte[] bytes = new byte[auth.length];
            System.arraycopy(auth, 0, bytes, 0, auth.length);
            copy.add(bytes);
        }
        return Collections.unmodifiableList(copy);
    }

    public List<ByteBuffer> getAuthorizationsBB() {
        ArrayList<ByteBuffer> copy = new ArrayList<ByteBuffer>(this.authsList.size());
        for (byte[] auth : this.authsList) {
            byte[] bytes = new byte[auth.length];
            System.arraycopy(auth, 0, bytes, 0, auth.length);
            copy.add(ByteBuffer.wrap(bytes));
        }
        return Collections.unmodifiableList(copy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        for (ByteSequence auth : this.auths) {
            sb.append(sep);
            sep = ",";
            sb.append(new String(auth.toArray(), Constants.UTF8));
        }
        return sb.toString();
    }

    public boolean contains(byte[] auth) {
        return this.auths.contains(new ArrayByteSequence(auth));
    }

    @Override
    public boolean contains(ByteSequence auth) {
        return this.auths.contains(auth);
    }

    public boolean contains(String auth) {
        return this.auths.contains(new ArrayByteSequence(auth));
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof SecurityAuthorizations) {
            SecurityAuthorizations ao = (SecurityAuthorizations)o;
            return this.auths.equals(ao.auths);
        }
        return false;
    }

    public int hashCode() {
        int result = 0;
        for (ByteSequence b : this.auths) {
            result += b.hashCode();
        }
        return result;
    }

    public int size() {
        return this.auths.size();
    }

    public boolean isEmpty() {
        return this.auths.isEmpty();
    }

    @Override
    public Iterator<byte[]> iterator() {
        return this.getAuthorizations().iterator();
    }

    static {
        int i;
        EMPTY = new SecurityAuthorizations();
        validAuthChars = new boolean[256];
        for (i = 0; i < 256; ++i) {
            SecurityAuthorizations.validAuthChars[i] = false;
        }
        for (i = 97; i <= 122; ++i) {
            SecurityAuthorizations.validAuthChars[i] = true;
        }
        for (i = 65; i <= 90; ++i) {
            SecurityAuthorizations.validAuthChars[i] = true;
        }
        for (i = 48; i <= 57; ++i) {
            SecurityAuthorizations.validAuthChars[i] = true;
        }
        SecurityAuthorizations.validAuthChars[95] = true;
        SecurityAuthorizations.validAuthChars[45] = true;
        SecurityAuthorizations.validAuthChars[58] = true;
        SecurityAuthorizations.validAuthChars[46] = true;
        SecurityAuthorizations.validAuthChars[47] = true;
    }
}

