/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.security;

import com.mware.ge.security.ByteSequence;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ByteBufferUtil {
    public static byte[] toBytes(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        if (buffer.hasArray()) {
            return Arrays.copyOfRange(buffer.array(), buffer.position() + buffer.arrayOffset(), buffer.limit() + buffer.arrayOffset());
        }
        byte[] data = new byte[buffer.remaining()];
        buffer.duplicate().get(data);
        return data;
    }

    public static List<ByteBuffer> toByteBuffers(Collection<byte[]> bytesList) {
        if (bytesList == null) {
            return null;
        }
        ArrayList<ByteBuffer> result = new ArrayList<ByteBuffer>();
        for (byte[] bytes : bytesList) {
            result.add(ByteBuffer.wrap(bytes));
        }
        return result;
    }

    public static List<byte[]> toBytesList(Collection<ByteBuffer> bytesList) {
        if (bytesList == null) {
            return null;
        }
        ArrayList<byte[]> result = new ArrayList<byte[]>(bytesList.size());
        for (ByteBuffer bytes : bytesList) {
            result.add(ByteBufferUtil.toBytes(bytes));
        }
        return result;
    }

    public static String toString(ByteBuffer bytes) {
        if (bytes.hasArray()) {
            return new String(bytes.array(), bytes.arrayOffset() + bytes.position(), bytes.remaining(), StandardCharsets.UTF_8);
        }
        return new String(ByteBufferUtil.toBytes(bytes), StandardCharsets.UTF_8);
    }

    public static ByteBuffer toByteBuffers(ByteSequence bs) {
        if (bs == null) {
            return null;
        }
        if (bs.isBackedByArray()) {
            return ByteBuffer.wrap(bs.getBackingArray(), bs.offset(), bs.length());
        }
        return ByteBuffer.wrap(bs.toArray());
    }
}

