/*
 * Decompiled with CFR 0.152.
 */
package com.mware.bigconnect;

import com.mware.bigconnect.WebServer;
import com.mware.bolt.BoltServer;
import com.mware.core.bootstrap.InjectHelper;
import com.mware.core.cmdline.CommandLineTool;
import com.mware.core.model.graph.GraphRepository;
import com.mware.core.model.notification.SystemNotificationService;
import com.mware.core.model.user.GraphAuthorizationRepository;
import com.mware.core.process.DataWorkerRunnerProcess;
import com.mware.core.process.ExternalResourceRunnerProcess;
import com.mware.core.process.LongRunningProcessRunnerProcess;
import com.mware.core.process.SystemNotificationProcess;
import com.mware.core.util.VersionUtil;
import com.mware.ge.metric.DropWizardMetricRegistry;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class BigConnectRunner
extends CommandLineTool {
    private ExecutorService executorService;

    protected int run() throws Exception {
        this.executorService = Executors.newSingleThreadExecutor(runnable -> {
            Thread t = new Thread(runnable);
            t.setName("bc-runner-" + t.getId());
            t.setDaemon(true);
            return t;
        });
        this.verifyGraphVersion();
        this.setupGraphAuthorizations();
        InjectHelper.getInstance(DataWorkerRunnerProcess.class);
        InjectHelper.getInstance(ExternalResourceRunnerProcess.class);
        InjectHelper.getInstance(LongRunningProcessRunnerProcess.class);
        InjectHelper.getInstance(SystemNotificationProcess.class);
        InjectHelper.getInstance(BoltServer.class);
        InjectHelper.getInstance(SystemNotificationService.class);
        InjectHelper.getInstance(WebServer.class);
        VersionUtil.printVersion();
        new DropWizardMetricRegistry();
        this.executorService.awaitTermination(10000L, TimeUnit.DAYS);
        return 0;
    }

    private void verifyGraphVersion() {
        GraphRepository graphRepository = (GraphRepository)InjectHelper.getInstance(GraphRepository.class);
        graphRepository.verifyVersion();
    }

    private void setupGraphAuthorizations() {
        this.LOGGER.debug("setupGraphAuthorizations", new Object[0]);
        GraphAuthorizationRepository graphAuthorizationRepository = (GraphAuthorizationRepository)InjectHelper.getInstance(GraphAuthorizationRepository.class);
        graphAuthorizationRepository.addAuthorizationToGraph(new String[]{"administrator", "user", "termMention", "longRunningProcess", "ontology", "workspace", "videoFrame"});
    }

    protected void shutdown() {
        this.executorService.shutdownNow();
        super.shutdown();
    }

    public static void main(String[] args) throws Exception {
        CommandLineTool.main((CommandLineTool)new BigConnectRunner(), (String[])args);
    }
}

