/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.yarn;

import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.internal.Lists;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;

public abstract class ClientBase {
    public static final short FILE_PERMISSIONS = 456;
    private static BcLogger LOGGER;
    @Parameter(names={"-memory", "-mem"}, description="Memory for each process in MB.")
    private int memory = 512;
    @Parameter(names={"-cores"}, description="Number of virtual cores each process uses.")
    private int virtualCores = 1;
    @Parameter(names={"-instances", "-i"}, description="Number of instances to start.")
    private int instances = 1;
    @Parameter(names={"-jar"}, description="Path to jar.", required=true)
    private String jar = null;
    @Parameter(names={"-queue"}, description="Yarn queue to run the job on")
    private String queue = "default";
    @DynamicParameter(names={"-env"}, description="Environment variable override. (e.g.: -envPATH=/foo:/bar -envLD_LIBRARY_PATH=/baz)")
    private Map<String, String> environmentVariableOverrides = new HashMap<String, String>();

    public static void printEnv() {
        ClientBase.initLogger();
        LOGGER.info("Environment:", new Object[0]);
        LinkedList environmentVariables = Lists.newLinkedList(System.getenv().entrySet());
        environmentVariables.sort((o1, o2) -> ((String)o1.getKey()).compareTo((String)o2.getKey()));
        for (Map.Entry e : environmentVariables) {
            LOGGER.info("  %s=%s", new Object[]{e.getKey(), e.getValue()});
        }
    }

    public static void printSystemProperties() {
        ClientBase.initLogger();
        LOGGER.info("System Properties:", new Object[0]);
        LinkedList environmentVariables = Lists.newLinkedList(System.getProperties().stringPropertyNames());
        Collections.sort(environmentVariables);
        for (String e : environmentVariables) {
            LOGGER.info("  %s=%s", new Object[]{e, System.getProperty(e)});
        }
    }

    protected int run(String[] args) throws Exception {
        ClientBase.initLogger();
        new JCommander((Object)this, args);
        ClientBase.printEnv();
        ClientBase.printSystemProperties();
        String myClasspath = System.getProperty("java.class.path");
        String localResourceJarFileName = this.getAppName() + ".jar";
        File jarPath = new File(this.jar);
        if (!jarPath.isFile()) {
            throw new Exception("YARN app must be packaged as a jar file (found path: " + jarPath + ").");
        }
        LOGGER.info("Using jar path: " + jarPath, new Object[0]);
        String classPathEnv = myClasspath + ":./" + localResourceJarFileName;
        LOGGER.info("Classpath: " + classPathEnv, new Object[0]);
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("mapreduce.job.user.classpath.first", true);
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path remotePath = new Path(fs.getHomeDirectory(), this.getAppName());
        YarnClient yarnClient = this.createYarnClient(conf);
        YarnClientApplication app = yarnClient.createApplication();
        ContainerLaunchContext amContainer = this.createContainerLaunchContextRecord(classPathEnv, remotePath);
        Resource capability = this.createResourceRecord();
        ApplicationSubmissionContext appContext = this.createApplicationSubmissionContext(app, amContainer, capability);
        ApplicationId appId = appContext.getApplicationId();
        amContainer.setLocalResources(this.createLocalResources(fs, remotePath, localResourceJarFileName, jarPath));
        amContainer.setEnvironment(this.createEnvironment(classPathEnv));
        LOGGER.info("Submitting application " + appId, new Object[0]);
        yarnClient.submitApplication(appContext);
        this.waitForApplication(yarnClient, appId, 30, TimeUnit.SECONDS);
        return 0;
    }

    protected abstract String getAppName();

    private void waitForApplication(YarnClient yarnClient, ApplicationId appId, int time, TimeUnit timeUnit) throws YarnException, IOException, InterruptedException {
        Date startTime = new Date();
        Date endTime = new Date(startTime.getTime() + timeUnit.toMillis(time));
        ApplicationReport appReport = yarnClient.getApplicationReport(appId);
        YarnApplicationState appState = appReport.getYarnApplicationState();
        while (appState != YarnApplicationState.FINISHED && appState != YarnApplicationState.KILLED && appState != YarnApplicationState.FAILED && appState != YarnApplicationState.RUNNING && System.currentTimeMillis() <= endTime.getTime()) {
            Thread.sleep(100L);
            appReport = yarnClient.getApplicationReport(appId);
            appState = appReport.getYarnApplicationState();
        }
        LOGGER.info("Application " + appId + " state " + appState, new Object[0]);
    }

    private Map<String, String> createEnvironment(String classPathEnv) {
        HashMap<String, String> appMasterEnv = new HashMap<String, String>();
        appMasterEnv.putAll(System.getenv());
        appMasterEnv.put(ApplicationConstants.Environment.CLASSPATH.name(), classPathEnv);
        appMasterEnv.putAll(this.environmentVariableOverrides);
        return appMasterEnv;
    }

    private Map<String, LocalResource> createLocalResources(FileSystem fs, Path remotePath, String localResourceJarFileName, File jarPath) throws IOException {
        HashMap<String, LocalResource> localResources = new HashMap<String, LocalResource>();
        this.addToLocalResources(fs, remotePath, jarPath.getPath(), localResourceJarFileName, localResources, null);
        return localResources;
    }

    private YarnClient createYarnClient(YarnConfiguration conf) {
        YarnClient yarnClient = YarnClient.createYarnClient();
        yarnClient.init((Configuration)conf);
        yarnClient.start();
        return yarnClient;
    }

    private Resource createResourceRecord() {
        Resource capability = (Resource)Records.newRecord(Resource.class);
        capability.setMemory(this.memory);
        capability.setVirtualCores(this.virtualCores);
        return capability;
    }

    private ContainerLaunchContext createContainerLaunchContextRecord(String classPathEnv, Path remotePath) {
        ContainerLaunchContext amContainer = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        String command = this.createCommand(classPathEnv, remotePath);
        LOGGER.info("Running: " + command, new Object[0]);
        amContainer.setCommands(Collections.singletonList(command));
        return amContainer;
    }

    protected String createCommand(String classPathEnv, Path remotePath) {
        return "${JAVA_HOME}/bin/java -Xmx" + this.memory + "M -Djava.net.preferIPv4Stack=true -cp " + classPathEnv + " " + this.getApplicationMasterClass().getName() + " -memory " + this.memory + " -cores " + this.virtualCores + " -instances " + this.instances + " -appname " + this.getAppName() + " -remotepath " + remotePath + " 1>" + "<LOG_DIR>" + "/stdout 2>" + "<LOG_DIR>" + "/stderr";
    }

    protected abstract Class getApplicationMasterClass();

    private ApplicationSubmissionContext createApplicationSubmissionContext(YarnClientApplication app, ContainerLaunchContext amContainer, Resource capability) {
        ApplicationSubmissionContext appContext = app.getApplicationSubmissionContext();
        appContext.setApplicationName(this.getAppName());
        appContext.setAMContainerSpec(amContainer);
        appContext.setResource(capability);
        appContext.setQueue(this.queue);
        return appContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToLocalResources(FileSystem fs, Path remotePath, String fileSrcPath, String fileDstPath, Map<String, LocalResource> localResources, String resources) throws IOException {
        Path dst;
        block3: {
            block2: {
                dst = new Path(remotePath, fileDstPath);
                if (fileSrcPath != null) break block2;
                FSDataOutputStream out = null;
                try {
                    out = FileSystem.create((FileSystem)fs, (Path)dst, (FsPermission)new FsPermission(456));
                    out.writeUTF(resources);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(out);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)out);
                break block3;
            }
            fs.copyFromLocalFile(new Path(fileSrcPath), dst);
        }
        FileStatus scFileStatus = fs.getFileStatus(dst);
        LocalResource localResource = LocalResource.newInstance((URL)ConverterUtils.getYarnUrlFromURI((URI)dst.toUri()), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.APPLICATION, (long)scFileStatus.getLen(), (long)scFileStatus.getModificationTime());
        localResources.put(fileDstPath, localResource);
    }

    private static void initLogger() {
        if (LOGGER == null) {
            LOGGER = BcLoggerFactory.getLogger(ClientBase.class);
        }
    }

    public int getMemory() {
        return this.memory;
    }

    public int getVirtualCores() {
        return this.virtualCores;
    }

    public int getInstances() {
        return this.instances;
    }
}

