/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.file;

import com.google.inject.Inject;
import com.mware.core.config.BcHadoopConfiguration;
import com.mware.core.config.Configuration;
import com.mware.core.exception.BcException;
import com.mware.core.model.file.FileSystemRepository;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HdfsFileSystemRepository
extends FileSystemRepository {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(HdfsFileSystemRepository.class);
    private static final String CONFIG_PREFIX = HdfsFileSystemRepository.class.getName() + ".prefix";
    private static final String CONFIG_PREFIX_DEFAULT = "/bigconnect/config/";
    private final FileSystem hdfsFileSystem;
    private final String prefix;

    @Inject
    public HdfsFileSystemRepository(Configuration configuration) {
        this.hdfsFileSystem = HdfsFileSystemRepository.getFileSystem(configuration);
        this.prefix = configuration.get(CONFIG_PREFIX, CONFIG_PREFIX_DEFAULT);
    }

    public static FileSystem getFileSystem(Configuration configuration) {
        String hdfsUserName = configuration.get("hdfsUserName", "hadoop");
        String fsDefaultFS = configuration.get("fs.defaultFS", null);
        try {
            return FileSystem.get((URI)new URI(fsDefaultFS), (org.apache.hadoop.conf.Configuration)BcHadoopConfiguration.getHadoopConfiguration(configuration), (String)hdfsUserName);
        }
        catch (Exception e) {
            throw new BcException("Could not open hdfs filesystem: " + fsDefaultFS + " (user: " + hdfsUserName + ")", (Throwable)e);
        }
    }

    public File getLocalFileFor(String path) {
        try {
            Path filePath = this.getHdfsPath(path);
            String fileName = filePath.getName();
            File tempFile = new File(System.getProperty("java.io.tmpdir"), fileName);
            LOGGER.debug("Copying %s to %s", new Object[]{filePath, tempFile.getAbsolutePath()});
            try (FSDataInputStream shapeInputStream = this.hdfsFileSystem.open(filePath);){
                FileUtils.copyInputStreamToFile((InputStream)shapeInputStream, (File)tempFile);
            }
            return tempFile;
        }
        catch (IOException ex) {
            throw new BcException("Could not copy file: " + path, (Throwable)ex);
        }
    }

    private Path getHdfsPath(String path) {
        try {
            Path filePath = new Path(this.prefix + path);
            if (!this.hdfsFileSystem.exists(filePath)) {
                throw new BcException("Could not find file: " + this.hdfsFileSystem.getUri() + filePath);
            }
            return filePath;
        }
        catch (IOException ex) {
            throw new BcException("Could not get path for: " + path, (Throwable)ex);
        }
    }

    public InputStream getInputStream(String path) {
        try {
            return this.hdfsFileSystem.open(this.getHdfsPath(path));
        }
        catch (IOException ex) {
            throw new BcException("Could not open file: " + path, (Throwable)ex);
        }
    }

    public Iterable<String> list(String path) {
        ArrayList<String> results = new ArrayList<String>();
        try {
            FileStatus[] statuses;
            for (FileStatus status : statuses = this.hdfsFileSystem.listStatus(this.getHdfsPath(path))) {
                results.add(status.getPath().getName());
            }
        }
        catch (IOException e) {
            throw new BcException("Could not get files for: " + path);
        }
        return results;
    }

    public FileSystem getHdfsFileSystem() {
        return this.hdfsFileSystem;
    }
}

