/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.config;

import com.mware.core.config.Configuration;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;

public class BcHadoopConfiguration {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(BcHadoopConfiguration.class);
    public static final String HDFS_LIB_SOURCE_DIRECTORY = "hdfsLib.sourceDirectory";
    public static final String HDFS_LIB_TEMP_DIRECTORY = "hdfsLib.tempDirectory";
    public static final String HDFS_USER_NAME = "hdfsUserName";
    public static final String HDFS_USER_NAME_DEFAULT = "hadoop";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String PROPERTY_HADOOP_CONF_DIR = "hadoop.conf.dir";
    public static final String ENV_VARIABLE_HADOOP_CONF_DIR = "HADOOP_CONF_DIR";
    public static final String DEFAULT_HADOOP_CONF_DIR = "/etc/hadoop/conf";
    public static final String[] HADOOP_CONF_FILENAMES = new String[]{"core-site.xml", "hdfs-site.xml", "mapred-site.xml", "yarn-site.xml"};

    @Deprecated
    public static org.apache.hadoop.conf.Configuration toHadoopConfiguration(Configuration configuration) {
        org.apache.hadoop.conf.Configuration conf = new org.apache.hadoop.conf.Configuration();
        Iterator iterator = configuration.toMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entryObj;
            Map.Entry entry = entryObj = iterator.next();
            conf.set(entry.getKey().toString(), entry.getValue().toString());
        }
        return conf;
    }

    @Deprecated
    public static org.apache.hadoop.conf.Configuration toHadoopConfiguration(Configuration configuration, org.apache.hadoop.conf.Configuration additionalConfiguration) {
        org.apache.hadoop.conf.Configuration hadoopConfig = BcHadoopConfiguration.toHadoopConfiguration(configuration);
        hadoopConfig.setBoolean("mapred.used.genericoptionsparser", true);
        for (Map.Entry toolConfItem : additionalConfiguration) {
            hadoopConfig.set((String)toolConfItem.getKey(), (String)toolConfItem.getValue());
        }
        return hadoopConfig;
    }

    public static org.apache.hadoop.conf.Configuration getHadoopConfiguration(Configuration configuration, org.apache.hadoop.conf.Configuration additionalConfiguration) {
        org.apache.hadoop.conf.Configuration result = BcHadoopConfiguration.getHadoopConfiguration(configuration);
        for (Map.Entry entry : additionalConfiguration) {
            result.set((String)entry.getKey(), (String)entry.getValue());
        }
        return result;
    }

    public static org.apache.hadoop.conf.Configuration getHadoopConfiguration(Configuration configuration) {
        org.apache.hadoop.conf.Configuration hadoopConfiguration = new org.apache.hadoop.conf.Configuration();
        Iterator iterator = configuration.toMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entryObj;
            Map.Entry entry = entryObj = iterator.next();
            hadoopConfiguration.set(entry.getKey().toString(), entry.getValue().toString());
        }
        hadoopConfiguration.setBoolean("mapred.used.genericoptionsparser", true);
        File dir = null;
        String property = configuration.get(PROPERTY_HADOOP_CONF_DIR, null);
        String envVariable = System.getenv(ENV_VARIABLE_HADOOP_CONF_DIR);
        if (property != null && !(dir = new File(property)).isDirectory()) {
            LOGGER.warn("configuration property %s is not a directory", new Object[]{PROPERTY_HADOOP_CONF_DIR});
            dir = null;
        }
        if (dir == null && envVariable != null && !(dir = new File(envVariable)).isDirectory()) {
            LOGGER.warn("environment variable %s is not a directory", new Object[]{ENV_VARIABLE_HADOOP_CONF_DIR});
            dir = null;
        }
        if (dir == null && !(dir = new File(DEFAULT_HADOOP_CONF_DIR)).isDirectory()) {
            LOGGER.warn("(default) %s is not a directory", new Object[]{DEFAULT_HADOOP_CONF_DIR});
            dir = null;
        }
        if (dir != null) {
            for (String xmlFilename : HADOOP_CONF_FILENAMES) {
                File file = new File(dir, xmlFilename);
                if (!file.isFile()) continue;
                LOGGER.info("adding resource: %s to Hadoop configuration", new Object[]{file});
                try {
                    ByteArrayInputStream in = new ByteArrayInputStream(FileUtils.readFileToByteArray((File)file));
                    hadoopConfiguration.addResource((InputStream)in);
                }
                catch (Exception ex) {
                    LOGGER.warn("error adding resource: " + xmlFilename + " to Hadoop configuration", (Throwable)ex);
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        TreeSet keys = new TreeSet();
        for (Map.Entry entry : hadoopConfiguration) {
            keys.add(entry.getKey());
        }
        boolean first = true;
        for (String key : keys) {
            String source;
            String[] sources = hadoopConfiguration.getPropertySources(key);
            if (sources == null || (source = sources[sources.length - 1]).endsWith("default.xml") && !LOGGER.isTraceEnabled()) continue;
            if (first) {
                first = false;
            } else {
                sb.append(LINE_SEPARATOR);
            }
            if (key.toLowerCase().contains("password")) {
                sb.append(key).append(": ********");
            } else {
                sb.append(key).append(": ").append(hadoopConfiguration.get(key));
            }
            sb.append(" (").append(source).append(")");
        }
        LOGGER.debug("Hadoop configuration:%n%s", new Object[]{sb.toString()});
        return hadoopConfiguration;
    }
}

