/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import org.apache.commons.codec.binary.Hex;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HdfsLimitOutputStream
extends OutputStream {
    private static Random random = new Random();
    private final FileSystem fs;
    private final int maxSizeToStore;
    private final ByteArrayOutputStream smallOutputStream;
    private final MessageDigest digest = MessageDigest.getInstance("SHA-256");
    private OutputStream largeOutputStream;
    private Path hdfsPath;
    private long length;

    public HdfsLimitOutputStream(FileSystem fs, long maxSizeToStore) throws NoSuchAlgorithmException {
        this.fs = fs;
        this.maxSizeToStore = (int)maxSizeToStore;
        this.smallOutputStream = new ByteArrayOutputStream((int)maxSizeToStore);
        this.length = 0L;
    }

    private synchronized OutputStream getLargeOutputStream() throws IOException {
        if (this.largeOutputStream == null) {
            this.hdfsPath = this.createTempPath();
            this.largeOutputStream = this.fs.create(this.hdfsPath);
            this.largeOutputStream.write(this.smallOutputStream.toByteArray());
        }
        return this.largeOutputStream;
    }

    private Path createTempPath() {
        return new Path("/tmp/hdfsLimitOutputStream-" + random.nextLong());
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.digest.update((byte)b);
        if (this.smallOutputStream.size() <= this.maxSizeToStore - 1) {
            this.smallOutputStream.write(b);
        } else {
            this.getLargeOutputStream().write(b);
        }
        ++this.length;
    }

    @Override
    public synchronized void write(byte[] b) throws IOException {
        this.digest.update(b);
        if (this.smallOutputStream.size() <= this.maxSizeToStore - b.length) {
            this.smallOutputStream.write(b);
        } else {
            this.getLargeOutputStream().write(b);
        }
        this.length += (long)b.length;
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.digest.update(b, off, len);
        if (this.smallOutputStream.size() <= this.maxSizeToStore - len) {
            this.smallOutputStream.write(b, off, len);
        } else {
            this.getLargeOutputStream().write(b, off, len);
        }
        this.length += (long)len;
    }

    public synchronized boolean hasExceededSizeLimit() {
        return this.largeOutputStream != null;
    }

    public Path getHdfsPath() {
        return this.hdfsPath;
    }

    public byte[] getSmall() {
        if (this.hasExceededSizeLimit()) {
            return null;
        }
        return this.smallOutputStream.toByteArray();
    }

    public String getRowKey() {
        byte[] sha = this.digest.digest();
        return "urn\u001dsha256\u001d" + Hex.encodeHexString((byte[])sha);
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.largeOutputStream != null) {
            this.largeOutputStream.flush();
        }
        super.close();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.largeOutputStream != null) {
            this.largeOutputStream.close();
        }
        this.smallOutputStream.close();
        super.close();
    }

    public long getLength() {
        return this.length;
    }
}

