/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.yarn;

import com.beust.jcommander.JCommander;
import com.mware.core.bootstrap.BcBootstrap;
import com.mware.core.bootstrap.InjectHelper;
import com.mware.core.config.Configuration;
import com.mware.core.config.ConfigurationLoader;
import com.mware.core.model.user.UserRepository;
import com.mware.core.model.yarn.ClientBase;
import com.mware.core.user.User;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;

public abstract class TaskBase {
    private Configuration configuration;
    private InjectHelper.ModuleMaker moduleMaker;
    private UserRepository userRepository;
    private User user;

    public final void run(String[] args) {
        BcLogger LOGGER = BcLoggerFactory.getLogger(TaskBase.class);
        new JCommander((Object)this, args);
        ClientBase.printEnv();
        ClientBase.printSystemProperties();
        try {
            LOGGER.info("BEGIN Run", new Object[0]);
            this.configuration = ConfigurationLoader.load();
            this.moduleMaker = BcBootstrap.bootstrapModuleMaker((Configuration)this.configuration);
            this.userRepository = (UserRepository)InjectHelper.getInstance(UserRepository.class, (InjectHelper.ModuleMaker)this.getModuleMaker(), (Configuration)this.getConfiguration());
            this.user = this.getUserRepository().getSystemUser();
            this.run();
            LOGGER.info("END Run", new Object[0]);
            System.exit(0);
        }
        catch (Throwable ex) {
            LOGGER.error("FAILED Run", ex);
            System.exit(1);
        }
    }

    protected abstract void run() throws Exception;

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public InjectHelper.ModuleMaker getModuleMaker() {
        return this.moduleMaker;
    }

    public UserRepository getUserRepository() {
        return this.userRepository;
    }

    public User getUser() {
        return this.user;
    }
}

