/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.mr;

import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.mware.core.bootstrap.BcBootstrap;
import com.mware.core.bootstrap.InjectHelper;
import com.mware.core.config.BcHadoopConfiguration;
import com.mware.core.config.Configuration;
import com.mware.core.config.ConfigurationLoader;
import com.mware.core.exception.BcException;
import com.mware.core.trace.TraceRepository;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.core.util.VersionUtil;
import com.mware.ge.accumulo.AccumuloGraphConfiguration;
import com.mware.ge.accumulo.mapreduce.AccumuloElementOutputFormat;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.util.Tool;

public abstract class BcMRBase
extends Configured
implements Tool {
    private static BcLogger LOGGER;
    public static final String CONFIG_SOURCE_FILE_NAME = "sourceFileName";
    public static final int PERIODIC_COUNTER_OUTPUT_PERIOD = 30000;
    private String instanceName;
    private String zooKeepers;
    private String principal;
    private AuthenticationToken authorizationToken;
    private boolean local;
    private Timer periodicCounterOutputTimer;
    private Configuration bcConfig;
    private AccumuloGraphConfiguration accumuloGraphConfiguration;
    @DynamicParameter(names={"-job"}, description="Set a job property. (e.g.: -job mapreduce.map.memory.mb=1024)")
    private Map<String, String> jobProperties = new HashMap<String, String>();
    @Parameter(names={"--help", "-h"}, description="Print help", help=true)
    private boolean help;
    @Parameter(names={"--version"}, description="Print version")
    private boolean version;

    public int run(String[] args) throws Exception {
        LOGGER = BcLoggerFactory.getLogger(BcMRBase.class);
        this.bcConfig = ConfigurationLoader.load();
        JobConf conf = this.getConfiguration(args, this.bcConfig);
        if (conf == null) {
            return -1;
        }
        this.accumuloGraphConfiguration = new AccumuloGraphConfiguration((org.apache.hadoop.conf.Configuration)conf, "graph.");
        InjectHelper.inject((Object)((Object)this), (InjectHelper.ModuleMaker)BcBootstrap.bootstrapModuleMaker((Configuration)this.bcConfig), (Configuration)this.bcConfig);
        if (this.bcConfig.getBoolean("trace.enabled", false)) {
            TraceRepository traceRepository = (TraceRepository)InjectHelper.getInstance(TraceRepository.class);
            traceRepository.enable();
        }
        Job job = Job.getInstance((org.apache.hadoop.conf.Configuration)conf, (String)this.getJobName());
        this.instanceName = this.accumuloGraphConfiguration.getAccumuloInstanceName();
        this.zooKeepers = this.accumuloGraphConfiguration.getZookeeperServers();
        this.principal = this.accumuloGraphConfiguration.getAccumuloUsername();
        this.authorizationToken = this.accumuloGraphConfiguration.getAuthenticationToken();
        AccumuloElementOutputFormat.setOutputInfo((Job)job, (String)this.instanceName, (String)this.zooKeepers, (String)this.principal, (AuthenticationToken)this.authorizationToken);
        boolean periodicCounterOutput = conf.getBoolean("bc.periodic.counter.output.enabled", false);
        if (job.getConfiguration().get("mapreduce.framework.name").equals("local")) {
            LOGGER.warn("!!!!!! Running in local mode !!!!!!", new Object[0]);
            this.local = true;
            periodicCounterOutput = true;
        }
        this.setupJob(job);
        if (periodicCounterOutput) {
            this.startPeriodicCounterOutputThread(job);
        }
        LOGGER.info("Starting job", new Object[0]);
        long startTime = System.currentTimeMillis();
        int result = job.waitForCompletion(true) ? 0 : 1;
        long endTime = System.currentTimeMillis();
        LOGGER.info("Job complete", new Object[0]);
        if (job.getStatus().getState() != JobStatus.State.SUCCEEDED) {
            LOGGER.warn("Unexpected job state: %s", new Object[]{job.getStatus().getState()});
        }
        if (this.periodicCounterOutputTimer != null) {
            this.periodicCounterOutputTimer.cancel();
        }
        this.printCounters(job);
        LOGGER.info("Time: %,.2f minutes", new Object[]{(double)(endTime - startTime) / 1000.0 / 60.0});
        LOGGER.info("Return code: " + result, new Object[0]);
        return result;
    }

    public boolean isLocal() {
        return this.local;
    }

    protected void printCounters(Job job) {
        try {
            if (job.getJobState() != JobStatus.State.RUNNING) {
                return;
            }
        }
        catch (IllegalStateException e) {
            if (e.getMessage().contains("Job in state DEFINE instead of RUNNING")) {
                return;
            }
            throw new BcException("Could not get job state", (Throwable)e);
        }
        catch (Exception e) {
            throw new BcException("Could not get job state", (Throwable)e);
        }
        try {
            LOGGER.info("Counters", new Object[0]);
            for (String groupName : job.getCounters().getGroupNames()) {
                CounterGroup groupCounters = (CounterGroup)job.getCounters().getGroup(groupName);
                LOGGER.info(groupCounters.getDisplayName(), new Object[0]);
                for (Counter counter : groupCounters) {
                    LOGGER.info("  " + counter.getDisplayName() + ": " + counter.getValue(), new Object[0]);
                }
            }
        }
        catch (IOException ex) {
            LOGGER.error("Could not print counters", (Throwable)ex);
        }
    }

    protected String getJobName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    protected abstract void setupJob(Job var1) throws Exception;

    protected JobConf getConfiguration(String[] args, Configuration bcConfig) {
        org.apache.hadoop.conf.Configuration hadoopConfig = BcHadoopConfiguration.getHadoopConfiguration(bcConfig, this.getConf());
        hadoopConfig.set("graphConfigPrefix", "graph.");
        JobConf result = new JobConf(hadoopConfig, ((Object)((Object)this)).getClass());
        JCommander j = new JCommander((Object)this, args);
        j.setProgramName("hadoop jar <jar>");
        if (this.help) {
            j.usage();
            return null;
        }
        if (this.version) {
            VersionUtil.printVersion();
            return null;
        }
        this.processArgs(result, args);
        for (Map.Entry<String, String> jobProperty : this.jobProperties.entrySet()) {
            result.set(jobProperty.getKey(), jobProperty.getValue());
            LOGGER.info("setting config: %s = %s", new Object[]{jobProperty.getKey(), jobProperty.getValue()});
        }
        this.setConf((org.apache.hadoop.conf.Configuration)result);
        LOGGER.info("Using config:\n" + result, new Object[0]);
        return result;
    }

    protected abstract void processArgs(JobConf var1, String[] var2);

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getZooKeepers() {
        return this.zooKeepers;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public Configuration getBcConfig() {
        return this.bcConfig;
    }

    public AccumuloGraphConfiguration getAccumuloGraphConfiguration() {
        return this.accumuloGraphConfiguration;
    }

    public AuthenticationToken getAuthorizationToken() {
        return this.authorizationToken;
    }

    private void startPeriodicCounterOutputThread(final Job job) {
        this.periodicCounterOutputTimer = new Timer("periodicCounterOutput", true);
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                BcMRBase.this.printCounters(job);
            }
        };
        this.periodicCounterOutputTimer.scheduleAtFixedRate(task, 30000L, 30000L);
    }
}

