/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.mr;

import com.mware.core.bootstrap.BcBootstrap;
import com.mware.core.bootstrap.InjectHelper;
import com.mware.core.bootstrap.config.HdfsConfigurationLoader;
import com.mware.core.config.Configuration;
import com.mware.core.config.ConfigurationLoader;
import com.mware.core.trace.TraceRepository;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.ge.accumulo.mapreduce.ElementMapper;
import com.mware.ge.id.IdGenerator;
import com.mware.ge.id.UUIDIdGenerator;
import com.mware.ge.store.mutations.StoreMutation;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public abstract class BcElementMapperBase<KEYIN, VALUEIN>
extends ElementMapper<KEYIN, VALUEIN, Text, StoreMutation> {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(BcElementMapperBase.class);
    private IdGenerator idGenerator = new UUIDIdGenerator();

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        try {
            super.setup(context);
            System.setProperty("BC_CONFIGURATION_LOADER", HdfsConfigurationLoader.class.getName());
            Configuration bcConfig = ConfigurationLoader.load();
            InjectHelper.inject((Object)((Object)this), (InjectHelper.ModuleMaker)BcBootstrap.bootstrapModuleMaker((Configuration)bcConfig), (Configuration)bcConfig);
            if (bcConfig.getBoolean("trace.enabled", false)) {
                TraceRepository traceRepository = (TraceRepository)InjectHelper.getInstance(TraceRepository.class);
                traceRepository.enable();
            }
        }
        catch (Throwable ex) {
            LOGGER.error("Could not setup", ex);
            throw new IOException("Could not setup", ex);
        }
    }

    protected void map(KEYIN key, VALUEIN line, Mapper.Context context) {
        try {
            this.safeMap(key, line, context);
        }
        catch (Throwable ex) {
            LOGGER.error("failed mapping " + key, ex);
        }
    }

    protected abstract void safeMap(KEYIN var1, VALUEIN var2, Mapper.Context var3) throws Exception;

    protected void saveDataMutation(Mapper.Context context, Text dataTableName, StoreMutation m) throws IOException, InterruptedException {
        context.write((Object)this.getKey(context, dataTableName, m), (Object)m);
    }

    protected void saveEdgeMutation(Mapper.Context context, Text edgesTableName, StoreMutation m) throws IOException, InterruptedException {
        context.write((Object)this.getKey(context, edgesTableName, m), (Object)m);
    }

    protected void saveVertexMutation(Mapper.Context context, Text verticesTableName, StoreMutation m) throws IOException, InterruptedException {
        context.write((Object)this.getKey(context, verticesTableName, m), (Object)m);
    }

    protected Text getKey(Mapper.Context context, Text tableName, StoreMutation m) {
        return tableName;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }
}

