/*
 * Decompiled with CFR 0.152.
 */
package io.bigconnect.dw.text.language;

import com.google.common.base.Optional;
import com.mware.core.ingest.dataworker.DataWorker;
import com.mware.core.ingest.dataworker.DataWorkerData;
import com.mware.core.ingest.dataworker.DataWorkerPrepareData;
import com.mware.core.ingest.dataworker.ElementOrPropertyStatus;
import com.mware.core.model.Description;
import com.mware.core.model.Name;
import com.mware.core.model.properties.BcSchema;
import com.mware.core.model.properties.RawObjectSchema;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.ge.Element;
import com.mware.ge.Property;
import com.mware.ge.Visibility;
import com.mware.ge.mutation.ExistingElementMutation;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.Values;
import com.optimaize.langdetect.i18n.LdLocale;
import com.optimaize.langdetect.profiles.BuiltInLanguages;
import io.bigconnect.dw.text.language.LanguageDetectorUtil;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

@Name(value="Text Language Detector")
@Description(value="Detect the language of a piece of text")
public class LanguageDetectorWorker
extends DataWorker {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(LanguageDetectorWorker.class);
    private LanguageDetectorUtil languageDetector;

    public void prepare(DataWorkerPrepareData workerPrepareData) throws Exception {
        super.prepare(workerPrepareData);
        this.languageDetector = new LanguageDetectorUtil();
    }

    public boolean isHandled(Element element, Property property) {
        if (property == null) {
            return false;
        }
        return BcSchema.TEXT.getPropertyName().equals(property.getName()) || BcSchema.TITLE.getPropertyName().equals(property.getName());
    }

    public void execute(InputStream in, DataWorkerData data) throws Exception {
        if (BcSchema.TEXT.isSameName(data.getProperty())) {
            String text = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            if (StringUtils.isEmpty((CharSequence)text)) {
                return;
            }
            Optional<String> language = this.languageDetector.detectLanguage(text);
            if (language.isPresent()) {
                ExistingElementMutation m = this.refresh(data.getElement()).prepareMutation();
                m.setPropertyMetadata(data.getProperty(), BcSchema.TEXT_LANGUAGE_METADATA.getMetadataKey(), (Value)Values.stringValue((String)((String)language.get())), Visibility.EMPTY);
                m.addPropertyValue(data.getProperty().getKey(), RawObjectSchema.RAW_LANGUAGE.getPropertyName(), (Value)Values.stringValue((String)((String)language.get())), Visibility.EMPTY);
                Element e = m.save(this.getAuthorizations());
                this.getGraph().flush();
                this.getWorkQueueRepository().pushGraphPropertyQueue(e, data.getProperty().getKey(), RawObjectSchema.RAW_LANGUAGE.getPropertyName(), data.getWorkspaceId(), data.getVisibilitySource(), data.getPriority(), ElementOrPropertyStatus.UPDATE, null);
            } else {
                LOGGER.warn("Could not detect language for text: " + text, new Object[0]);
            }
        } else if (BcSchema.TITLE.isSameName(data.getProperty())) {
            String title = (String)BcSchema.TITLE.getFirstPropertyValue(data.getElement());
            Optional<String> language = this.languageDetector.detectLanguage(title);
            if (language.isPresent()) {
                ExistingElementMutation m = this.refresh(data.getElement()).prepareMutation();
                m.setPropertyMetadata(data.getProperty(), BcSchema.TEXT_LANGUAGE_METADATA.getMetadataKey(), (Value)Values.stringValue((String)((String)language.get())), Visibility.EMPTY);
                Element e = m.save(this.getAuthorizations());
                this.getGraph().flush();
                this.getWorkQueueRepository().pushGraphPropertyQueue(e, data.getProperty().getKey(), RawObjectSchema.TITLE_LANGUAGE.getPropertyName(), data.getWorkspaceId(), data.getVisibilitySource(), data.getPriority(), ElementOrPropertyStatus.UPDATE, null);
            } else {
                LOGGER.warn("Could not detect language for title: " + title, new Object[0]);
            }
        }
    }

    public static Set<String> getSupportedLanguages() {
        List languages = BuiltInLanguages.getLanguages();
        return languages.stream().map(LdLocale::getLanguage).collect(Collectors.toSet());
    }
}

