/*
 * Decompiled with CFR 0.152.
 */
package io.bigconnect.dw.text.language;

import com.google.common.base.Optional;
import com.optimaize.langdetect.LanguageDetector;
import com.optimaize.langdetect.LanguageDetectorBuilder;
import com.optimaize.langdetect.i18n.LdLocale;
import com.optimaize.langdetect.ngram.NgramExtractor;
import com.optimaize.langdetect.ngram.NgramExtractors;
import com.optimaize.langdetect.profiles.LanguageProfileReader;
import com.optimaize.langdetect.text.CommonTextObjectFactories;
import com.optimaize.langdetect.text.TextObject;
import com.optimaize.langdetect.text.TextObjectFactory;
import java.util.List;

public class LanguageDetectorUtil {
    private LanguageDetector languageDetector;

    public LanguageDetectorUtil() throws Exception {
        List languageProfiles = new LanguageProfileReader().readAllBuiltIn();
        this.languageDetector = LanguageDetectorBuilder.create((NgramExtractor)NgramExtractors.standard()).withProfiles((Iterable)languageProfiles).minimalConfidence(0.75).build();
    }

    synchronized Optional<String> detectLanguage(String text) {
        TextObjectFactory textObjectFactory = CommonTextObjectFactories.forDetectingOnLargeText();
        TextObject textObject = textObjectFactory.forText((CharSequence)text);
        Optional lang = this.languageDetector.detect((CharSequence)textObject);
        return lang.transform(LdLocale::getLanguage);
    }
}

