/*
 * Decompiled with CFR 0.152.
 */
package io.bigconnect.dw.text.common;

import com.mware.core.model.properties.BcSchema;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.ge.Element;
import com.mware.ge.Property;
import com.mware.ge.collection.Iterables;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class TextPropertyHelper {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(TextPropertyHelper.class);

    public static Optional<Property> getTextPropertyForLanguage(Element element, String language) {
        Iterable properties = BcSchema.TEXT.getProperties(element);
        Property property = (Property)Iterables.single((Iterable)Iterables.filter(p -> {
            if (p.getMetadata().containsKey(BcSchema.TEXT_LANGUAGE_METADATA.getMetadataKey())) {
                String textLanguage = (String)BcSchema.TEXT_LANGUAGE_METADATA.getMetadataValue(p);
                return StringUtils.equals((CharSequence)language, (CharSequence)textLanguage);
            }
            return false;
        }, (Iterable)properties), null);
        return Optional.ofNullable(property);
    }

    public static String getTextLanguage(Property textProperty) {
        if (textProperty.getMetadata().containsKey(BcSchema.TEXT_LANGUAGE_METADATA.getMetadataKey())) {
            return (String)BcSchema.TEXT_LANGUAGE_METADATA.getMetadataValue(textProperty);
        }
        return null;
    }
}

