/*
 * Decompiled with CFR 0.152.
 */
package io.bigconnect.dw.text.common;

import com.mware.core.model.termMention.TermMentionRepository;
import com.mware.core.model.termMention.TermMentionUtils;
import com.mware.ge.Authorizations;
import com.mware.ge.Graph;
import com.mware.ge.Vertex;
import io.bigconnect.dw.text.common.TextSpan;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class NerUtils {
    private static final String BLANK_LINE = "(?<=(\r\n|\r|\n))([ \\t]*$)+";
    private static final Pattern paragraphSplitter = Pattern.compile("(?<=(\r\n|\r|\n))([ \\t]*$)+", 8);

    public static synchronized void removeEntityTermMentions(Vertex outVertex, TermMentionRepository termMentionRepository, TermMentionUtils termMentionUtils, Graph graph, Authorizations authorizations) {
        termMentionRepository.deleteTermMentions("", outVertex.getId(), authorizations);
        termMentionRepository.deleteTermMentions("ent", outVertex.getId(), authorizations);
        termMentionUtils.removeHasDetectedEntityRelations(outVertex);
        graph.flush();
    }

    public static synchronized void removeSentimentTermMentions(Vertex outVertex, TermMentionRepository termMentionRepository, Graph graph, Authorizations authorizations) {
        termMentionRepository.deleteTermMentions("sent", outVertex.getId(), authorizations);
        graph.flush();
    }

    public static List<TextSpan> getParagraphs(String text) {
        if (StringUtils.isEmpty((String)text)) {
            return Collections.emptyList();
        }
        ArrayList<TextSpan> result = new ArrayList<TextSpan>();
        Matcher m = paragraphSplitter.matcher(text);
        int start = 0;
        while (m.find()) {
            int i;
            int end = m.start();
            String found = text.subSequence(start, end).toString();
            if (StringUtils.isEmpty((String)found.trim())) continue;
            int innerStart = 0;
            int innerEnd = found.length();
            char[] arr = found.toCharArray();
            for (i = 0; i < arr.length && (arr[i] == '\n' || arr[i] == '\r'); ++i) {
                ++start;
                ++innerStart;
            }
            for (i = arr.length - 1; i >= 0 && (arr[i] == '\n' || arr[i] == '\r'); --i) {
                --end;
                --innerEnd;
            }
            TextSpan ann = new TextSpan(start, end, found.substring(innerStart, innerEnd));
            result.add(ann);
            start = m.end();
        }
        if (result.isEmpty() && text.trim().length() > 0) {
            result.add(new TextSpan(0, text.length(), text));
        }
        return result;
    }

    public static void main(String[] args) {
        List<TextSpan> p = NerUtils.getParagraphs("\r\nSentence1\nSentence2\n\nSentence3\nSentence4\r\nSentence5\r\n\r\n");
        System.out.println(p.size());
    }
}

