/*
 * Decompiled with CFR 0.152.
 */
package io.bigconnect.dw.tester;

import com.mware.core.model.clientapi.dto.VisibilityJson;
import com.mware.core.model.properties.BcSchema;
import com.mware.core.model.properties.types.PropertyMetadata;
import com.mware.core.model.workQueue.Priority;
import com.mware.core.model.workQueue.WorkQueueRepository;
import com.mware.core.user.SystemUser;
import com.mware.core.user.User;
import com.mware.ge.Authorizations;
import com.mware.ge.Element;
import com.mware.ge.Graph;
import com.mware.ge.Metadata;
import com.mware.ge.Visibility;
import com.mware.ge.values.storable.ByteArray;
import com.mware.ge.values.storable.DefaultStreamingPropertyValue;
import com.mware.ge.values.storable.StreamingPropertyValue;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.Values;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class EntityCreator {
    private Graph graph;
    private WorkQueueRepository workQueueRepository;
    private Authorizations authorizations;
    private Element element;

    public static EntityCreator build(Graph graph, WorkQueueRepository workQueueRepository) {
        return new EntityCreator(graph, workQueueRepository);
    }

    private EntityCreator(Graph graph, WorkQueueRepository workQueueRepository) {
        this.graph = graph;
        this.workQueueRepository = workQueueRepository;
        this.authorizations = new Authorizations(new String[0]);
    }

    public EntityCreator with(Element element) {
        this.element = element;
        return this;
    }

    public EntityCreator newVideo(String title, InputStream file) {
        this.element = this.graph.prepareVertex(Visibility.EMPTY, "video").save(this.authorizations);
        this.setTitle(title);
        try {
            this.addRaw(IOUtils.toByteArray((InputStream)file));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public EntityCreator newDocument(String title, String text) {
        this.element = this.graph.prepareVertex(Visibility.EMPTY, "document").save(this.authorizations);
        this.setTitle(title);
        this.setText("", text);
        return this;
    }

    public EntityCreator setText(String key, String text) {
        Metadata propertyMetadata = this.createPropertyMetadata();
        BcSchema.MIME_TYPE_METADATA.setMetadata(propertyMetadata, (Object)"text/plain", Visibility.EMPTY);
        BcSchema.TEXT_DESCRIPTION_METADATA.setMetadata(propertyMetadata, (Object)"Text", Visibility.EMPTY);
        String value = StringUtils.trimToEmpty((String)text);
        this.element = this.element.prepareMutation().addPropertyValue(key, BcSchema.TEXT.getPropertyName(), (Value)DefaultStreamingPropertyValue.create((String)value), propertyMetadata, Visibility.EMPTY).save(this.authorizations);
        return this;
    }

    public EntityCreator addRaw(byte[] bytes) {
        StreamingPropertyValue rawValue = DefaultStreamingPropertyValue.create((InputStream)new ByteArrayInputStream(bytes), ByteArray.class);
        rawValue.searchIndex(false);
        this.element = this.element.prepareMutation().setProperty(BcSchema.RAW.getPropertyName(), (Value)rawValue, this.createPropertyMetadata(), Visibility.EMPTY).save(this.authorizations);
        return this;
    }

    public EntityCreator setTitle(String title) {
        this.element = this.element.prepareMutation().setProperty(BcSchema.TITLE.getPropertyName(), (Value)Values.stringValue((String)title), this.createPropertyMetadata(), Visibility.EMPTY).save(this.authorizations);
        return this;
    }

    public EntityCreator setProperty(String property, Object value) {
        this.element = this.element.prepareMutation().setProperty(property, Values.of((Object)value), this.createPropertyMetadata(), Visibility.EMPTY).save(this.authorizations);
        return this;
    }

    public Metadata createPropertyMetadata() {
        return new PropertyMetadata(ZonedDateTime.now(), (User)new SystemUser(), new VisibilityJson(), Visibility.EMPTY).createMetadata();
    }

    public Element push() {
        return this.push(null, null);
    }

    public Element push(String property, String key) {
        this.workQueueRepository.pushGraphPropertyQueue(this.element, key, property, null, null, Priority.HIGH, null, null);
        return this.element;
    }
}

