/*
 * Decompiled with CFR 0.152.
 */
package io.bigconnect.dw.ner.common.util;

import com.google.gson.Gson;
import com.mware.core.config.Configuration;
import io.bigconnect.dw.ner.common.extractor.ExtractedEntities;
import io.bigconnect.dw.ner.common.extractor.OrganizationOccurrence;
import io.bigconnect.dw.ner.common.extractor.PersonOccurrence;
import io.bigconnect.dw.ner.common.extractor.SentenceLocationOccurrence;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MuckUtils {
    public static ExtractedEntities entitiesFromNlpJsonString(String nlpJsonString, Configuration configuration) {
        Map sentences = MuckUtils.sentencesFromJsonString(nlpJsonString);
        return MuckUtils.entitiesFromNlpSentenceMap(sentences, configuration);
    }

    public static Map sentencesFromJsonString(String nlpJsonString) {
        Gson gson = new Gson();
        Map content = (Map)gson.fromJson(nlpJsonString, Map.class);
        return content;
    }

    private static ExtractedEntities entitiesFromNlpSentenceMap(Map mcSentences, Configuration configuration) {
        ExtractedEntities entities = new ExtractedEntities(configuration);
        Iterator it = mcSentences.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry pairs = it.next();
            String storySentencesId = pairs.getKey().toString();
            if (storySentencesId.equals(Character.valueOf('_'))) continue;
            Map corenlp = (Map)pairs.getValue();
            List nlpSentences = (List)((Map)corenlp.get("corenlp")).get("sentences");
            for (Map sentence : nlpSentences) {
                String queuedEntityText = null;
                String lastEntityType = null;
                List tokens = (List)sentence.get("tokens");
                for (Map token : tokens) {
                    String entityType = (String)token.get("ne");
                    String tokenText = (String)token.get("word");
                    if (entityType.equals(lastEntityType)) {
                        queuedEntityText = queuedEntityText + " " + tokenText;
                    } else {
                        if (queuedEntityText != null && lastEntityType != null) {
                            switch (lastEntityType) {
                                case "PERSON": {
                                    entities.addPerson(new PersonOccurrence(queuedEntityText, 0));
                                    break;
                                }
                                case "LOCATION": {
                                    entities.addLocation(new SentenceLocationOccurrence(queuedEntityText, storySentencesId));
                                    break;
                                }
                                case "ORGANIZATION": {
                                    entities.addOrganization(new OrganizationOccurrence(queuedEntityText, 0));
                                }
                            }
                        }
                        queuedEntityText = tokenText;
                    }
                    lastEntityType = entityType;
                }
            }
            it.remove();
        }
        return entities;
    }
}

